/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.meth;

import com.mandelsoft.mand.meth.BigDecimalMandIterator;
import com.mandelsoft.mand.meth.PixelIterator;
import com.mandelsoft.mand.util.MandArith;
import com.mandelsoft.mand.util.MandUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class OptimizedBigDecimalMandIterator
extends BigDecimalMandIterator
implements PixelIterator.PropertySource,
PixelIterator.Setup,
PixelIterator.Cleanup {
    private static boolean accept_all_depths = false;
    private Coord stdref;
    private int stdrefDepth;
    private Coord[] stdIterations;
    private Coord ref;
    private int refDepth;
    private Coord[] iterations;
    private int refPixelX;
    private int refPixelY;
    private File refFile = null;
    private boolean refSaved = false;
    private Coord[] saved;
    private PixelIterator.PropertySource.PropertyHandler handler;

    public OptimizedBigDecimalMandIterator(BigDecimal x0, BigDecimal y0, BigDecimal dx, BigDecimal dy, int rx, int ry, int limit, Map<String, String> properties) {
        super(x0, y0, dx, dy, rx, ry, limit);
        try {
            if (!accept_all_depths) {
                this.refFile = File.createTempFile("mandelref", "ref");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("prec: " + this.bits + " (" + Math.ceil((double)this.bits * Math.log10(2.0)) + ")");
        this.iterations = new Coord[limit + 1];
        this.saved = null;
        if (!accept_all_depths && limit <= 2000000) {
            this.saved = new Coord[limit + 1];
        }
        if (properties != null) {
            if (properties.containsKey("standard-reference-coordinates")) {
                try {
                    this.stdref = Coord.parse(properties.get("standard-reference-coordinates"));
                    System.out.printf("found standard ref %s\n", this.stdref);
                    this.stdIterations = new Coord[limit + 1];
                }
                catch (NumberFormatException ex) {
                    System.out.printf("malformed standard reference coordinates '%s': %s\n", properties.get("standard-reference-coordinates"), ex.getMessage());
                }
                this.ref = this.stdref;
            }
            if (properties.containsKey("reference-coordinates")) {
                try {
                    this.ref = new Coord(Coord.parse(properties.get("reference-coordinates")));
                    System.out.printf("found ref %s\n", this.ref);
                }
                catch (NumberFormatException ex) {
                    System.out.printf("malformed reference coordinates '%s': %s\n", properties.get("reference-coordinates"), ex.getMessage());
                }
            }
            if (properties.containsKey("reference-pixel")) {
                try {
                    Coord p = Coord.parse(properties.get("reference-pixel"));
                    System.out.printf("found ref pixel %s\n", p);
                    this.refPixelX = (int)p.getXasDouble();
                    this.refPixelY = (int)p.getYasDouble();
                }
                catch (NumberFormatException ex) {
                    System.out.printf("malformed reference pixel '%s': %s\n", properties.get("reference-pixel"), ex.getMessage());
                }
            }
        }
        if (this.ref == null) {
            this.ref = new Coord(this.add(x0, this.div(dx, 2.0)), this.sub(y0, this.div(dy, 2.0)));
        }
    }

    @Override
    public void setup() {
        if (this.stdref != null) {
            this.stdrefDepth = this.buildref("standard", this.stdIterations, this.ref);
        }
        this.refDepth = this.buildref(null, this.iterations, this.ref);
        this.setProperties(-1, -1, this.ref, this.refDepth);
    }

    @Override
    public void cleanup() {
        if (this.refFile != null) {
            this.refFile.delete();
        }
    }

    int buildref(String msg, Coord[] iterations, Coord ref) {
        BigDecimal X = ref.getX();
        BigDecimal Y = ref.getY();
        BigDecimal x = X;
        BigDecimal y = Y;
        msg = msg == null || msg.equals("") ? "" : msg + " ";
        System.out.printf("calculating %sref with limit %d for %s\n", msg, this.limit, ref);
        long stime = System.currentTimeMillis();
        iterations[0] = ref;
        BigDecimal x2 = this.mul(x, x);
        BigDecimal y2 = this.mul(y, y);
        int it = 0;
        while (this.add(x2, y2).compareTo(this.bound) < 0 && ++it <= this.limit) {
            BigDecimal xn = this.add(this.sub(x2, y2), X);
            BigDecimal yn = this.add(this.mul(this.mul(MandArith.b2, x), y), Y);
            x = xn;
            x2 = this.mul(x, x);
            y = yn;
            y2 = this.mul(y, y);
            iterations[it] = new Coord(x, y);
        }
        long etime = System.currentTimeMillis();
        System.out.printf("ref done: it=%d, %s\n", it, MandUtils.time((int)((etime - stime) / 1000L)));
        if (it < this.limit) {
            iterations[it + 1] = null;
        }
        return it;
    }

    private void setProperties(int x, int y, Coord c, int depth) {
        if (this.handler != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("reference-coordinates", c.toString());
            if (x >= 0 || y >= 0) {
                Coord p = new Coord(x, y);
                map.put("reference-pixel", p.toString());
            } else {
                map.put("reference-pixel", null);
            }
            if (depth > 0) {
                map.put("reference-depth", Integer.toString(depth));
            } else {
                map.put("reference-depth", null);
            }
            this.handler.updateProperties(map);
        }
    }

    public int iter(Coord[] iterations, Coord ref) {
        double ox0 = this.sub(this.cx, ref.getX()).doubleValue();
        double oy0 = this.sub(this.cy, ref.getY()).doubleValue();
        double ox = ox0;
        double oy = oy0;
        for (int i = 0; i <= this.limit; ++i) {
            if (iterations[i] == null) {
                return -1;
            }
            double mx = 2.0 * iterations[i].x * ox;
            double my = 2.0 * iterations[i].y * oy;
            double ox2 = ox * ox;
            double oy2 = oy * oy;
            double dist = iterations[i].sqs + mx + my + ox2 + oy2;
            if (dist >= 10.0) {
                return i;
            }
            double fx = mx - my;
            double fy = 2.0 * (iterations[i].x * oy + iterations[i].y * ox);
            double qx = ox2 - oy2;
            double qy = 2.0 * ox * oy;
            ox = fx + qx + ox0;
            oy = fy + qy + oy0;
        }
        return this.limit + 1;
    }

    @Override
    public int iter() {
        Coord[] tmp;
        ++this.cnt;
        int depth = -1;
        if (this.stdref != null) {
            depth = this.iter(this.stdIterations, this.stdref);
        }
        if (depth < 0) {
            depth = this.iter(this.iterations, this.ref);
        }
        if (depth >= 0) {
            return depth;
        }
        Coord oldref = this.ref;
        this.ref = new Coord(this.cx, this.cy);
        System.out.printf("%d exceeded ref limit %d\n", this.cnt, this.refDepth);
        if (this.saved != null) {
            tmp = this.iterations;
            this.iterations = this.saved;
            this.saved = tmp;
            this.refSaved = true;
        } else if (!this.refSaved && this.refFile != null) {
            System.out.printf("saving old ref to %s\n", this.refFile);
            try {
                Coord.writeCoords(this.refFile, this.iterations);
                this.refSaved = true;
            }
            catch (IOException ex) {
                System.out.printf("saving failed: %s\n", ex);
                this.refSaved = false;
            }
        }
        depth = this.buildref(null, this.iterations, this.ref);
        if (this.refSaved && depth < this.refDepth) {
            System.out.printf("---------- depth not increased -> keep old ref\n", new Object[0]);
            if (this.saved != null) {
                tmp = this.iterations;
                this.iterations = this.saved;
                this.saved = tmp;
                this.refSaved = false;
                this.ref = oldref;
                if (this.handler != null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("reference-corrupted", "true");
                    this.handler.updateProperties(map);
                }
            } else {
                try {
                    Coord.readCoords(this.refFile, this.iterations);
                    this.ref = oldref;
                    if (this.handler != null) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("reference-corrupted", "true");
                        this.handler.updateProperties(map);
                    }
                }
                catch (IOException ex) {
                    System.out.printf("restore failed: %s\n", ex);
                    this.refPixelX = this.x;
                    this.refPixelY = this.y;
                    this.refDepth = depth;
                    this.refSaved = false;
                    this.setProperties(this.x, this.y, this.ref, depth);
                }
            }
        } else {
            if (this.refSaved) {
                System.out.printf("old depth %d -> new depth %d\n", this.refDepth, depth);
            } else {
                System.out.printf("-> new depth %d\n", depth);
            }
            this.refPixelX = this.x;
            this.refPixelY = this.y;
            this.refDepth = depth;
            this.refSaved = false;
            this.setProperties(this.x, this.y, this.ref, depth);
        }
        return depth;
    }

    @Override
    public void setPropertyHandler(PixelIterator.PropertySource.PropertyHandler h) {
        this.handler = h;
        if (h != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pixel-iteration-method", this.getClass().getName());
            h.updateProperties(map);
        }
    }

    public static class Coord
    extends com.mandelsoft.mand.Coord {
        double x;
        double y;
        double sqs;

        public Coord(com.mandelsoft.mand.Coord c) {
            this(c.getX(), c.getY());
        }

        public Coord(double cx, double cy) {
            super(cx, cy);
            this.x = cx;
            this.y = cy;
            this.sqs = MandArith.add(MandArith.mul(this.getX(), this.getY()), MandArith.mul(this.getY(), this.getY())).doubleValue();
        }

        public Coord(BigDecimal cx, BigDecimal cy) {
            super(cx, cy);
            this.x = cx.doubleValue();
            this.y = cy.doubleValue();
            this.sqs = MandArith.add(MandArith.mul(cx, cx), MandArith.mul(cy, cy)).doubleValue();
        }

        public double getXasDouble() {
            return this.x;
        }

        public double getYasDouble() {
            return this.y;
        }

        public static Coord parse(String s) throws NumberFormatException {
            return new Coord(com.mandelsoft.mand.Coord.parse(s));
        }

        public static void writeCoords(File file, Coord[] list) throws IOException {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            for (Coord c : list) {
                if (c == null) break;
                out.write(c.toString() + "\n");
            }
            out.close();
        }

        public static void readCoords(File file, Coord[] list) throws IOException {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            int i = 0;
            while ((line = in.readLine()) != null) {
                try {
                    Coord c = Coord.parse(line);
                    if (i >= list.length) {
                        throw new IOException("read more than " + list.length + " entries");
                    }
                    list[i++] = c;
                }
                catch (NumberFormatException ex) {
                    throw new IOException(ex);
                }
            }
            if (i < list.length) {
                list[i] = null;
            }
            in.close();
        }
    }
}

