/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.meth;

import com.mandelsoft.mand.meth.BigDecimalMandIterator;
import com.mandelsoft.mand.meth.BigExpDouble;
import com.mandelsoft.mand.meth.PixelIterator;
import com.mandelsoft.mand.util.MandArith;
import com.mandelsoft.mand.util.MandUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class OptimizedLongBigDecimalMandIterator
extends BigDecimalMandIterator
implements PixelIterator.PropertySource,
PixelIterator.Setup,
PixelIterator.Cleanup {
    public static BigExpDouble BOUND = new BigExpDouble(10.0);
    private static boolean accept_all_depths = true;
    private static int memory_depth_limit = 800000;
    private Coord ref;
    private int refPixelX;
    private int refPixelY;
    private File refFile = null;
    private boolean refSaved = false;
    private int refDepth;
    private Coord[] iterations;
    private Coord[] saved;
    private PixelIterator.PropertySource.PropertyHandler handler;

    public OptimizedLongBigDecimalMandIterator(BigDecimal x0, BigDecimal y0, BigDecimal dx, BigDecimal dy, int rx, int ry, int limit, Map<String, String> properties) {
        super(x0, y0, dx, dy, rx, ry, limit);
        try {
            if (!accept_all_depths && limit <= memory_depth_limit) {
                this.refFile = File.createTempFile("mandelref", "ref");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("prec: " + this.bits + " (" + Math.ceil((double)this.bits * Math.log10(2.0)) + ")");
        this.iterations = new Coord[limit + 1];
        this.saved = null;
        if (!accept_all_depths && limit <= 2000000) {
            this.saved = new Coord[limit + 1];
        }
        if (properties != null) {
            String msg = null;
            if (properties.containsKey("reference-coordinates")) {
                try {
                    this.ref = new Coord(Coord.parse(properties.get("reference-coordinates")));
                    msg = String.format("found ref %s", this.ref);
                }
                catch (NumberFormatException ex) {
                    System.out.printf("malformed reference coordinates '%s': %s\n", properties.get("reference-coordinates"), ex.getMessage());
                }
            }
            if (properties.containsKey("reference-pixel")) {
                try {
                    Coord p = Coord.parse(properties.get("reference-pixel"));
                    msg = msg == null ? String.format("found ref pixel %s", p) : msg + String.format(" at pixel %s", p);
                    this.refPixelX = p.getX().intValue();
                    this.refPixelY = p.getY().intValue();
                }
                catch (NumberFormatException ex) {
                    System.out.printf("malformed reference pixel '%s': %s\n", properties.get("reference-pixel"), ex.getMessage());
                }
            }
            if (msg != null) {
                System.out.println(msg);
            }
        }
        if (this.ref == null) {
            this.ref = new Coord(this.add(x0, this.div(dx, 2.0)), this.sub(y0, this.div(dy, 2.0)));
        }
    }

    @Override
    public void setup() {
        this.refDepth = this.buildref(this.iterations, this.ref);
        this.setProperties(-1, -1, this.ref, this.refDepth);
    }

    @Override
    public void cleanup() {
        if (this.refFile != null) {
            this.refFile.delete();
        }
    }

    int buildref(Coord[] iterations, Coord ref) {
        BigDecimal X = ref.getX();
        BigDecimal Y = ref.getY();
        BigDecimal x = X;
        BigDecimal y = Y;
        System.out.printf("calculating ref with limit %d for %s\n", this.limit, ref);
        long stime = System.currentTimeMillis();
        iterations[0] = ref;
        BigDecimal x2 = this.mul(x, x);
        BigDecimal y2 = this.mul(y, y);
        int it = 0;
        while (this.add(x2, y2).compareTo(this.bound) < 0 && ++it <= this.limit) {
            BigDecimal xn = this.add(this.sub(x2, y2), X);
            BigDecimal yn = this.add(this.mul(this.mul(MandArith.b2, x), y), Y);
            x = xn;
            x2 = this.mul(x, x);
            y = yn;
            y2 = this.mul(y, y);
            iterations[it] = new Coord(x, y);
        }
        long etime = System.currentTimeMillis();
        System.out.printf("ref done: it=%d, %s\n", it, MandUtils.time((int)((etime - stime) / 1000L)));
        if (it < this.limit) {
            iterations[it + 1] = null;
        }
        return it;
    }

    private void setProperties(int x, int y, Coord c, int depth) {
        if (this.handler != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("reference-coordinates", c.toString());
            if (x >= 0 || y >= 0) {
                Coord p = new Coord(x, y);
                map.put("reference-pixel", p.toString());
            } else {
                map.put("reference-pixel", null);
            }
            if (depth > 0) {
                map.put("reference-depth", Integer.toString(depth));
            } else {
                map.put("reference-depth", null);
            }
            this.handler.updateProperties(map);
        }
    }

    @Override
    public int iter() {
        ++this.cnt;
        BigExpDouble ox0 = new BigExpDouble(this.sub(this.cx, this.ref.getX()));
        BigExpDouble oy0 = new BigExpDouble(this.sub(this.cy, this.ref.getY()));
        BigExpDouble ox = ox0;
        BigExpDouble oy = oy0;
        for (int i = 0; i <= this.limit; ++i) {
            if (this.iterations[i] == null) {
                Coord oldref = this.ref;
                this.ref = new Coord(this.cx, this.cy);
                System.out.printf("%d exceeded ref limit %d\n", this.cnt, i - 1);
                if (this.saved != null) {
                    Coord[] tmp = this.iterations;
                    this.iterations = this.saved;
                    this.saved = tmp;
                    this.refSaved = true;
                } else if (!this.refSaved && this.refFile != null) {
                    System.out.printf("saving old ref to %s\n", this.refFile);
                    try {
                        Coord.writeCoords(this.refFile, this.iterations);
                        this.refSaved = true;
                    }
                    catch (IOException ex) {
                        System.out.printf("saving failed: %s\n", ex);
                        this.refSaved = false;
                    }
                }
                int depth = this.buildref(this.iterations, this.ref);
                if (this.refSaved && depth < this.refDepth) {
                    System.out.printf("---------- depth not increased -> keep old ref\n", new Object[0]);
                    if (this.saved != null) {
                        Coord[] tmp = this.iterations;
                        this.iterations = this.saved;
                        this.saved = tmp;
                        this.refSaved = false;
                        this.ref = oldref;
                        if (this.handler != null) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("reference-corrupted", "true");
                            this.handler.updateProperties(map);
                        }
                    } else {
                        try {
                            Coord.readCoords(this.refFile, this.iterations);
                            this.ref = oldref;
                            if (this.handler != null) {
                                HashMap<String, String> map = new HashMap<String, String>();
                                map.put("reference-corrupted", "true");
                                this.handler.updateProperties(map);
                            }
                        }
                        catch (IOException ex) {
                            System.out.printf("restore failed: %s\n", ex);
                            this.refPixelX = this.x;
                            this.refPixelY = this.y;
                            this.refDepth = depth;
                            this.refSaved = false;
                            this.setProperties(this.x, this.y, this.ref, depth);
                        }
                    }
                } else {
                    this.refPixelX = this.x;
                    this.refPixelY = this.y;
                    this.refDepth = depth;
                    this.refSaved = false;
                    this.setProperties(this.x, this.y, this.ref, depth);
                }
                return depth;
            }
            BigExpDouble ox2 = ox.square();
            BigExpDouble oy2 = oy.square();
            BigExpDouble mx = this.iterations[i].x.mul(ox).mul2();
            BigExpDouble my = this.iterations[i].y.mul(oy).mul2();
            BigExpDouble dist = this.iterations[i].sqs.add(mx).add(my).add(ox2).add(oy2);
            if (dist.gt(BOUND)) {
                return i;
            }
            BigExpDouble fx = mx.sub(my);
            BigExpDouble fy = this.iterations[i].x.mul(oy).add(this.iterations[i].y.mul(ox)).mul2();
            BigExpDouble qx = ox2.sub(oy2);
            BigExpDouble qy = ox.mul(oy).mul2();
            ox = fx.add(qx).add(ox0);
            oy = fy.add(qy).add(oy0);
        }
        return this.limit + 1;
    }

    @Override
    public void setPropertyHandler(PixelIterator.PropertySource.PropertyHandler h) {
        this.handler = h;
        if (h != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pixel-iteration-method", this.getClass().getName());
            h.updateProperties(map);
        }
    }

    public static class Coord
    extends com.mandelsoft.mand.Coord {
        BigExpDouble x;
        BigExpDouble y;
        BigExpDouble sqs;

        public Coord(com.mandelsoft.mand.Coord c) {
            this(c.getX(), c.getY());
        }

        public Coord(double cx, double cy) {
            super(cx, cy);
            this.x = new BigExpDouble(cx);
            this.y = new BigExpDouble(cy);
            this.sqs = this.x.square().add(this.y.square());
        }

        public Coord(BigDecimal cx, BigDecimal cy) {
            super(cx, cy);
            this.x = new BigExpDouble(cx);
            this.y = new BigExpDouble(cy);
            this.sqs = this.x.square().add(this.y.square());
        }

        public BigExpDouble getXasDouble() {
            return this.x;
        }

        public BigExpDouble getYasDouble() {
            return this.y;
        }

        public static Coord parse(String s) throws NumberFormatException {
            return new Coord(com.mandelsoft.mand.Coord.parse(s));
        }

        public static void writeCoords(File file, Coord[] list) throws IOException {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            for (Coord c : list) {
                if (c == null) break;
                out.write(c.toString() + "\n");
            }
            out.close();
        }

        public static void readCoords(File file, Coord[] list) throws IOException {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            int i = 0;
            while ((line = in.readLine()) != null) {
                try {
                    Coord c = Coord.parse(line);
                    if (i >= list.length) {
                        throw new IOException("read more than " + list.length + " entries");
                    }
                    list[i++] = c;
                }
                catch (NumberFormatException ex) {
                    throw new IOException(ex);
                }
            }
            if (i < list.length) {
                list[i] = null;
            }
            in.close();
        }
    }
}

