/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.meth;

import com.mandelsoft.mand.MandelConstants;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class PixelArith
implements MandelConstants {
    protected MathContext ctx;
    protected int bits;

    public PixelArith() {
        this.setPrecision(450);
    }

    public PixelArith(int precision) {
        this.setPrecision(precision);
    }

    protected final void setPrecision(int precision) {
        this.bits = (int)((double)precision / Math.log10(2.0));
        this.ctx = new MathContext(precision, RoundingMode.HALF_EVEN);
    }

    protected void setPrecision(BigDecimal dx, BigDecimal dy, int rx, int ry) {
        this.setPrecision(this.calcDigits(dx, dy, rx, ry));
    }

    public int calcDigits(BigDecimal dx, BigDecimal dy, int rx, int ry) {
        BigDecimal dX = dx.divide(BigDecimal.valueOf(rx), MC);
        BigDecimal dY = dy.divide(BigDecimal.valueOf(ry), MC);
        BigDecimal d = dX;
        if (dX.compareTo(dY) > 0) {
            d = dY;
        }
        int p = 0;
        while (d.compareTo(BigDecimal.ONE) < 0) {
            ++p;
            d = this.mul(d, BigDecimal.TEN);
        }
        return p + 2;
    }

    public BigDecimal mul(BigDecimal a, BigDecimal b) {
        return a.multiply(b, this.ctx);
    }

    public BigDecimal mul(BigDecimal a, double b) {
        return a.multiply(BigDecimal.valueOf(b), this.ctx);
    }

    public BigDecimal div(BigDecimal a, BigDecimal b) {
        return a.divide(b, this.ctx);
    }

    public BigDecimal div(BigDecimal a, double b) {
        return a.divide(BigDecimal.valueOf(b), this.ctx);
    }

    public BigDecimal div(double a, BigDecimal b) {
        return BigDecimal.valueOf(a).divide(b, this.ctx);
    }

    public BigDecimal div(double a, double b) {
        return BigDecimal.valueOf(a / b);
    }

    public BigDecimal add(BigDecimal a, BigDecimal b) {
        return a.add(b, this.ctx);
    }

    public BigDecimal add(BigDecimal a, double b) {
        return a.add(BigDecimal.valueOf(b), this.ctx);
    }

    public BigDecimal sub(BigDecimal a, BigDecimal b) {
        return a.subtract(b, this.ctx);
    }

    public BigDecimal sub(BigDecimal a, double b) {
        return a.subtract(BigDecimal.valueOf(b), this.ctx);
    }

    public BigDecimal sub(double a, BigDecimal b) {
        return BigDecimal.valueOf(a).subtract(b, this.ctx);
    }

    int minScale(BigDecimal d) {
        int s = d.scale();
        while (d.compareTo(BigDecimal.ZERO) != 0) {
            d = d.setScale(d.scale() - 1, RoundingMode.HALF_EVEN);
            --s;
        }
        return s;
    }

    public BigDecimal round(BigDecimal a, BigDecimal b, int res) {
        return this.round(a, b, res, 1);
    }

    public BigDecimal round(BigDecimal a, BigDecimal b, int res, int r) {
        b = this.div(b, (double)res);
        int m = this.minScale(b) + 1 + r;
        a = a.setScale(m, RoundingMode.HALF_EVEN);
        if (m < 0 && m > -4) {
            a = a.setScale(0);
        }
        return a;
    }
}

