/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.movie;

import com.mandelsoft.mand.MandIter;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelRaster;
import com.mandelsoft.mand.meth.PixelIterator;
import java.math.BigDecimal;

public class MandelAccess {
    private MandelData data;
    private MandelInfo info;
    private PixelIterator pi;
    private MandelRaster raster;
    private int rx;
    private int ry;
    private boolean xset;
    private BigDecimal cx;
    private double ix;
    private boolean yset;
    private BigDecimal cy;
    private double iy;

    public MandelAccess(MandelData data) {
        this.data = data;
        this.info = data.getInfo();
        this.rx = this.info.getRX();
        this.ry = this.info.getRY();
        this.pi = MandIter.createPixelIterator(this.info);
        this.raster = data.getRaster();
    }

    public MandelData getMandelData() {
        return this.data;
    }

    public MandelInfo getInfo() {
        return this.data.getInfo();
    }

    public boolean contains(BigDecimal x, BigDecimal y) {
        return this.info.contains(x, y);
    }

    public boolean containsY(BigDecimal y) {
        return this.info.containsY(y);
    }

    public boolean containsX(BigDecimal x) {
        return this.info.containsX(x);
    }

    public double getX(BigDecimal x) {
        return this.pi.getX(x);
    }

    public double getY(BigDecimal y) {
        return this.pi.getY(y);
    }

    public int getIter(int x, int y) {
        int i = this.raster.getData(x, y);
        if (i == 0) {
            return this.info.getLimitIt() + 1;
        }
        return i;
    }

    public void setX(BigDecimal x) {
        this.cx = x;
        this.xset = true;
    }

    public void setY(BigDecimal y) {
        this.cy = y;
        this.yset = true;
    }

    public int getIter() {
        if (this.xset) {
            this.ix = this.getX(this.cx);
            this.xset = false;
        }
        if (this.yset) {
            this.iy = this.getY(this.cy);
            this.yset = false;
        }
        return this.getIter(this.ix, this.iy);
    }

    public int getIter(BigDecimal x, BigDecimal y) {
        return this.getIter(this.getX(x), this.getY(y));
    }

    private int getIter(double ix, double iy) {
        if (ix < 0.0) {
            ix = 0.0;
        }
        if (ix >= (double)this.rx) {
            iy = this.rx - 1;
        }
        if (iy < 0.0) {
            iy = 0.0;
        }
        if (iy >= (double)this.ry) {
            iy = this.ry - 1;
        }
        int xmin = (int)Math.floor(ix);
        int xmax = (int)Math.ceil(ix);
        int ymin = (int)Math.floor(iy);
        int ymax = (int)Math.ceil(iy);
        if (xmin < 0) {
            xmin = xmax;
        }
        if (xmax >= this.rx) {
            xmax = xmin;
        }
        if (ymin < 0) {
            ymin = ymax;
        }
        if (ymax >= this.ry) {
            ymax = ymin;
        }
        int a00 = this.getIter(xmin, ymin);
        int a01 = this.getIter(xmin, ymax);
        int a10 = this.getIter(xmax, ymin);
        int a11 = this.getIter(xmax, ymax);
        double fx = ix - (double)xmin;
        double fy = iy - (double)ymin;
        int i = (int)((double)(a11 - a10 - a01 + a00) * fx * fy + (double)(a01 - a00) * fy + (double)(a10 - a00) * fx + (double)a00);
        return i;
    }
}

