/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.movie;

import com.xuggle.mediatool.IMediaWriter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.xuggler.ICodec;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.concurrent.TimeUnit;

public class ScreenMovie {
    private static final double FRAME_RATE = 50.0;
    private static final int SECONDS_TO_RUN_FOR = 20;
    private static final String outputFilename = "mydesktop.mp4";
    private static Dimension screenBounds;

    public static void main(String[] args) {
        IMediaWriter writer = ToolFactory.makeWriter((String)outputFilename);
        screenBounds = Toolkit.getDefaultToolkit().getScreenSize();
        writer.addVideoStream(0, 0, ICodec.ID.CODEC_ID_MPEG4, ScreenMovie.screenBounds.width / 2, ScreenMovie.screenBounds.height / 2);
        long startTime = System.nanoTime();
        int index = 0;
        while ((double)index < 1000.0) {
            BufferedImage screen = ScreenMovie.getDesktopScreenshot();
            BufferedImage bgrScreen = ScreenMovie.convertToType(screen, 5);
            writer.encodeVideo(0, bgrScreen, System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++index;
        }
        writer.close();
    }

    public static BufferedImage convertToType(BufferedImage sourceImage, int targetType) {
        BufferedImage image;
        if (sourceImage.getType() == targetType) {
            image = sourceImage;
        } else {
            image = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), targetType);
            image.getGraphics().drawImage(sourceImage, 0, 0, null);
        }
        return image;
    }

    private static BufferedImage getDesktopScreenshot() {
        try {
            Robot robot = new Robot();
            Rectangle captureSize = new Rectangle(screenBounds);
            return robot.createScreenCapture(captureSize);
        }
        catch (AWTException e) {
            e.printStackTrace();
            return null;
        }
    }
}

