/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.movie;

import com.mandelsoft.mand.movie.FadedMovieDecoration;
import com.mandelsoft.mand.tool.Decoration;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;

public class VerticalListMovieDecoration
extends FadedMovieDecoration {
    private List<Decoration> decos = new ArrayList<Decoration>();
    private boolean prepared;
    private int gap;

    public VerticalListMovieDecoration(int gap, long start, long fadein, long show, long fadeout) {
        super(start, fadein, show, fadeout);
        this.gap = gap;
    }

    public void addDecoration(Decoration d) {
        this.decos.add(d);
    }

    protected void prepare() {
        if (!this.prepared) {
            double cnt = this.decos.size();
            double o = -(cnt - 1.0) / 2.0;
            for (Decoration d : this.decos) {
                double d2 = o;
                o = d2 + 1.0;
                int offset = (int)(d2 * (double)this.gap);
                d.setVInset(offset + d.getVInset());
            }
            this.prepared = true;
        }
    }

    @Override
    public void paintDecoration(long time, Graphics g, int w, int h) {
        this.prepare();
        super.paintDecoration(time, g, w, h);
    }

    @Override
    protected boolean decoValid() {
        if (!this.decos.isEmpty()) {
            for (Decoration deco : this.decos) {
                deco.setAlpha(255);
                if (!deco.showDecoration()) continue;
                return true;
            }
        }
        System.out.println("list invalid");
        return false;
    }

    @Override
    protected void decoPaint(Graphics g, int w, int h) {
        for (Decoration deco : this.decos) {
            deco.paintDecoration(g, w, h);
        }
    }

    @Override
    protected void decoSetAlpha(int alpha) {
        System.out.println("list set alpha " + alpha);
        for (Decoration deco : this.decos) {
            deco.setAlpha(alpha);
        }
    }
}

