/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.scan;

import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.ColormapHandle;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerListenerSupport;
import com.mandelsoft.mand.scan.MandelScannerSupport;
import com.mandelsoft.mand.scan.MandelScannerTree;
import com.mandelsoft.mand.util.MandUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class CompoundMandelScannerSupport
extends MandelScannerSupport {
    protected List<MandelScanner> list = new ArrayList<MandelScanner>();
    private MandelScannerListenerSupport.Listener listener = new MandelScannerListenerSupport.Listener(this);

    @Override
    public synchronized void startUpdate() {
        super.startUpdate();
        for (MandelScanner s : this.list) {
            if (!(s instanceof MandelScannerTree)) continue;
            ((MandelScannerTree)((Object)s)).startUpdate();
        }
    }

    @Override
    public synchronized void finishUpdate() {
        for (MandelScanner s : this.list) {
            if (!(s instanceof MandelScannerTree)) continue;
            ((MandelScannerTree)((Object)s)).finishUpdate();
        }
        super.finishUpdate();
    }

    protected void addScanner(MandelScanner s) {
        if (!this.list.contains(s)) {
            this.startUpdate(true);
            this.list.add(0, s);
            s.addMandelScannerListener(this.listener);
            this.finishUpdate();
        }
    }

    protected void removeScanner(MandelScanner s) {
        if (this.list.contains(s)) {
            this.startUpdate(true);
            this.list.remove(s);
            s.removeMandelScannerListener(this.listener);
        }
    }

    public boolean hasScanners() {
        return !this.list.isEmpty();
    }

    protected Set<MandelName> _getMandelNames(Collection<MandelScanner> scanners) {
        HashSet<MandelName> set = new HashSet<MandelName>();
        if (scanners == null) {
            return set;
        }
        if (!this.isFiltered()) {
            for (MandelScanner s : scanners) {
                set.addAll(s.getMandelNames());
            }
        } else {
            for (MandelScanner s : scanners) {
                block2: for (MandelName n : s.getMandelNames()) {
                    Set<MandelHandle> hs;
                    if (set.contains(n) || (hs = s.getMandelHandles(n)) == null) continue;
                    for (MandelHandle h : hs) {
                        if (!this.filter(h.getHeader())) continue;
                        set.add(n);
                        continue block2;
                    }
                }
            }
        }
        return set;
    }

    protected Set<MandelHandle> _getMandelHandles(Collection<MandelScanner> scanners, MandelName name) {
        HashSet<MandelHandle> set = new HashSet<MandelHandle>();
        if (scanners != null) {
            for (MandelScanner s : scanners) {
                Set<MandelHandle> sub = s.getMandelHandles(name);
                this.add(set, sub);
            }
        }
        return set;
    }

    protected Set<ColormapName> _getColormapNames(Collection<MandelScanner> scanners) {
        HashSet<ColormapName> set = new HashSet<ColormapName>();
        if (scanners != null && this.providesColormaps()) {
            for (MandelScanner s : scanners) {
                set.addAll(s.getColormapNames());
            }
        }
        return set;
    }

    protected Set<ColormapHandle> _getColormapHandles(Collection<MandelScanner> scanners, ColormapName name) {
        HashSet<ColormapHandle> set = new HashSet<ColormapHandle>();
        if (scanners != null && this.providesColormaps()) {
            for (MandelScanner s : scanners) {
                Set<ColormapHandle> cm = s.getColormapHandles(name);
                set.addAll(cm);
            }
        }
        return set;
    }

    protected MandelHandle _getMandelInfo(Collection<MandelScanner> scanners, MandelName name) {
        MandelHandle best = null;
        if (scanners != null) {
            for (MandelScanner s : scanners) {
                MandelHandle md = s.getMandelInfo(name);
                best = MandUtils.better(best, md);
            }
        }
        return best;
    }

    protected MandelHandle _getMandelData(Collection<MandelScanner> scanners, MandelName name) {
        MandelHandle best = null;
        if (scanners != null) {
            for (MandelScanner s : scanners) {
                MandelHandle md = s.getMandelData(name);
                best = MandUtils.better(best, md);
            }
        }
        return best;
    }

    protected MandelHandle _getMandelHandle(Collection<MandelScanner> scanners, QualifiedMandelName name) {
        MandelHandle best = null;
        if (scanners != null) {
            for (MandelScanner s : scanners) {
                MandelHandle md = s.getMandelHandle(name);
                best = MandUtils.better(best, md);
            }
        }
        return best;
    }

    protected MandelHandle _getMandelInfo(Collection<MandelScanner> scanners, QualifiedMandelName name) {
        MandelHandle best = null;
        if (scanners != null) {
            for (MandelScanner s : scanners) {
                MandelHandle md = s.getMandelInfo(name);
                best = MandUtils.better(best, md);
            }
        }
        return best;
    }

    protected MandelHandle _getMandelData(Collection<MandelScanner> scanners, QualifiedMandelName name) {
        MandelHandle best = null;
        if (scanners != null) {
            for (MandelScanner s : scanners) {
                MandelHandle md = s.getMandelData(name);
                best = MandUtils.better(best, md);
            }
        }
        return best;
    }

    protected boolean _hasColormap(Collection<MandelScanner> scanners, ColormapName name) {
        if (scanners != null && this.providesColormaps()) {
            for (MandelScanner s : scanners) {
                if (!s.hasColormap(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Set<MandelName> _getMandelNames() {
        return this._getMandelNames(this.list);
    }

    @Override
    protected Set<MandelHandle> _getMandelHandles(MandelName name) {
        return this._getMandelHandles(this.list, name);
    }

    @Override
    protected Set<ColormapName> _getColormapNames() {
        return this._getColormapNames(this.list);
    }

    @Override
    protected Set<ColormapHandle> _getColormapHandles(ColormapName name) {
        return this._getColormapHandles(this.list, name);
    }

    @Override
    public synchronized Set<MandelName> getMandelNames() {
        return this._getMandelNames();
    }

    @Override
    public synchronized Set<MandelHandle> getMandelHandles(MandelName name) {
        return this._getMandelHandles(name);
    }

    @Override
    public synchronized Set<ColormapName> getColormapNames() {
        return this._getColormapNames();
    }

    @Override
    public synchronized Set<ColormapHandle> getColormapHandles(ColormapName name) {
        return this._getColormapHandles(name);
    }

    @Override
    public MandelHandle getMandelInfo(MandelName name) {
        return this._getMandelInfo(this.list, name);
    }

    @Override
    public MandelHandle getMandelData(MandelName name) {
        return this._getMandelData(this.list, name);
    }

    @Override
    public MandelHandle getMandelHandle(QualifiedMandelName name) {
        return this._getMandelHandle(this.list, name);
    }

    @Override
    public MandelHandle getMandelInfo(QualifiedMandelName name) {
        return this._getMandelInfo(this.list, name);
    }

    @Override
    public MandelHandle getMandelData(QualifiedMandelName name) {
        return this._getMandelData(this.list, name);
    }

    @Override
    public boolean hasColormap(ColormapName name) {
        return this._hasColormap(this.list, name);
    }

    @Override
    public synchronized void rescan(boolean verbose) {
        if (debug) {
            System.out.println("*** rescan compound scanner");
        }
        this.startUpdate();
        for (MandelScanner s : this.list) {
            s.rescan(verbose);
        }
        this.finishUpdate();
    }

    protected void add(Set<MandelHandle> set, Set<MandelHandle> a) {
        if (this.isFiltered()) {
            for (MandelHandle h : a) {
                if (!this.filter(h.getHeader())) continue;
                set.add(h);
            }
        } else {
            set.addAll(a);
        }
    }
}

