/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.scan;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.MandelFileName;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.scan.CachedFolderMandelScannerSupport;
import com.mandelsoft.mand.scan.MandelFolder;
import com.mandelsoft.mand.scan.MandelFolderCache;
import com.mandelsoft.mand.scan.MandelFolderListener;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelInventory;
import com.mandelsoft.mand.scan.MandelScanner;
import java.io.File;
import java.io.IOException;

public class FolderMandelScanner
extends CachedFolderMandelScannerSupport {
    public static boolean debug = false;
    private MandelFolder folder;

    public FolderMandelScanner(File d) throws IOException {
        this(d, MandelScanner.HAS_IMAGEDATA);
    }

    public FolderMandelScanner(File d, MandelScanner.Filter filter) throws IOException {
        this(d, filter, true);
    }

    public FolderMandelScanner(File d, MandelScanner.Filter filter, boolean setup) throws IOException {
        super(filter, false);
        this.folder = MandelFolder.getMandelFolder(d);
        this.folder.addMandelFolderListener(new FolderListener());
        if (setup) {
            this.rescan(false);
        }
    }

    @Override
    public String toString() {
        return "FolderMandelScanner:" + this.folder + "(" + super.toString() + ")";
    }

    @Override
    protected MandelFolderCache getCache() {
        return this.folder.getCache();
    }

    @Override
    protected AbstractFile createAbstractFile(MandelInventory.Entry e) throws IOException {
        return AbstractFile.Factory.create(this.folder.getFolder(), e.getFilename());
    }

    @Override
    protected void lock() {
        this.folder.lock();
    }

    @Override
    protected void releaseLock() {
        this.folder.releaseLock();
    }

    @Override
    protected boolean rescanNonCached(boolean verbose, boolean read) {
        int cnt = 0;
        this.clear();
        System.out.println("scanning folder " + this.folder.getFolder());
        if (debug) {
            System.out.println("  reading directory....");
        }
        File[] list = this.folder.getFolder().listFiles();
        if (debug) {
            System.out.println("  scanning content...");
        }
        if (list != null) {
            for (File f : list) {
                this.add(f);
                if (++cnt % 1000 != 0 || !debug) continue;
                System.out.println("    " + cnt);
            }
        }
        return true;
    }

    public static void main(String[] args) {
        File f = new File("C:/work/AccuRev/test/Mandel/data/new");
        try {
            FolderMandelScanner s = new FolderMandelScanner(f);
            for (MandelName n : s.getMandelNames()) {
                System.out.println(n);
                for (MandelHandle mh : s.getMandelHandles(n)) {
                    System.out.println("   " + mh.getFile() + ": " + mh.getHeader() + ": " + mh.getHeader().getType());
                }
            }
        }
        catch (IOException ex) {
            System.err.println("cannot handle folder " + f + ": " + ex);
        }
    }

    private class FolderListener
    implements MandelFolderListener {
        private FolderListener() {
        }

        @Override
        public void addMandelFile(File f, MandelInventory.Entry e) {
            if (debug) {
                System.out.println("--- add mandel file " + f);
            }
            if (e != null) {
                FolderMandelScanner.this.add(e);
            } else {
                FolderMandelScanner.this.add(f);
            }
        }

        @Override
        public void removeMandelFile(File f) {
            if (debug) {
                System.out.println("--- remove mandel file " + f);
            }
            MandelFileName mfn = MandelFileName.create(f);
            AbstractFile af = AbstractFile.Factory.create(f);
            if (mfn != null && FolderMandelScanner.this.folder.hasCache()) {
                if (FolderMandelScanner.this.infos.remove(af) != null) {
                    if (debug) {
                        System.out.println("    scanner updated");
                    }
                } else if (debug) {
                    System.out.println("    not found");
                }
            }
            FolderMandelScanner.this.remove(af);
        }

        @Override
        public void folderUpdated(File f) {
            if (!FolderMandelScanner.this.isInUpdate()) {
                FolderMandelScanner.this.rescan(false, false);
            }
        }
    }
}

