/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.scan;

import com.mandelsoft.io.FolderLock;
import com.mandelsoft.mand.scan.MandelFolderCache;
import com.mandelsoft.mand.scan.MandelFolderListener;
import com.mandelsoft.mand.scan.MandelInventory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MandelFolder
extends FolderLock {
    public static boolean debug = false;
    private static Map<File, MandelFolder> map = new HashMap<File, MandelFolder>();
    private MandelFolderCache cache;
    private List<MandelFolderListener> listenerList = new ArrayList<MandelFolderListener>();

    public static synchronized MandelFolder getMandelFolder(File f) throws IOException {
        MandelFolder m;
        if (!(f = f.getCanonicalFile()).isDirectory()) {
            f = f.getParentFile();
        }
        if (debug) {
            System.out.println("%%% get mandel folder " + f);
        }
        if ((m = map.get(f)) == null) {
            if (debug) {
                System.out.println("      create new mandel folder");
            }
            m = new MandelFolder(f);
            map.put(f, m);
        }
        return m;
    }

    public MandelFolder(File f) throws IOException {
        super(f);
        if (!f.isDirectory()) {
            throw new IOException(f + " is no directory");
        }
        this.lock();
        try {
            if (MandelFolderCache.isCached(f)) {
                this.cache = new MandelFolderCache(f);
            }
        }
        finally {
            this.releaseLock();
        }
    }

    public synchronized MandelFolderCache getCache() {
        return this.cache;
    }

    public synchronized boolean hasCache() {
        return this.cache != null;
    }

    synchronized void createCache() throws IOException {
        if (this.cache == null) {
            this.cache = new MandelFolderCache(this.getFolder());
            this.cache.recreate();
        }
    }

    public synchronized void recreate() throws IOException {
        if (this.cache != null) {
            this.lock();
            try {
                this.cache.recreate();
            }
            finally {
                this.releaseLock();
            }
        }
    }

    public boolean remove(String name) throws IOException {
        return this.remove(new File(this.getFolder(), name));
    }

    public synchronized boolean remove(File f) throws IOException {
        if (!(f = f.getCanonicalFile()).getParentFile().equals(this.getFolder())) {
            throw new IllegalArgumentException(f + " not in directory");
        }
        this.lock();
        try {
            if (f.delete()) {
                this._handleRemoved(f);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseLock();
        }
    }

    protected synchronized void handleRemoved(File f) throws IOException {
        this.lock();
        try {
            this._handleRemoved(f);
        }
        finally {
            this.releaseLock();
        }
    }

    protected void _handleRemoved(File f) throws IOException {
        boolean full = false;
        if (this.cache != null) {
            full = this.cache.update();
            if (this.cache.removeFile(f)) {
                this.cache.write();
            }
        }
        if (full) {
            this.folderUpdated(this.getFolder());
        } else {
            this.removeMandelFile(f);
        }
    }

    public boolean moveToLocal(File f) throws IOException {
        return this.renameTo(f, new File(this.getFolder(), f.getName()));
    }

    public boolean renameTo(File f, String name) throws IOException {
        return this.renameTo(f, new File(this.getFolder(), name));
    }

    /*
     * Exception decompiling
     */
    public boolean renameTo(File f, File dst) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void _handleAdded(File f) throws IOException {
        boolean full = false;
        MandelInventory.Entry e = null;
        if (this.cache != null) {
            full = this.cache.update();
            e = this.cache.addFile(f);
            if (e != null) {
                this.cache.write();
            }
        }
        if (full) {
            this.folderUpdated(this.getFolder());
        } else {
            this.addMandelFile(f, e);
        }
    }

    public synchronized void add(File f) throws IOException {
        boolean full = false;
        if (!(f = f.getCanonicalFile()).getParentFile().equals(this.getFolder())) {
            throw new IllegalArgumentException(f + " not in directory");
        }
        this.lock();
        try {
            this._handleAdded(f);
        }
        finally {
            this.releaseLock();
        }
    }

    public String toString() {
        return this.getFolder().toString();
    }

    public synchronized void addMandelFolderListener(MandelFolderListener l) {
        this.listenerList.add(l);
    }

    public synchronized void removeMandelFolderListener(MandelFolderListener l) {
        this.listenerList.remove(l);
    }

    public synchronized MandelFolderListener[] getMandelFolderListeners() {
        return this.listenerList.toArray(new MandelFolderListener[this.listenerList.size()]);
    }

    protected void addMandelFile(File f, MandelInventory.Entry e) {
        for (MandelFolderListener l : this.listenerList) {
            l.addMandelFile(f, e);
        }
    }

    protected void removeMandelFile(File f) {
        for (MandelFolderListener l : this.listenerList) {
            l.removeMandelFile(f);
        }
    }

    protected void folderUpdated(File f) {
        for (MandelFolderListener l : this.listenerList) {
            l.folderUpdated(f);
        }
    }

    public static void main(String[] args) {
        File n = new File(".");
        if (args.length > 0) {
            n = new File(args[0]);
        }
        try {
            MandelFolder f = MandelFolder.getMandelFolder(n);
            f.createCache();
        }
        catch (IOException ex) {
            System.out.println("cannot handle folder " + n + ": " + ex);
        }
    }

    public static class Util {
        public static void add(File f) throws IOException {
            MandelFolder mf = MandelFolder.getMandelFolder(f.getParentFile());
            mf.add(f);
        }

        public static boolean delete(File f) throws IOException {
            MandelFolder mf = MandelFolder.getMandelFolder(f.getParentFile());
            return mf.remove(f);
        }

        public static boolean renameTo(File s, File d) throws IOException {
            MandelFolder mf = MandelFolder.getMandelFolder(d.getParentFile());
            return mf.renameTo(s, d);
        }
    }
}

