/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.scan;

import com.mandelsoft.mand.scan.FilteredMandelScanner;
import com.mandelsoft.mand.scan.FolderMandelScanner;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.URLMandelScanner;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class MandelScannerCache {
    private static boolean debug = false;
    private Map<Object, Map<MandelScanner.Filter, MandelScanner>> cache = new HashMap<Object, Map<MandelScanner.Filter, MandelScanner>>();
    private Proxy proxy;

    public MandelScannerCache(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public MandelScanner getScanner(URL url, MandelScanner.Filter filter) throws MalformedURLException {
        Map<MandelScanner.Filter, MandelScanner> scanners = this.cache.get(url);
        if (scanners == null) {
            if (debug) {
                System.out.println("*** create all scanner for " + url);
            }
            URLMandelScanner scanner = new URLMandelScanner(this.proxy, url, MandelScanner.ALL);
            scanners = new HashMap<MandelScanner.Filter, MandelScanner>();
            this.cache.put(url, scanners);
            scanners.put(MandelScanner.ALL, scanner);
        }
        return this.getFilter(url, scanners, filter);
    }

    public MandelScanner getScanner(File d, MandelScanner.Filter filter) throws IOException {
        Map<MandelScanner.Filter, MandelScanner> scanners = this.cache.get(d = d.getCanonicalFile());
        if (scanners == null) {
            if (debug) {
                System.out.println("*** create all scanner for " + d);
            }
            FolderMandelScanner scanner = new FolderMandelScanner(d, MandelScanner.ALL);
            scanners = new HashMap<MandelScanner.Filter, MandelScanner>();
            this.cache.put(d, scanners);
            scanners.put(MandelScanner.ALL, scanner);
        }
        return this.getFilter(d, scanners, filter);
    }

    private MandelScanner getFilter(Object src, Map<MandelScanner.Filter, MandelScanner> scanners, MandelScanner.Filter filter) {
        MandelScanner scanner = scanners.get(filter);
        if (scanner == null) {
            if (debug) {
                System.out.println("*** create filtered scanner for " + src);
            }
            scanner = new FilteredMandelScanner(scanners.get(MandelScanner.ALL), filter);
            scanners.put(filter, scanner);
        } else if (debug) {
            System.out.println("*** found filtered scanner for " + src);
        }
        return scanner;
    }
}

