/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.scan;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.io.URLAbstractFile;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.scan.CachedFolderMandelScannerSupport;
import com.mandelsoft.mand.scan.ElementHandle;
import com.mandelsoft.mand.scan.MandelFolderCache;
import com.mandelsoft.mand.scan.MandelInventory;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.util.Utils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;

public class URLMandelScanner
extends CachedFolderMandelScannerSupport {
    private AbstractFile folder;
    private AbstractFile cache;
    private MandelFolderCache mcache;

    public URLMandelScanner(Proxy proxy, URL d) throws MalformedURLException {
        this(new URLAbstractFile(proxy, d), MandelScanner.HAS_IMAGEDATA);
    }

    public URLMandelScanner(Proxy proxy, URL d, MandelScanner.Filter filter) throws MalformedURLException {
        this(new URLAbstractFile(proxy, d), filter);
    }

    public URLMandelScanner(AbstractFile d) throws MalformedURLException {
        this(d, MandelScanner.HAS_IMAGEDATA);
    }

    public URLMandelScanner(AbstractFile d, MandelScanner.Filter filter) throws MalformedURLException {
        this(d, filter, true);
    }

    public URLMandelScanner(AbstractFile d, MandelScanner.Filter filter, boolean setup) throws MalformedURLException {
        super(filter, false);
        this.folder = d;
        this.cache = d.getSub(".mcache");
        if (setup) {
            this.rescan(false);
        }
    }

    public URL getFolder() {
        return this.folder.getURL();
    }

    private URL sub(String name) throws MalformedURLException {
        return Utils.subURL(this.getFolder(), name);
    }

    @Override
    protected MandelFolderCache getCache() {
        if (this.mcache == null) {
            try {
                this.mcache = new MandelFolderCache(this.cache);
            }
            catch (IOException ex) {
                System.out.println("cannot read cache: " + ex);
            }
        }
        return this.mcache;
    }

    @Override
    protected AbstractFile createAbstractFile(MandelInventory.Entry e) throws IOException {
        return AbstractFile.Factory.create(this.folder.getProxy(), this.sub(e.getFilename()), e.getLastModified());
    }

    @Override
    protected void lock() {
    }

    @Override
    protected void releaseLock() {
    }

    @Override
    protected boolean rescanNonCached(boolean verbose, boolean read) {
        throw new UnsupportedOperationException("Uncached not supported.");
    }

    @Override
    public String toString() {
        return this.getFolder() + "(" + super.toString() + ")";
    }

    public static void main(String[] args) {
        try {
            URL url = new URL(args[0]);
            System.out.println("setting up " + url);
            URLMandelScanner scan = new URLMandelScanner(null, url);
            scan.rescan(true);
            System.out.println("files:");
            for (ElementHandle<?> h : scan.getAllHandles()) {
                System.out.println("  " + h.getFile());
            }
            System.out.println("header:");
            for (MandelName n : scan.getMandelNames()) {
                MandelData info = scan.getMandelInfo(n).getInfo();
                String p = info.getInfo().getXM() + "," + info.getInfo().getYM();
                System.out.println(n + ": " + info.getHeader().getTypeDesc() + ": " + p + ": " + info.getFile());
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
            ex.printStackTrace();
        }
    }
}

