/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.srv;

import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelRaster;
import com.mandelsoft.mand.meth.PixelIterator;
import com.mandelsoft.mand.srv.CalcRequest;
import com.mandelsoft.mand.srv.Request;
import com.mandelsoft.mand.srv.Server;
import com.mandelsoft.util.ChangeEvent;
import com.mandelsoft.util.ChangeListener;
import com.mandelsoft.util.StateChangeSupport;
import java.util.HashSet;

public class AreaHandler
implements Request {
    private MandelData data;
    private int sx;
    private int sy;
    private int nx;
    private int ny;
    private boolean full;
    private boolean recalc;
    private Server server;
    private PixelIterator pi;
    private long mtime;
    private boolean log;
    private boolean instatesetup = false;
    private HashSet<Request> requests = new HashSet();
    private HandlerChangeListener listener;
    private StateChangeSupport listeners = new StateChangeSupport();

    public AreaHandler(Server server, boolean recalc, boolean full, MandelData data, int sx, int sy, int nx, int ny) {
        this.full = full;
        this.recalc = recalc;
        this.server = server;
        this.data = data;
        this.sx = sx;
        this.sy = sy;
        this.nx = nx;
        this.ny = ny;
        this.mtime = 0L;
    }

    private void log(String m) {
        if (this.log) {
            System.out.println(m);
        }
    }

    @Override
    public void setPixelIterator(PixelIterator pi) {
        this.pi = pi;
    }

    public long getMTime() {
        return this.mtime;
    }

    public synchronized void initiate() {
        this.startStateSetup();
        if (!this.full) {
            this.startFrameState();
        } else if (this.nx * this.ny < 500) {
            this.startCalcRequestState();
            this.calc("full", this.sx + (this.full ? 0 : 1), this.sy + (this.full ? 0 : 1), this.nx - (this.full ? 0 : 2), this.ny - (this.full ? 0 : 2));
        } else {
            this.startFrameState();
            if (this.full) {
                this.calc("top   ", this.sx + 1, this.sy, this.nx - 2, 1);
                this.calc("bottom", this.sx + 1, this.sy + this.ny - 1, this.nx - 2, 1);
                this.calc("left  ", this.sx, this.sy, 1, this.ny);
                this.calc("right ", this.sx + this.nx - 1, this.sy, 1, this.ny);
            }
        }
        this.full = false;
        this.finishStateSetup();
    }

    private void calc(String msg, int x0, int y0, int dx, int dy) {
        if (!this.full) {
            if (x0 == this.sx) {
                ++x0;
                --dx;
            } else if (x0 + dx == this.sx + this.nx) {
                --dx;
            }
            if (y0 == this.sy) {
                ++y0;
                --dy;
            } else if (y0 + dy == this.sy + this.ny) {
                --dy;
            }
        }
        if (dx > 0 && dy > 0) {
            if (dx * dy > 500) {
                if (dx > dy) {
                    int d = dx / 2;
                    this.calc(msg, x0, y0, d, dy);
                    this.calc(msg, x0 + d, y0, dx - d, dy);
                } else {
                    int d = dy / 2;
                    this.calc(msg, x0, y0, dx, d);
                    this.calc(msg, x0, y0 + d, dx, dy - d);
                }
            } else {
                this.initiate(msg, x0, y0, dx, dy);
            }
        }
    }

    private void initiate(String msg, int x0, int y0, int dx, int dy) {
        CalcRequest req = new CalcRequest(this.data.getInfo(), x0, y0, dx, dy);
        if (this.recalc && !this.put(req)) {
            this.log("skipped calc " + msg + ": " + x0 + ", " + y0 + ", " + dx + ", " + dy);
            return;
        }
        this.log("calc " + msg + ": " + x0 + ", " + y0 + ", " + dx + ", " + dy);
        this.addRequest(req);
    }

    private void initiateSubArea(int x0, int y0, int dx, int dy) {
        if (dx > 0 && dy > 0) {
            this.log("sub: " + x0 + ", " + y0 + ", " + dx + ", " + dy);
            AreaHandler req = new AreaHandler(this.server, this.recalc, false, this.data, x0, y0, dx, dy);
            this.addRequest(req);
        }
    }

    private boolean constantFrame() {
        int it;
        MandelRaster raster = this.getRaster();
        if (!this.equals(raster, it = raster.getData(this.sx, this.sy), this.sx + 1, this.sy, this.nx - 1, 1)) {
            return false;
        }
        if (!this.equals(raster, it, this.sx + 1, this.sy + this.ny - 1, this.nx - 1, 1)) {
            return false;
        }
        if (!this.equals(raster, it, this.sx, this.sy + 1, 1, this.ny - 1)) {
            return false;
        }
        return this.equals(raster, it, this.sx + this.nx - 1, this.sy + 1, 1, this.ny - 1);
    }

    private boolean equals(MandelRaster raster, int it, int x0, int y0, int dx, int dy) {
        for (int y = y0; y < y0 + dy; ++y) {
            for (int x = x0; x < x0 + dx; ++x) {
                if (raster.getData(x, y) == it) continue;
                return false;
            }
        }
        return true;
    }

    private void fillFrame() {
        MandelRaster raster = this.getRaster();
        this.fillFrame(raster, raster.getData(this.sx, this.sy), this.sx + 1, this.sy + 1, this.nx - 2, this.ny - 2);
    }

    private void fillFrame(MandelRaster raster, int it, int x0, int y0, int dx, int dy) {
        int m = it == 0 ? 1 : 0;
        int cnt = 0;
        int mcnt = 0;
        this.log("fill " + it + ": " + x0 + ", " + y0 + ", " + dx + ", " + dy);
        MandelInfo info = this.data.getInfo();
        for (int y = y0; y < y0 + dy; ++y) {
            for (int x = x0; x < x0 + dx; ++x) {
                raster.setData(x, y, it);
                cnt += it;
                mcnt += m;
            }
        }
        info.setMCnt(info.getMCnt() + (long)mcnt);
        info.setNumIt(info.getNumIt() + (long)cnt);
    }

    private MandelRaster getRaster() {
        return this.data.getRaster();
    }

    private void transfer(CalcRequest req) {
        int nx = req.getNX();
        int ny = req.getNY();
        int sx = req.getSX();
        int sy = req.getSY();
        MandelRaster raster = this.getRaster();
        MandelInfo info = this.data.getInfo();
        for (int x = 0; x < nx; ++x) {
            for (int y = 0; y < ny; ++y) {
                int ax = sx + x;
                int ay = sy + y;
                raster.setData(ax, ay, req.getDataRel(x, y));
            }
        }
        if (req.getMaxIt() > info.getMaxIt()) {
            info.setMaxIt(req.getMaxIt());
        }
        if (req.getMinIt() < info.getMinIt()) {
            info.setMinIt(req.getMinIt());
        }
        info.setMCnt(info.getMCnt() + req.getMCnt());
        info.setMCCnt(info.getMCCnt() + req.getCCnt());
        info.setNumIt(info.getNumIt() + req.getNumIt());
        this.mtime += req.getMTime();
    }

    private boolean put(CalcRequest req) {
        int nx = req.getNX();
        int ny = req.getNY();
        int sx = req.getSX();
        int sy = req.getSY();
        MandelInfo info = this.data.getInfo();
        MandelRaster raster = this.getRaster();
        boolean found = false;
        int minit = info.getMinIt();
        int maxit = info.getMinIt();
        long mcnt = info.getMCnt();
        long ccnt = info.getMCCnt();
        long numit = info.getNumIt();
        req.createData();
        for (int x = 0; x < nx; ++x) {
            for (int y = 0; y < ny; ++y) {
                int ax = sx + x;
                int ay = sy + y;
                int it = raster.getData(ax, ay);
                req.setDataRel(x, y, it);
                if (it == 0) {
                    found = true;
                }
                numit += (long)it;
                if (it > maxit) {
                    maxit = it;
                }
                if (it >= minit) continue;
                minit = it;
            }
        }
        if (!found) {
            info.setMaxIt(maxit);
            info.setMinIt(minit);
            info.setMCnt(mcnt);
            info.setMCCnt(ccnt);
            info.setNumIt(numit);
        }
        return found;
    }

    private synchronized void startStateSetup() {
        this.instatesetup = true;
    }

    private synchronized void finishStateSetup() {
        this.instatesetup = false;
        this.checkFinishState();
    }

    private synchronized void checkFinishState() {
        if (!this.instatesetup && this.requests.isEmpty() && this.listener != null) {
            this.listener.nextState();
        }
    }

    private void startFrameState() {
        this.listener = new FrameChangeListener();
    }

    private void startDivideState() {
        this.listener = new DivideChangeListener();
    }

    private void startCalcRequestState() {
        this.listener = new CalcRequestChangeListener();
    }

    private void startSubAreaState() {
        this.listener = new SubAreaChangeListener();
    }

    private void startDoneState() {
        this.listener = null;
        this.fireChangeEvent();
    }

    private void addRequest(Request req) {
        if (this.listener == null) {
            throw new IllegalStateException("illegal area state");
        }
        req.addChangeListener(this.listener);
        req.setPixelIterator(this.pi);
        this.requests.add(req);
        req.send(this.server);
    }

    @Override
    public void send(Server server) {
        this.initiate();
    }

    @Override
    public void removeChangeListener(ChangeListener h) {
        this.listeners.removeChangeListener(h);
    }

    private void fireChangeEvent() {
        this.listeners.fireChangeEvent(this);
    }

    @Override
    public void addChangeListener(ChangeListener h) {
        this.listeners.addChangeListener(h);
    }

    private abstract class HandlerChangeListener
    implements ChangeListener {
        private HandlerChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void stateChanged(ChangeEvent e) {
            AreaHandler areaHandler = AreaHandler.this;
            synchronized (areaHandler) {
                Request req = (Request)e.getSource();
                AreaHandler.this.requests.remove(req);
                this.requestProcessed(req);
                AreaHandler.this.checkFinishState();
            }
        }

        protected abstract void requestProcessed(Request var1);

        protected void nextState() {
            AreaHandler.this.startDoneState();
        }
    }

    private class FrameChangeListener
    extends CalcRequestChangeListener {
        private FrameChangeListener() {
        }

        @Override
        protected void nextState() {
            AreaHandler.this.startStateSetup();
            if (AreaHandler.this.constantFrame()) {
                AreaHandler.this.startDoneState();
                AreaHandler.this.fillFrame();
            } else if (AreaHandler.this.nx * AreaHandler.this.ny < 500) {
                AreaHandler.this.startCalcRequestState();
                AreaHandler.this.calc("full", AreaHandler.this.sx + 1, AreaHandler.this.sy + 1, AreaHandler.this.nx - 2, AreaHandler.this.ny - 2);
            } else {
                AreaHandler.this.startDivideState();
                if (AreaHandler.this.nx > AreaHandler.this.ny) {
                    int d = AreaHandler.this.nx / 2;
                    AreaHandler.this.calc("div x", AreaHandler.this.sx + d, AreaHandler.this.sy + 1, 1, AreaHandler.this.ny - 2);
                } else {
                    int d = AreaHandler.this.ny / 2;
                    AreaHandler.this.calc("div y", AreaHandler.this.sx + 1, AreaHandler.this.sy + d, AreaHandler.this.nx - 2, 1);
                }
            }
            AreaHandler.this.finishStateSetup();
        }
    }

    private class DivideChangeListener
    extends CalcRequestChangeListener {
        private DivideChangeListener() {
        }

        @Override
        protected void nextState() {
            AreaHandler.this.startStateSetup();
            AreaHandler.this.startSubAreaState();
            if (AreaHandler.this.nx > AreaHandler.this.ny) {
                int d = AreaHandler.this.nx / 2;
                AreaHandler.this.initiateSubArea(AreaHandler.this.sx, AreaHandler.this.sy, d + 1, AreaHandler.this.ny);
                AreaHandler.this.initiateSubArea(AreaHandler.this.sx + d, AreaHandler.this.sy, AreaHandler.this.nx - d, AreaHandler.this.ny);
            } else {
                int d = AreaHandler.this.ny / 2;
                AreaHandler.this.initiateSubArea(AreaHandler.this.sx, AreaHandler.this.sy, AreaHandler.this.nx, d + 1);
                AreaHandler.this.initiateSubArea(AreaHandler.this.sx, AreaHandler.this.sy + d, AreaHandler.this.nx, AreaHandler.this.ny - d);
            }
            AreaHandler.this.finishStateSetup();
        }
    }

    private class CalcRequestChangeListener
    extends HandlerChangeListener {
        private CalcRequestChangeListener() {
        }

        @Override
        protected void requestProcessed(Request req) {
            AreaHandler.this.transfer((CalcRequest)req);
        }
    }

    private class SubAreaChangeListener
    extends HandlerChangeListener {
        private SubAreaChangeListener() {
        }

        @Override
        protected void requestProcessed(Request req) {
            AreaHandler area = (AreaHandler)req;
            AreaHandler.this.mtime += area.getMTime();
        }
    }
}

