/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.srv;

import com.mandelsoft.mand.MandelSpec;
import com.mandelsoft.mand.calc.AreaCalculator;
import com.mandelsoft.mand.calc.CalculationContext;
import com.mandelsoft.mand.calc.SimpleAreaCalculator;
import com.mandelsoft.mand.srv.Request;
import com.mandelsoft.mand.srv.Server;
import com.mandelsoft.util.ChangeListener;
import com.mandelsoft.util.StateChangeSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;

public class CalcRequest
extends CalculationContext
implements Request {
    private static AreaCalculator calc = new SimpleAreaCalculator();
    private static final int VERSION = 1;
    private int version = 1;
    private long reqid = 0L;
    private int[] data;
    static volatile long lastid = 0L;
    private StateChangeSupport listeners = new StateChangeSupport();

    public CalcRequest() {
        if (this.reqid <= lastid) {
            this.reqid = lastid + 1L;
        }
        lastid = this.reqid;
    }

    public CalcRequest(MandelSpec spec, int sx, int sy, int nx, int ny) {
        this();
        this.setSpec(spec);
        this.setSX(sx);
        this.setSY(sy);
        this.setNX(nx);
        this.setNY(ny);
    }

    public CalcRequest(MandelSpec spec, int sx, int sy, int nx, int ny, int[] data) {
        this(spec, sx, sy, nx, ny);
        this.data = data;
    }

    public long getReqId() {
        return this.reqid;
    }

    public int[] getData() {
        return this.data;
    }

    private void setReqId(long id) {
        this.reqid = id;
    }

    public void setData(int[] data) {
        this.data = data;
    }

    public int getIndexAbs(int x, int y) {
        return x - this.getSX() + (y - this.getSY()) * this.getNX();
    }

    public int getIndexRel(int x, int y) {
        return x + y * this.getNX();
    }

    @Override
    public void createData() {
        if (this.data == null) {
            this.data = new int[this.getNX() * this.getNY()];
        }
    }

    @Override
    protected void resetData() {
        this.data = null;
    }

    @Override
    public int getDataRel(int x, int y) {
        return this.data[this.getIndexRel(x, y)];
    }

    @Override
    public void setDataRel(int x, int y, int it) {
        this.data[this.getIndexRel((int)x, (int)y)] = it;
    }

    public void calc() {
        calc.calc(this);
    }

    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, 1);
    }

    public void write(DataOutputStream dos, boolean verbose) throws IOException {
        this.write(dos, 1, verbose);
    }

    public void write(DataOutputStream dos, int v) throws IOException {
        this.write(dos, v, true);
    }

    public void write(DataOutputStream dos, int v, boolean verbose) throws IOException {
        if (verbose) {
            System.out.println("  writing info (" + v + ") ...");
        }
        switch (v) {
            case 1: {
                dos.writeInt(v);
                this.writeV1(dos);
                break;
            }
            default: {
                throw new IOException("unknown calc req version " + v);
            }
        }
    }

    private void writeV1(DataOutputStream dos) throws IOException {
        dos.writeLong(this.reqid);
        dos.writeUTF(this.getXM().toString());
        dos.writeUTF(this.getYM().toString());
        dos.writeUTF(this.getDX().toString());
        dos.writeUTF(this.getDY().toString());
        dos.writeInt(this.getRX());
        dos.writeInt(this.getRY());
        dos.writeInt(this.getLimitIt());
        dos.writeInt(this.getSX());
        dos.writeInt(this.getSY());
        dos.writeInt(this.getNX());
        dos.writeInt(this.getNY());
        dos.writeInt(this.getMinIt());
        dos.writeInt(this.getMaxIt());
        dos.writeLong(this.getNumIt());
        dos.writeLong(this.getMTime());
        dos.writeLong(this.getMCnt());
        dos.writeLong(this.getCCnt());
        if (this.data == null) {
            dos.writeInt(0);
        } else {
            dos.writeInt(this.data.length);
            for (int i = 0; i < this.data.length; ++i) {
                dos.writeInt(this.data[i]);
            }
        }
    }

    public void read(DataInputStream dis) throws IOException {
        this.read(dis, true);
    }

    public void read(DataInputStream dis, boolean verbose) throws IOException {
        if (verbose) {
            System.out.println("  reading info ...");
        }
        this.version = dis.readInt();
        switch (this.version) {
            case 1: {
                this.readV1(dis);
                break;
            }
            default: {
                throw new IOException("unknown calc req version " + this.version);
            }
        }
    }

    private void readV1(DataInputStream dis) throws IOException {
        this.setReqId(dis.readLong());
        this.setXM(new BigDecimal(dis.readUTF()));
        this.setYM(new BigDecimal(dis.readUTF()));
        this.setDX(new BigDecimal(dis.readUTF()));
        this.setDY(new BigDecimal(dis.readUTF()));
        this.setRX(dis.readInt());
        this.setRY(dis.readInt());
        this.setLimitIt(dis.readInt());
        this.setSX(dis.readInt());
        this.setSY(dis.readInt());
        this.setNX(dis.readInt());
        this.setNY(dis.readInt());
        this.setMinIt(dis.readInt());
        this.setMaxIt(dis.readInt());
        this.setNumIt(dis.readLong());
        this.setMTime(dis.readLong());
        this.setMCnt(dis.readLong());
        this.setCCnt(dis.readLong());
        int len = dis.readInt();
        if (len == 0) {
            this.data = null;
        } else {
            this.data = new int[len];
            for (int i = 0; i < len; ++i) {
                this.data[i] = dis.readInt();
            }
        }
    }

    @Override
    public void send(Server server) {
        server.sendRequest(this);
    }

    @Override
    public void removeChangeListener(ChangeListener h) {
        this.listeners.removeChangeListener(h);
    }

    public void fireChangeEvent() {
        this.listeners.fireChangeEvent(this);
    }

    @Override
    public void addChangeListener(ChangeListener h) {
        this.listeners.addChangeListener(h);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CalcRequest other = (CalcRequest)obj;
        return this.reqid == other.reqid;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 31 * hash + (int)(this.reqid ^ this.reqid >>> 32);
        return hash;
    }
}

