/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.srv;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.srv.DirectServer;
import com.mandelsoft.mand.srv.ImageHandler;
import com.mandelsoft.mand.srv.Server;
import com.mandelsoft.mand.tools.Command;
import com.mandelsoft.util.ChangeEvent;
import com.mandelsoft.util.ChangeListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Daemon
extends Command {
    public static void main(String[] args) {
        int c;
        boolean dflag = false;
        boolean fflag = false;
        ArrayList<String> sargs = new ArrayList<String>();
        Class serverc = DirectServer.class;
        Server server = null;
        for (c = 0; args.length > c && args[c].charAt(0) == '-'; ++c) {
            String arg = args[c++];
            block16: for (int i = 1; i < arg.length(); ++i) {
                char opt = arg.charAt(i);
                switch (opt) {
                    case 'd': {
                        dflag = true;
                        continue block16;
                    }
                    case 'f': {
                        fflag = true;
                        continue block16;
                    }
                    case 's': {
                        if (args.length > c) {
                            String n = args[c++];
                            try {
                                serverc = Class.forName(n);
                                System.out.println("server class " + serverc);
                            }
                            catch (ClassNotFoundException ex) {
                                Daemon.Error("cannot load server class " + n + ": " + ex);
                            }
                            continue block16;
                        }
                        Daemon.Error("server class name missing");
                        continue block16;
                    }
                    default: {
                        Daemon.Error("illegal option '" + opt + "'");
                    }
                }
            }
        }
        while (args.length > c) {
            sargs.add(args[c++]);
        }
        Constructor cr = null;
        try {
            cr = serverc.getConstructor(String[].class);
            try {
                server = (Server)cr.newInstance(new Object[]{sargs.toArray(new String[sargs.size()])});
            }
            catch (Exception ex) {
                Daemon.Error("server creation failed: " + ex);
            }
        }
        catch (Exception ex) {
            if (sargs.size() > 0) {
                Daemon.Error("no arguments expected by server class " + serverc);
            }
            try {
                server = (Server)serverc.newInstance();
            }
            catch (Exception ex1) {
                Daemon.Error("server creation failed: " + ex1);
            }
        }
        try {
            Daemon.service(server, dflag, fflag);
        }
        catch (IllegalConfigurationException ex) {
            Daemon.Error("service creation failed: " + ex);
        }
    }

    private static void service(Server server, boolean dflag, boolean fflag) throws IllegalConfigurationException {
        Service srv = new Service(server, dflag, fflag);
        srv.run();
    }

    private static class Service {
        Environment env;
        Set<AbstractFile> ignored;
        MandelScanner imagescan;
        Server server;
        boolean dflag;
        boolean fflag;

        public Service(Server server, boolean dflag, boolean fflag) throws IllegalConfigurationException {
            this.server = server;
            this.dflag = dflag;
            this.fflag = fflag;
            this.env = new Environment(null);
            this.ignored = new HashSet<AbstractFile>();
            this.imagescan = this.env.getImageDataScanner();
        }

        public Environment getEnvironment() {
            return this.env;
        }

        public void run() {
            MandelScanner scan = this.env.getInfoScanner();
            MandelScanner prioscan = this.env.getPrioInfoScanner();
            SyncListener listener = new SyncListener();
            Iterator<MandelHandle> fallback = scan.getMandelHandles().iterator();
            while (true) {
                ImageHandler handler;
                int found = 0;
                for (MandelHandle h : prioscan.getMandelHandles()) {
                    if (h.getLabel() != null) continue;
                    System.out.println("handle " + h.getFile());
                    handler = new ImageHandler(this.env, h.getFile());
                    handler.addChangeListener(listener);
                    handler.send(this.server);
                    if (!handler.isAccepted()) continue;
                    listener.sync();
                    ++found;
                }
                if (found == 0) {
                    if (!fallback.hasNext()) {
                        System.out.println("rescan standard scanner");
                        scan.rescan(false);
                        fallback = scan.getMandelHandles().iterator();
                    }
                    while (found == 0 && fallback.hasNext()) {
                        MandelHandle h = fallback.next();
                        if (h.getLabel() != null) continue;
                        System.out.println("handle " + h.getFile());
                        handler = new ImageHandler(this.env, h.getFile());
                        handler.addChangeListener(listener);
                        handler.send(this.server);
                        if (!handler.isAccepted()) continue;
                        listener.sync();
                        ++found;
                    }
                }
                if (found == 0) {
                    System.out.println("nothing found");
                    try {
                        Thread.sleep(20000L);
                    }
                    catch (InterruptedException ie) {
                        System.exit(1);
                    }
                } else {
                    System.out.println("" + found + " files processed");
                }
                prioscan.rescan(false);
            }
        }

        private class SyncListener
        implements ChangeListener {
            boolean ready;

            private SyncListener() {
            }

            @Override
            public synchronized void stateChanged(ChangeEvent e) {
                this.ready = true;
                this.notify();
            }

            public synchronized void reset() {
                this.ready = false;
            }

            public synchronized boolean sync() {
                try {
                    if (!this.ready) {
                        this.wait();
                    }
                }
                catch (InterruptedException ex) {
                    return false;
                }
                this.reset();
                return true;
            }
        }
    }
}

