/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.srv;

import com.mandelsoft.mand.srv.AbstractServer;
import com.mandelsoft.mand.srv.CalcRequest;
import com.mandelsoft.mand.srv.RequestProcessor;

public class LocalServer
extends AbstractServer {
    private Handler handler;
    private RequestProcessor processor;

    public LocalServer(String[] args) {
        int proc = 1;
        int c = 0;
        while (args.length > c && args[c].charAt(0) == '-') {
            String arg = args[c++];
            block6: for (int i = 1; i < arg.length(); ++i) {
                char opt = arg.charAt(i);
                switch (opt) {
                    case 'p': {
                        if (args.length > c) {
                            try {
                                proc = Integer.parseInt(args[c++]);
                                continue block6;
                            }
                            catch (Exception ex) {
                                throw new IllegalArgumentException("port number expected");
                            }
                        }
                        throw new IllegalArgumentException("port missing");
                    }
                    default: {
                        throw new IllegalArgumentException("illegal option '" + opt + "'");
                    }
                }
            }
        }
        this.processor = new RequestProcessor(proc);
    }

    public LocalServer(int n) {
        this.processor = new RequestProcessor(n);
        this.handler = new Handler();
        this.handler.start();
    }

    @Override
    public void sendRequest(CalcRequest req) {
        this.processor.sendRequest(req);
    }

    @Override
    public void syncEmpty() throws InterruptedException {
        this.processor.syncEmpty();
    }

    private class Handler
    extends Thread {
        private boolean abort = false;

        private Handler() {
        }

        public void abort() {
            this.abort = true;
        }

        @Override
        public void run() {
            do {
                try {
                    CalcRequest req = LocalServer.this.processor.getDoneView().pull();
                    req.fireChangeEvent();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!this.abort);
        }
    }
}

