/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.srv.tcp;

import com.mandelsoft.mand.srv.ImageData;
import com.mandelsoft.mand.srv.tcp.ClientData;
import com.mandelsoft.mand.srv.tcp.Constants;
import com.mandelsoft.mand.srv.tcp.ServerData;
import com.mandelsoft.mand.srv.tcp.ServerInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;

public class ServerQuery
implements Constants,
Runnable {
    private InetAddress host;
    private int port = 8181;
    private Socket socket;
    private DataInputStream is;
    private DataOutputStream os;
    private int version;
    private boolean log = false;
    private boolean verb = true;

    public ServerQuery(String[] args) {
        int c = 0;
        while (args.length > c && args[c].charAt(0) == '-') {
            String arg = args[c++];
            block9: for (int i = 1; i < arg.length(); ++i) {
                char opt = arg.charAt(i);
                switch (opt) {
                    case 'h': {
                        if (args.length > c) {
                            try {
                                this.host = InetAddress.getByName(args[c++]);
                                continue block9;
                            }
                            catch (UnknownHostException ex) {
                                throw new IllegalArgumentException("unknown host");
                            }
                        }
                        throw new IllegalArgumentException("host missing");
                    }
                    case 'p': {
                        if (args.length > c) {
                            try {
                                this.port = Integer.parseInt(args[c++]);
                                continue block9;
                            }
                            catch (Exception ex) {
                                throw new IllegalArgumentException("port number expected");
                            }
                        }
                        throw new IllegalArgumentException("port missing");
                    }
                    default: {
                        throw new IllegalArgumentException("illegal option '" + opt + "'");
                    }
                }
            }
        }
    }

    private void log(String m) {
        if (this.log) {
            System.out.println(m);
        }
    }

    private void verb(String m) {
        if (this.verb) {
            System.out.println(m);
        }
    }

    @Override
    public void run() {
        ServerInfo info = new ServerInfo();
        try {
            this.verb("connecting ...");
            if (this.host == null) {
                this.host = InetAddress.getLocalHost();
            }
            this.socket = new Socket(this.host, this.port);
            try {
                this.is = new DataInputStream(this.socket.getInputStream());
                this.os = new DataOutputStream(this.socket.getOutputStream());
                this.os.writeUTF("MandelRequestProtocol");
                this.os.writeInt(1);
                String stat = this.is.readUTF();
                if (!stat.equals("OK")) {
                    System.out.println(stat);
                    System.exit(1);
                }
                this.version = this.is.readInt();
                this.verb("protocol version is " + this.version);
                try {
                    this.os.writeInt(0);
                    this.os.writeInt(65535);
                    info.read(this.is);
                    ServerData server = info.getServer();
                    System.out.println("total number of requests:    " + server.getRequestCnt());
                    System.out.println("number of active requests:   " + server.getPending());
                    System.out.println("last request:                " + new Date(server.getLastRequest()));
                    System.out.println("number of timeouts:          " + server.getTimeouts());
                    System.out.println("last timeout:                " + new Date(server.getLastTimeout()));
                    System.out.println("total number of connections: " + server.getTotalConCnt());
                    System.out.println("number of connections:       " + server.getConCnt());
                    System.out.println("last connection:             " + new Date(server.getLastConnected()));
                    System.out.println("last contact:                " + new Date(server.getLastContact()));
                    System.out.println("total number of images:      " + server.getTotalImageCnt());
                    System.out.println("number of images:            " + server.getImageCnt());
                    System.out.println("server weight:               " + info.getWeight());
                    System.out.println("server timeout:              " + info.getTimeout());
                    System.out.println("Clients");
                    for (ClientData clientData : info.getClients()) {
                        System.out.println("  " + clientData.getHost());
                    }
                    System.out.println("Images");
                    for (ImageData imageData : info.getActiveImages()) {
                        System.out.println("  " + imageData.getName() + ": " + (imageData.isRecalc() ? "recalc " : "") + imageData.getPrecision() + "(" + imageData.getMagnification() + ") " + new Date(imageData.getStartTime()));
                    }
                    this.close("");
                }
                catch (IOException io) {
                    System.out.println("get failed: " + io);
                    this.close("");
                }
            }
            catch (IOException ex) {
                this.close();
            }
        }
        catch (IOException io) {
            System.out.println("connect failed: " + io);
            this.is = null;
            this.os = null;
        }
    }

    private void close() {
        this.close("");
    }

    private void close(String msg) {
        this.verb("close " + msg);
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.is = null;
        this.os = null;
        this.socket = null;
    }

    public static void main(String[] args) {
        try {
            new ServerQuery(args).run();
        }
        catch (Exception ex) {
            System.out.println("Fail: " + ex);
        }
    }
}

