/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.tool.MandelSpecDialog;
import com.mandelsoft.mand.util.MandArith;
import com.mandelsoft.swing.NumberField;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;

public class AltSpec
extends MandelSpecDialog<AltPanel> {
    public AltSpec(Window parent, String name, boolean change) {
        super(parent, "Alternate Area Specification", name, change);
    }

    @Override
    protected AltPanel createPanel(String name, boolean change) {
        return new AltPanel(name, change);
    }

    public BigDecimal getYmin() {
        return ((AltPanel)this.getPanel()).getYmin();
    }

    public BigDecimal getYmax() {
        return ((AltPanel)this.getPanel()).getYmax();
    }

    public BigDecimal getXmin() {
        return ((AltPanel)this.getPanel()).getXmin();
    }

    public BigDecimal getXmax() {
        return ((AltPanel)this.getPanel()).getXmax();
    }

    public class AltPanel
    extends MandelSpecDialog.Panel {
        private NumberField xmin;
        private NumberField xmax;
        private NumberField ymin;
        private NumberField ymax;

        public AltPanel(String name, boolean change) {
            super(AltSpec.this, name, change);
            this.updateListener = new UpdateListener();
            this.xmin = this.createNumberField("xmin", 1);
            this.xmax = this.createNumberField("xmax", 2);
            this.ymin = this.createNumberField("ymin", 3);
            this.ymax = this.createNumberField("ymax", 4);
            this.addBorder(0, 1, 2, 2);
            this.addBorder(0, 3, 2, 2);
        }

        @Override
        protected void _setInfo(MandelInfo info) {
            this.xmin.setValue(MandArith.sub(info.getXM(), MandArith.div(info.getDX(), 2.0)));
            this.xmax.setValue(MandArith.add(info.getXM(), MandArith.div(info.getDX(), 2.0)));
            this.ymin.setValue(MandArith.sub(info.getYM(), MandArith.div(info.getDY(), 2.0)));
            this.ymax.setValue(MandArith.add(info.getYM(), MandArith.div(info.getDY(), 2.0)));
        }

        @Override
        public boolean updateInfo(MandelInfo info) {
            BigDecimal t;
            BigDecimal xa = this.getXmax();
            BigDecimal xi = this.getXmin();
            BigDecimal ya = this.getYmax();
            BigDecimal yi = this.getYmin();
            if (xa.compareTo(xi) < 0) {
                t = xa;
                xa = xi;
                xi = t;
            }
            if (ya.compareTo(yi) < 0) {
                t = ya;
                ya = yi;
                yi = t;
            }
            info.setXM(MandArith.div(MandArith.add(xi, xa), 2.0));
            info.setYM(MandArith.div(MandArith.add(yi, ya), 2.0));
            info.setDX(MandArith.sub(xa, xi));
            info.setDY(MandArith.sub(ya, yi));
            return true;
        }

        @Override
        public void setEditable(boolean b) {
            super.setEditable(b);
            this.xmin.setEditable(b);
            this.xmax.setEditable(b);
            this.ymin.setEditable(b);
            this.ymax.setEditable(b);
        }

        public BigDecimal getXmin() {
            return (BigDecimal)this.xmin.getValue();
        }

        public BigDecimal getXmax() {
            return (BigDecimal)this.xmax.getValue();
        }

        public BigDecimal getYmin() {
            return (BigDecimal)this.ymin.getValue();
        }

        public BigDecimal getYmax() {
            return (BigDecimal)this.ymax.getValue();
        }

        private class UpdateListener
        implements PropertyChangeListener {
            private UpdateListener() {
            }

            @Override
            public synchronized void propertyChange(PropertyChangeEvent evt) {
                if (!AltPanel.this.inupdate) {
                    AltPanel.this.inupdate = true;
                    BigDecimal xa = AltPanel.this.getXmax();
                    BigDecimal xi = AltPanel.this.getXmin();
                    BigDecimal ya = AltPanel.this.getYmax();
                    BigDecimal yi = AltPanel.this.getYmin();
                    if (xa.compareTo(xi) < 0) {
                        AltPanel.this.xmax.setValue(xi);
                        AltPanel.this.xmin.setValue(xa);
                    }
                    if (ya.compareTo(yi) < 0) {
                        AltPanel.this.ymax.setValue(yi);
                        AltPanel.this.ymin.setValue(ya);
                    }
                    AltSpec.this.fireChangeEvent();
                    AltPanel.this.inupdate = false;
                }
            }
        }
    }
}

