/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.tool.MandelSpecDialog;
import com.mandelsoft.mand.tool.TagListModel;
import com.mandelsoft.swing.GBC;
import com.mandelsoft.swing.TextField;
import com.mandelsoft.util.Utils;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AttrSpec
extends MandelSpecDialog<AttrPanel> {
    public AttrSpec(Window parent, String name, boolean change) {
        super(parent, "Attribute Specification", name, change);
    }

    @Override
    protected AttrPanel createPanel(String name, boolean change) {
        return new AttrPanel(name, change);
    }

    public class AttrPanel
    extends MandelSpecDialog.Panel {
        private JList attrs;
        private DefaultListModel model;
        private JComboBox key;
        private TextField value;
        private JPanel buttons;
        private JButton add;
        private JButton remove;
        private JButton clear;

        public AttrPanel(String name, boolean change) {
            super(AttrSpec.this, name, change);
            this.model = new DefaultListModel();
            this.attrs = new JList(this.model);
            this.attrs.setPrototypeCellValue("InitialTagValueForMandelArea");
            this.attrs.setVisibleRowCount(10);
            this.attrs.setSelectionMode(0);
            this.attrs.setLayoutOrientation(0);
            this.attrs.setFixedCellWidth(1000);
            this.attrs.addListSelectionListener(new Listener());
            JScrollPane sp = new JScrollPane(this.attrs);
            this.add((Component)sp, new GBC(0, 1, 2, 1));
            this.key = new JComboBox();
            this.key.setPrototypeDisplayValue("WWWWWWWWWWWWWWWWWWWWWW");
            this.key.setEditable(true);
            this.add((Component)this.key, this.GBC(0, 2, 2).setTopInset(10));
            this.value = new TextField();
            this.value.setColumns(60);
            this.value.setEditable(true);
            this.add((Component)this.value, this.GBC(1, 2, 2).setTopInset(10));
            this.buttons = new JPanel();
            this.buttons.setLayout(new FlowLayout());
            this.add((Component)this.buttons, this.GBC(0, 3).setWeight(100.0, 0.0));
            this.add = new JButton(new AddAction());
            this.buttons.add(this.add);
            this.remove = new JButton(new RemoveAction());
            this.buttons.add(this.remove);
            this.clear = new JButton(new ClearAction());
            this.buttons.add(this.clear);
            this.setEditable(change);
        }

        @Override
        protected void panelBound() {
            super.panelBound();
            TagListModel cbm = AttrSpec.this.getMandelWindowAccess().getEnvironment().getAttributeModel();
            this.key.setModel(cbm);
        }

        @Override
        protected void panelUnbound() {
            super.panelUnbound();
            DefaultComboBoxModel cbm = new DefaultComboBoxModel();
            this.key.setModel(cbm);
        }

        @Override
        protected void _setInfo(MandelInfo info) {
            this.model.clear();
            if (info.getProperties() != null) {
                for (Map.Entry<String, String> e : info.getProperties().entrySet()) {
                    this.model.addElement(e.getKey() + "=" + e.getValue());
                }
            }
        }

        @Override
        public boolean updateInfo(MandelInfo info) {
            super.updateInfo(info);
            info.clearProperties();
            for (Object o : this.model.toArray()) {
                String s = o.toString();
                if (Utils.isEmpty(s)) continue;
                String[] elems = s.split("=");
                info.setProperty(elems[0], elems[1]);
            }
            return true;
        }

        @Override
        public void setEditable(boolean b) {
            super.setEnabled(b);
            this.key.setVisible(b);
            this.value.setVisible(b);
            this.add.setVisible(b);
            this.remove.setVisible(b);
            this.clear.setVisible(b);
        }

        private class Listener
        implements ListSelectionListener {
            private Listener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String s = (String)AttrPanel.this.attrs.getSelectedValue();
                if (s != null) {
                    String[] elems = s.split("=");
                    AttrPanel.this.key.setSelectedItem(elems[0]);
                    AttrPanel.this.value.setText(elems[1]);
                }
            }
        }

        private class AddAction
        extends AbstractAction {
            public AddAction() {
                super("Add");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String k = (String)AttrPanel.this.key.getSelectedItem();
                String v = AttrPanel.this.value.getDataValue();
                if (!Utils.isEmpty(k) && !Utils.isEmpty(v)) {
                    String s = k + "=";
                    String n = s + v;
                    for (Object o : AttrPanel.this.model.toArray()) {
                        if (o.equals(n)) {
                            return;
                        }
                        if (!((String)o).startsWith(k)) continue;
                        AttrPanel.this.model.removeElement(o);
                    }
                    AttrPanel.this.model.addElement(n);
                    AttrSpec.this.fireChangeEvent();
                }
            }
        }

        private class RemoveAction
        extends AbstractAction {
            public RemoveAction() {
                super("Remove");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String k = (String)AttrPanel.this.key.getSelectedItem();
                if (!Utils.isEmpty(k)) {
                    String s = k + "=";
                    for (Object o : AttrPanel.this.model.toArray()) {
                        if (!((String)o).startsWith(k)) continue;
                        AttrPanel.this.model.removeElement(o);
                        AttrSpec.this.fireChangeEvent();
                        return;
                    }
                }
            }
        }

        private class ClearAction
        extends AbstractAction {
            public ClearAction() {
                super("Clear");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                AttrPanel.this.model.clear();
                AttrSpec.this.fireChangeEvent();
            }
        }
    }
}

