/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tool.DefaultMandelListFolderTreeModel;
import com.mandelsoft.mand.tool.DefaultMandelListTableModel;
import com.mandelsoft.mand.tool.MandelListFolderTreeModel;
import com.mandelsoft.mand.tool.MandelListFolderTreeModelListener;
import com.mandelsoft.mand.tool.MandelListFolderTreeModelSupport;
import com.mandelsoft.mand.tool.MandelListProxyTableModel;
import com.mandelsoft.mand.tool.MandelListTableModel;
import com.mandelsoft.mand.util.ArrayMandelListFolder;
import com.mandelsoft.mand.util.DefaultMandelListFolderTree;
import com.mandelsoft.mand.util.FileMandelList;
import com.mandelsoft.mand.util.FileMandelListFolderTree;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.mand.util.MandelListFolderTree;
import com.mandelsoft.util.Utils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class ComposedMandelListFolderTreeModel
extends MandelListFolderTreeModelSupport
implements MandelListFolderTreeModel {
    public static boolean debug = false;
    private MandelListFolderTree tree;
    private MandelScanner scanner;
    private boolean modifiable;
    private Map<MandelListFolder, FolderWrapper> map;
    private Map<MandelListFolderTree, FolderLink> links;
    private List<ComposedTreeModelListener> listeners;

    public ComposedMandelListFolderTreeModel(String name, MandelScanner scanner) {
        this.scanner = scanner;
        this.tree = new FolderTree(name);
        this.map = new HashMap<MandelListFolder, FolderWrapper>();
        this.links = new HashMap<MandelListFolderTree, FolderLink>();
        this.listmodels = new HashMap();
        this.listeners = new ArrayList<ComposedTreeModelListener>();
    }

    @Override
    public void clear() {
        if (debug) {
            System.out.println("clear " + this.tree.getRoot().getName() + ": " + this);
        }
        for (ComposedTreeModelListener l : this.listeners) {
            l.clear();
        }
        this.listeners.clear();
        this.map.clear();
        this.links.clear();
        super.clear();
    }

    @Override
    protected boolean isModifiable(MandelListFolder f) {
        return super.isModifiable(f);
    }

    @Override
    public boolean isPathEditable(TreePath path) {
        ComposedFolder c = (ComposedFolder)path.getLastPathComponent();
        if (this.isLogical(c)) {
            return false;
        }
        return this.mapToEffectiveModel(c).isPathEditable(this.getEffectiveTreePath(path));
    }

    @Override
    public boolean isPathModifiable(TreePath path) {
        ComposedFolder c = (ComposedFolder)path.getLastPathComponent();
        if (this.isLogical(c)) {
            return false;
        }
        return this.mapToEffectiveModel(c).isPathModifiable(this.getEffectiveTreePath(path));
    }

    @Override
    public boolean isPathListModifiable(TreePath path) {
        ComposedFolder c = (ComposedFolder)path.getLastPathComponent();
        if (this.isLogical(c)) {
            return false;
        }
        return this.mapToEffectiveModel(c).isPathListModifiable(this.getEffectiveTreePath(path));
    }

    @Override
    public boolean isPathTransferable(TreePath path) {
        ComposedFolder c = (ComposedFolder)path.getLastPathComponent();
        if (this.isLogical(c)) {
            return false;
        }
        return this.mapToEffectiveModel(c).isPathTransferable(this.getEffectiveTreePath(path));
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        ComposedFolder c = (ComposedFolder)path.getLastPathComponent();
        if (this.isLogical(c)) {
            super.valueForPathChanged(path, newValue);
        } else {
            this.mapToEffectiveModel(c).valueForPathChanged(this.getEffectiveTreePath(path), newValue);
        }
    }

    @Override
    public MandelListFolderTree getFolderTree() {
        return this.tree;
    }

    @Override
    protected MandelScanner getMandelScanner() {
        return this.scanner;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    @Override
    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    @Override
    public MandelListTableModel getMandelListModel(Object folder) {
        ComposedFolder f = (ComposedFolder)folder;
        MandelListTableModel m = this.isLogical(f) ? super.getMandelListModel(folder) : f.getEffectiveFolderTreeModel().getMandelListModel(f.getEffectiveFolder());
        return m;
    }

    @Override
    public MandelListFolder insertFolder(String name, MandelListFolder parent) {
        ComposedFolder c = (ComposedFolder)parent;
        if (this.isLogical(c)) {
            return super.insertFolder(name, parent);
        }
        return ((FolderWrapper)c).mapToComposedChild(c.getEffectiveFolderTreeModel().insertFolder(name, c.getEffectiveFolder()));
    }

    @Override
    public boolean insertFolders(int index, MandelListFolder[] folders, MandelListFolder parent) {
        ComposedFolder c = (ComposedFolder)parent;
        if (this.isLogical(c)) {
            return super.insertFolders(index, folders, parent);
        }
        boolean b = c.getEffectiveFolderTreeModel().insertFolders(index, this.mapToEffectiveFolder((T[])folders), c.getEffectiveFolder());
        if (b) {
            ((FolderWrapper)c).assureChildren(folders);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveFolders(int index, MandelListFolder[] folders, MandelListFolder parent) {
        try {
            ComposedFolder c = (ComposedFolder)parent;
            this.moving = true;
            if (this.isLogical(c)) {
                super.moveFolders(index, folders, parent);
            } else {
                MandelListFolderTree pt = c.getEffectiveFolderTree();
                MandelListFolderTree mt = ((ComposedFolder)folders[0]).getEffectiveFolderTree();
                if (mt == pt) {
                    c.getEffectiveFolderTreeModel().moveFolders(index, this.mapToEffectiveFolder((T[])folders), c.getEffectiveFolder());
                    ((FolderWrapper)c).assureChildren(folders);
                } else {
                    this.insertFolders(index, folders, parent);
                    for (int i = 0; i < folders.length; ++i) {
                        this.removeFolder(folders[i]);
                    }
                }
            }
        }
        finally {
            this.moving = false;
        }
    }

    @Override
    public void removeFolder(MandelListFolder node) {
        ComposedFolder c = (ComposedFolder)node;
        if (this.isLogical(c)) {
            super.removeFolder(node);
        } else {
            c.getEffectiveFolderTreeModel().removeFolder(c.getEffectiveFolder());
            ((FolderWrapper)c).removeEffectiveChild(c.getEffectiveFolder());
        }
    }

    protected boolean isLogical(Object f) {
        if (((MandelListFolder)f).getMandelListFolderTree() != this.tree) {
            throw new IllegalArgumentException("non local folder");
        }
        return ((ComposedFolder)f).getEffectiveFolderTree() == this.tree;
    }

    public void addListModel(MandelListTableModel model, String name) {
        DefaultMandelListFolderTreeModel m = new DefaultMandelListFolderTreeModel(new File(name).getName(), model);
        this.addFolderTreeModel(m, name);
    }

    public void addListModel(MandelListTableModel model, String name, boolean modifiable) {
        DefaultMandelListFolderTreeModel m = new DefaultMandelListFolderTreeModel(new File(name).getName(), model);
        if (!modifiable) {
            m.setModifiable(modifiable);
        }
        this.addFolderTreeModel(m, name);
    }

    public void addListModel(MandelListTableModel model, String name, String desc) {
        DefaultMandelListFolderTreeModel m = new DefaultMandelListFolderTreeModel(new File(name).getName(), model, desc);
        this.addFolderTreeModel(m, name);
    }

    public void addFolderTreeModel(MandelListFolderTreeModel model, String name) {
        MandelListFolder p;
        MandelListFolder f = this.tree.getRoot();
        StringTokenizer t = new StringTokenizer(name, "/");
        String n = null;
        while (t.hasMoreTokens()) {
            n = t.nextToken();
            if (!t.hasMoreTokens()) continue;
            p = null;
            for (MandelListFolder s : f) {
                if (!s.getName().equals(n)) continue;
                p = s;
                break;
            }
            if (p == null) {
                p = new LogicalFolder(n);
                f.add(p);
            }
            f = p;
        }
        if (n == null) {
            throw new IllegalArgumentException("illegal path name");
        }
        p = new FolderLink(n, model);
        f.add(p);
        this.listeners.add(new ComposedTreeModelListener(model, ComposedMandelListFolderTreeModel.getPathToRoot(p).getPath()));
    }

    protected MandelListFolderTreeModel mapToEffectiveModel(MandelListFolder f) {
        FolderLink l;
        MandelListFolderTree t = f.getMandelListFolderTree();
        if (t == this.tree) {
            return ((ComposedFolder)f).getEffectiveFolderTreeModel();
        }
        if (t != null && (l = this.mapToComposedLink(t)) != null) {
            return l.getEffectiveFolderTreeModel();
        }
        throw new IllegalArgumentException("illegal folder " + f.getClass() + ": " + f.getMandelListFolderTree());
    }

    private FolderLink mapToComposedLink(MandelListFolderTree tree) {
        return this.links.get(tree);
    }

    private FolderWrapper _mapToComposedFolder(MandelListFolder f) {
        FolderWrapper m = this.map.get(f);
        if (m == null && f != null) {
            m = new FolderWrapper(this.mapToEffectiveModel(f), f);
        }
        return m;
    }

    protected MandelListFolder mapToEffectiveFolder(Object o) {
        return ((ComposedFolder)o).getEffectiveFolder();
    }

    protected <T> T[] mapToEffectiveFolder(T[] oa) {
        Object[] na = (Object[])Array.newInstance(oa.getClass().getComponentType(), oa.length);
        for (int i = 0; i < oa.length; ++i) {
            na[i] = this.mapToEffectiveFolder(oa[i]);
        }
        return na;
    }

    protected TreePath getEffectiveTreePath(TreePath p) {
        ComposedFolder c = (ComposedFolder)p.getLastPathComponent();
        if (this.isLogical(p.getParentPath().getLastPathComponent())) {
            return new TreePath(c.getEffectiveFolder());
        }
        return this.getEffectiveTreePath(p.getParentPath()).pathByAddingChild(c.getEffectiveFolder());
    }

    protected void cleanup(MandelListFolder f, boolean incl) {
        for (MandelListFolder s : f) {
            if (this.map.get(s) == null) continue;
            this.cleanup(s, true);
        }
        if (incl) {
            this.map.remove(f);
        }
    }

    public static String path(MandelListFolder f) {
        if (f == null) {
            return "/";
        }
        return ComposedMandelListFolderTreeModel.path(f.getParent()) + "/" + f.getName();
    }

    public static String path(TreePath p) {
        if (p.getPathCount() == 1) {
            return ((MandelListFolder)p.getLastPathComponent()).getName();
        }
        return ComposedMandelListFolderTreeModel.path(p.getParentPath()) + "/" + ((MandelListFolder)p.getLastPathComponent()).getName();
    }

    public static String event(TreeModelEvent e) {
        String r = ComposedMandelListFolderTreeModel.path(e.getTreePath());
        if (e.getChildren() != null) {
            r = r + ": children ";
            int c = 91;
            if (e.getChildren().length == 0) {
                r = r + (char)c;
            } else {
                for (Object o : e.getChildren()) {
                    r = r + (char)c + ((MandelListFolder)o).getName();
                    c = 44;
                }
            }
            r = r + ']';
        }
        return r;
    }

    public static void print(String gap, MandelListFolder f) {
        System.out.println(ComposedMandelListFolderTreeModel.path(f));
        for (MandelListFolder s : f) {
            ComposedMandelListFolderTreeModel.print(gap + "  ", s);
        }
    }

    public static void dump(MandelListFolderTreeModel m) {
        ComposedMandelListFolderTreeModel.print("", m.getRoot());
    }

    public static MandelListFolderTreeModel createDemo(MandelListFolderTree t) {
        DefaultMandelListFolderTreeModel m = new DefaultMandelListFolderTreeModel(t, null);
        m.setModifiable(true);
        ComposedMandelListFolderTreeModel c = new ComposedMandelListFolderTreeModel("test", null);
        c.addFolderTreeModel(m, "laber/bla");
        File file = new File("list");
        if (file.exists()) {
            FileMandelList l = new FileMandelList(file);
            DefaultMandelListTableModel lm = new DefaultMandelListTableModel(l, null);
            lm.addAction(new AbstractAction("TEST"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("hurra!");
                }
            });
            lm.setModifiable(true);
            DefaultMandelListFolderTreeModel fm = new DefaultMandelListFolderTreeModel("leaf", lm);
            c.addFolderTreeModel(fm, "laber/dummy");
            MandelListProxyTableModel pm = new MandelListProxyTableModel(lm);
            pm.setModifiable(false);
            fm = new DefaultMandelListFolderTreeModel("readonly", pm);
            c.addFolderTreeModel(fm, "laber/readonly");
        }
        c.setModifiable(true);
        c.addTreeModelListener(new Listener());
        ComposedMandelListFolderTreeModel r = new ComposedMandelListFolderTreeModel("root", null);
        r.addFolderTreeModel(m, "test");
        return r;
    }

    public static void main(String[] args) {
        File file = new File(args[0]);
        FileMandelListFolderTree t = new FileMandelListFolderTree(file);
        DefaultMandelListFolderTreeModel m = new DefaultMandelListFolderTreeModel(t, null);
        ComposedMandelListFolderTreeModel c = new ComposedMandelListFolderTreeModel("test", null);
        c.addFolderTreeModel(m, "laber/bla");
        c.addTreeModelListener(new Listener());
        ComposedMandelListFolderTreeModel.dump(c);
        MandelListFolder s = (MandelListFolder)((MandelListFolder)t.getRoot().get(1)).get(0);
        m.insertFolder("Test", s);
    }

    private class FolderWrapper
    implements ComposedFolder {
        private MandelListFolder folder;
        private MandelListFolderTreeModel model;
        private HashMap<MandelListFolder, FolderWrapper> mappedchildren;

        public FolderWrapper(MandelListFolderTreeModel model, MandelListFolder folder) {
            this.model = model;
            this.mappedchildren = new HashMap();
            this.setEffectiveFolder(folder);
            if (debug) {
                System.out.println("create wrapper " + this);
            }
        }

        public String toString() {
            String s = this.getName() + " (" + Utils.getObjectIdentifier(super.toString());
            s = s + "): " + Utils.getObjectIdentifier(ComposedMandelListFolderTreeModel.this.tree) + "-> " + this.folder;
            return s;
        }

        protected void setEffectiveFolder(MandelListFolder f) {
            if (this.folder == f) {
                return;
            }
            if (this.folder != null) {
                ComposedMandelListFolderTreeModel.this.map.remove(this.folder);
            }
            this.folder = f;
            ComposedMandelListFolderTreeModel.this.map.put(f, this);
        }

        protected void reset() {
            if (debug) {
                System.out.println("resetting " + this);
            }
            for (FolderWrapper w : this.mappedchildren.values()) {
                w.reset();
            }
            for (MandelListFolder f : this.mappedchildren.keySet()) {
                ComposedMandelListFolderTreeModel.this.map.remove(f);
            }
            this.mappedchildren.clear();
        }

        FolderWrapper mapToComposedChild(MandelListFolder f) {
            FolderWrapper w = this.mappedchildren.get(f);
            if (w == null) {
                w = ComposedMandelListFolderTreeModel.this._mapToComposedFolder(f);
                this.mappedchildren.put(f, w);
            }
            return w;
        }

        void removeEffectiveChild(MandelListFolder f) {
            if (this.mappedchildren.containsKey(f)) {
                this.mappedchildren.remove(f);
                ComposedMandelListFolderTreeModel.this.map.remove(f);
            }
        }

        void assureChildren(MandelListFolder[] folders) {
            for (MandelListFolder f : folders) {
                FolderWrapper w = (FolderWrapper)f;
                MandelListFolder e = w.getEffectiveFolder();
                if (!this.folder.contains(e) || this.mappedchildren.containsKey(e)) continue;
                this.mappedchildren.put(e, w);
            }
        }

        @Override
        public MandelListFolderTreeModel getEffectiveFolderTreeModel() {
            return this.model;
        }

        @Override
        public MandelListFolderTree getEffectiveFolderTree() {
            return this.folder.getMandelListFolderTree();
        }

        @Override
        public MandelListFolder getEffectiveFolder() {
            return this.folder;
        }

        @Override
        public MandelListFolderTree getMandelListFolderTree() {
            return ComposedMandelListFolderTreeModel.this.tree;
        }

        @Override
        public void setParent(MandelListFolder f) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public void setName(String name) {
            this.folder.setName(name);
        }

        @Override
        public void setThumbnailName(QualifiedMandelName thumb) {
            this.folder.setThumbnailName(thumb);
        }

        @Override
        public String getPath() {
            if (this.getParent() == null) {
                return this.getName();
            }
            StringBuffer sb = new StringBuffer();
            this.getPath(sb, this.getParent());
            sb.append("/");
            sb.append(this.getName());
            return sb.toString();
        }

        private void getPath(StringBuffer sb, MandelListFolder f) {
            if (f.getParent() != null) {
                this.getPath(sb, f.getParent());
                sb.append("/");
            }
            sb.append(f.getName());
        }

        @Override
        public MandelListFolder getParent() {
            MandelListFolder p = this.folder.getParent();
            FolderWrapper w = ComposedMandelListFolderTreeModel.this._mapToComposedFolder(p);
            if (w != null) {
                w.mappedchildren.put(this.folder, this);
            }
            return w;
        }

        @Override
        public MandelListFolder getSubFolder(String name) {
            MandelListFolder f = this.folder.getSubFolder(name);
            return this.mapToComposedChild(f);
        }

        @Override
        public String getName() {
            return this.folder.getName();
        }

        @Override
        public QualifiedMandelName getThumbnailName() {
            return this.folder.getThumbnailName();
        }

        @Override
        public boolean isLeaf() {
            return this.folder.isLeaf();
        }

        @Override
        public MandelList getMandelList() {
            return this.folder.getMandelList();
        }

        @Override
        public boolean hasMandelList() {
            return this.folder.hasMandelList();
        }

        @Override
        public MandelListFolder createSubFolder(int index, String name) {
            MandelListFolder f = this.folder.createSubFolder(index, name);
            return this.mapToComposedChild(f);
        }

        @Override
        public MandelListFolder createSubFolder(String name) {
            MandelListFolder f = this.folder.createSubFolder(name);
            return this.mapToComposedChild(f);
        }

        @Override
        public boolean containsTransitively(MandelListFolder f) {
            while (f != null && f != this) {
                f = f.getParent();
            }
            return f == this;
        }

        @Override
        public boolean containsTransitively(MandelList l) {
            if (this.getMandelList() == l) {
                return true;
            }
            for (MandelListFolder f : this) {
                if (!f.containsTransitively(l)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void setProperty(String name, String value) {
            this.folder.setProperty(name, value);
        }

        @Override
        public String getProperty(String name) {
            return this.folder.getProperty(name);
        }

        @Override
        public Iterable<String> propertyNames() {
            return this.folder.propertyNames();
        }

        @Override
        public boolean valid() {
            return this.folder.valid();
        }

        @Override
        public void save() throws IOException {
            this.folder.save();
        }

        @Override
        public void refresh(boolean soft) {
            ComposedMandelListFolderTreeModel.this.cleanup(this.folder.getMandelListFolderTree().getRoot(), false);
            this.folder.refresh(soft);
        }

        @Override
        public void clear() {
            ComposedMandelListFolderTreeModel.this.cleanup(this.folder, false);
            this.folder.clear();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            a = this.folder.toArray(a);
            for (int i = 0; i < a.length; ++i) {
                a[i] = this.mapToComposedChild((MandelListFolder)a[i]);
            }
            return a;
        }

        @Override
        public Object[] toArray() {
            Object[] a = this.folder.toArray();
            for (int i = 0; i < a.length; ++i) {
                a[i] = this.mapToComposedChild((MandelListFolder)a[i]);
            }
            return a;
        }

        @Override
        public List<MandelListFolder> subList(int fromIndex, int toIndex) {
            ArrayList<MandelListFolder> a = new ArrayList<MandelListFolder>();
            for (MandelListFolder f : this.folder.subList(fromIndex, toIndex)) {
                a.add(this.mapToComposedChild(f));
            }
            return a;
        }

        @Override
        public int size() {
            return this.folder.size();
        }

        @Override
        public MandelListFolder set(int index, MandelListFolder element) {
            throw new UnsupportedOperationException("Not supported.");
        }

        protected Collection<?> mapC(Collection<?> c) {
            ArrayList<Object> r = new ArrayList<Object>();
            for (Object e : c) {
                r.add(this.map((MandelListFolder)e));
            }
            return r;
        }

        protected Object map(Object e) {
            if (e instanceof ComposedFolder) {
                ComposedFolder w = (ComposedFolder)e;
                e = w.getEffectiveFolder();
            }
            return e;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.folder.retainAll(this.mapC(c));
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.folder.removeAll(this.mapC(c));
        }

        @Override
        public MandelListFolder remove(int index) {
            return (MandelListFolder)this.folder.remove(index);
        }

        @Override
        public boolean remove(Object o) {
            return this.folder.remove(this.map(o));
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.folder.lastIndexOf(this.map(o));
        }

        @Override
        public boolean isEmpty() {
            return this.folder.isEmpty();
        }

        @Override
        public int indexOf(Object o) {
            return this.folder.indexOf(this.map(o));
        }

        @Override
        public MandelListFolder get(int index) {
            return this.mapToComposedChild((MandelListFolder)this.folder.get(index));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.folder.containsAll(this.mapC(c));
        }

        @Override
        public boolean contains(Object o) {
            return this.folder.contains(this.map(o));
        }

        @Override
        public boolean addAll(int index, Collection<? extends MandelListFolder> c) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean addAll(Collection<? extends MandelListFolder> c) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public void add(int index, MandelListFolder element) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean add(MandelListFolder e) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public ListIterator<MandelListFolder> listIterator(int index) {
            return new MappedIterator(this.folder.listIterator(index));
        }

        @Override
        public ListIterator<MandelListFolder> listIterator() {
            return new MappedIterator(this.folder.listIterator());
        }

        @Override
        public Iterator<MandelListFolder> iterator() {
            return this.listIterator();
        }

        @Override
        public Iterable<QualifiedMandelName> allentries() {
            return this.folder.allentries();
        }

        @Override
        public Iterable<MandelListFolder> allfolders() {
            return new Iterable<MandelListFolder>(){

                @Override
                public Iterator<MandelListFolder> iterator() {
                    return new MappedIteratorBase(FolderWrapper.this, FolderWrapper.this.folder.allfolders().iterator());
                }
            };
        }

        private class MappedIterator
        extends MappedIteratorBase<ListIterator<MandelListFolder>>
        implements ListIterator<MandelListFolder> {
            public MappedIterator(ListIterator<MandelListFolder> it) {
                super(FolderWrapper.this, it);
            }

            @Override
            public void set(MandelListFolder e) {
                throw new UnsupportedOperationException("Not supported.");
            }

            @Override
            public int previousIndex() {
                return ((ListIterator)this.it).previousIndex();
            }

            @Override
            public MandelListFolder previous() {
                return (MandelListFolder)((ListIterator)this.it).previous();
            }

            @Override
            public int nextIndex() {
                return ((ListIterator)this.it).nextIndex();
            }

            @Override
            public boolean hasPrevious() {
                return ((ListIterator)this.it).hasPrevious();
            }

            @Override
            public void add(MandelListFolder e) {
                throw new UnsupportedOperationException("Not supported.");
            }
        }

        private static class MappedIteratorBase<I extends Iterator<MandelListFolder>>
        implements Iterator<MandelListFolder> {
            protected I it;
            final /* synthetic */ FolderWrapper this$1;

            public MappedIteratorBase(I it) {
                this.this$1 = var1_1;
                this.it = it;
            }

            @Override
            public void remove() {
                this.it.remove();
            }

            @Override
            public MandelListFolder next() {
                MandelListFolder f = (MandelListFolder)this.it.next();
                return this.this$1.mapToComposedChild(f);
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }
        }
    }

    private class FolderTree
    extends DefaultMandelListFolderTree {
        FolderTree(String name) {
            super(new LogicalFolder(name));
        }

        @Override
        public void read(InputStream is, String src) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class ComposedTreeModelListener
    implements TreeModelListener,
    MandelListFolderTreeModelListener {
        private Object[] basepath;
        MandelListFolderTreeModel model;

        public ComposedTreeModelListener(MandelListFolderTreeModel model, Object[] basepath) {
            this.basepath = basepath;
            if (debug) {
                System.out.println("composed listener for ");
                for (Object o : basepath) {
                    System.out.println("  " + o);
                }
            }
            this.model = model;
            model.addTreeModelListener(this);
            model.addMandelListFolderTreeModelListener(this);
        }

        public void clear() {
            this.model.removeTreeModelListener(this);
            this.model.removeMandelListFolderTreeModelListener(this);
        }

        private void dump(String msg, TreeModelEvent e) {
            if (debug) {
                Object[] oa;
                System.out.println(msg + ":");
                for (Object o : oa = e.getPath()) {
                    System.out.println("    " + o);
                }
                oa = e.getChildren();
                if (oa != null && oa.length > 0) {
                    System.out.println("  children:");
                    for (Object o : oa) {
                        System.out.println("    " + o);
                    }
                }
                System.out.println("--");
            }
        }

        private Object map(Object last, boolean cont, int sindex, int eindex, Object[] oa, int index, Object[] na) {
            for (int i = sindex; i < eindex; ++i) {
                FolderWrapper w = (FolderWrapper)last;
                FolderWrapper next = w.mapToComposedChild((MandelListFolder)oa[i]);
                na[i - sindex + index] = next;
                if (!cont) continue;
                last = next;
            }
            return last;
        }

        private TreeModelEvent mapToComposedEvent(String msg, TreeModelEvent e) {
            Object[] o = e.getPath();
            Object[] no = new Object[o.length + this.basepath.length - 1];
            this.dump("got " + msg, e);
            for (int i = 0; i < this.basepath.length; ++i) {
                no[i] = this.basepath[i];
            }
            Object last = this.basepath[this.basepath.length - 1];
            last = this.map(last, true, 1, o.length, o, this.basepath.length, no);
            Object[] c = e.getChildren();
            Object[] nc = null;
            if (c != null) {
                nc = new Object[c.length];
                this.map(last, false, 0, c.length, c, 0, nc);
            }
            e = new TreeModelEvent((Object)ComposedMandelListFolderTreeModel.this, no, e.getChildIndices(), nc);
            this.dump("mapped for " + Utils.getObjectIdentifier(ComposedMandelListFolderTreeModel.this.tree), e);
            return e;
        }

        @Override
        public void foldersDeleted(TreeModelEvent e) {
            ComposedMandelListFolderTreeModel.this.fireFoldersDeleted(this.mapToComposedEvent("FD", e));
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            ComposedMandelListFolderTreeModel.this.fireTreeNodesChanged(this.mapToComposedEvent("TNC", e));
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            ComposedMandelListFolderTreeModel.this.fireTreeNodesInserted(this.mapToComposedEvent("TNI", e));
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            ComposedMandelListFolderTreeModel.this.fireTreeNodesRemoved(this.mapToComposedEvent("TNR", e));
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            TreeModelEvent m = this.mapToComposedEvent("TSC", e);
            Object[] p = m.getPath();
            Object[] c = m.getChildren();
            if (c == null || c.length == 0) {
                ((FolderWrapper)p[p.length - 1]).reset();
            } else {
                for (Object o : c) {
                    ((FolderWrapper)o).reset();
                }
            }
            ComposedMandelListFolderTreeModel.this.fireTreeStructureChanged(m);
        }
    }

    private static interface ComposedFolder
    extends MandelListFolder {
        public MandelListFolderTree getEffectiveFolderTree();

        public MandelListFolderTreeModel getEffectiveFolderTreeModel();

        public MandelListFolder getEffectiveFolder();
    }

    private class LogicalFolder
    extends ArrayMandelListFolder
    implements ComposedFolder {
        public LogicalFolder(String name) {
            super(name);
        }

        @Override
        public MandelListFolderTreeModel getEffectiveFolderTreeModel() {
            return ComposedMandelListFolderTreeModel.this;
        }

        @Override
        public MandelListFolderTree getEffectiveFolderTree() {
            return ComposedMandelListFolderTreeModel.this.tree;
        }

        @Override
        public MandelListFolder getEffectiveFolder() {
            return this;
        }

        @Override
        protected MandelList createMandelList() {
            return null;
        }

        @Override
        public MandelListFolderTree getMandelListFolderTree() {
            return ComposedMandelListFolderTreeModel.this.tree;
        }

        @Override
        public LogicalFolder createSubFolder(String name) {
            LogicalFolder f = new LogicalFolder(name);
            super.add(f);
            return f;
        }

        @Override
        public LogicalFolder createSubFolder(int index, String name) {
            LogicalFolder f = new LogicalFolder(name);
            if (index < 0) {
                index = this.size();
            }
            super.add(index, f);
            return f;
        }
    }

    private class FolderLink
    extends FolderWrapper {
        private String name;
        private MandelListFolder parent;

        public FolderLink(String name, MandelListFolderTreeModel link) {
            super(link, link.getRoot());
            this.name = name;
            ComposedMandelListFolderTreeModel.this.links.put(link.getFolderTree(), this);
        }

        @Override
        protected void reset() {
            this.setEffectiveFolder(this.getEffectiveFolderTreeModel().getRoot());
            super.reset();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public MandelListFolder getParent() {
            return this.parent;
        }

        @Override
        public void setParent(MandelListFolder parent) {
            this.parent = parent;
        }
    }

    private static class Listener
    implements TreeModelListener {
        private Listener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            if (debug) {
                System.out.println("CHD: " + ComposedMandelListFolderTreeModel.event(e));
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            if (debug) {
                System.out.println("INS: " + ComposedMandelListFolderTreeModel.event(e));
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            if (debug) {
                System.out.println("REM: " + ComposedMandelListFolderTreeModel.event(e));
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            if (debug) {
                System.out.println("STR: " + ComposedMandelListFolderTreeModel.event(e));
            }
        }
    }
}

