/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.tool.Decoration;
import com.mandelsoft.swing.Scale;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;

public class DynamicColor
implements Decoration.ColorHandler {
    private ImageSource source;

    public DynamicColor(ImageSource source) {
        this.source = source;
    }

    @Override
    public Color getColor(int x, int y, int w, int h) {
        int[] values;
        BufferedImage image = this.source.getImage();
        Scale scale = this.source.getScale();
        x = (int)((double)x / scale.getX());
        y = (int)((double)y / scale.getY());
        w = (int)((double)w / scale.getX());
        if ((h = (int)((double)h / scale.getY())) == 0) {
            h = 1;
        }
        if (w == 0) {
            w = 1;
        }
        if (x + w > image.getWidth()) {
            x = image.getWidth() - w;
        }
        if (y > image.getHeight()) {
            y = image.getHeight();
        }
        System.out.printf("determine font color for (%d,%d))[%d,%d] (scale %s)\n", x, y, w, h, scale);
        int sum = 0;
        ColorModel m = image.getColorModel();
        for (int v : values = image.getRGB(x, y - h, w, h, null, 0, w)) {
            sum += m.getRed(v) + m.getGreen(v) + m.getBlue(v);
        }
        if (sum / 3 / values.length > 128) {
            return Color.BLACK;
        }
        return Color.WHITE;
    }

    public static interface ImageSource {
        public BufferedImage getImage();

        public Scale getScale();
    }

    public static class StaticImage
    implements ImageSource {
        private BufferedImage image;

        public StaticImage(BufferedImage image) {
            this.image = image;
        }

        @Override
        public BufferedImage getImage() {
            return this.image;
        }

        @Override
        public Scale getScale() {
            return Scale.One;
        }
    }
}

