/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelHeader;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.scan.ColormapHandle;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerListener;
import com.mandelsoft.mand.tool.MandelListListener;
import com.mandelsoft.mand.tool.MandelListModel;
import com.mandelsoft.mand.tool.MandelListTableModel;
import com.mandelsoft.mand.tool.ToolEnvironment;
import com.mandelsoft.util.ChangeEvent;
import com.mandelsoft.util.StateChangeSupport;
import java.util.Set;

public class ImageBaseModel
extends StateChangeSupport {
    private static boolean debug = true;
    private ToolEnvironment env;
    private int all;
    private int available;
    private int rasters;
    private int modifiableImages;
    private int requests;
    private int variants;
    private int others;
    private int colormaps;
    private int unseen;
    private int unseenRefine;
    private int refineRequests;
    private boolean changed = false;
    private boolean updatePending = false;
    private EnvUpdateHandler listener;

    public ImageBaseModel(ToolEnvironment env) {
        this.env = env;
        this.listener = new EnvUpdateHandler();
        env.getAllScanner().addMandelScannerListener(this.listener);
        this.add(env.getUnseenRefinementsModel());
        this.add(env.getRefinementRequestsModel());
        this.add(env.getUnseenRastersModel());
        this.updateData();
    }

    public ToolEnvironment getEnvironment() {
        return this.env;
    }

    public int getAllAreas() {
        return this.all;
    }

    public int getAvailableImages() {
        return this.available;
    }

    public int getColormaps() {
        return this.colormaps;
    }

    public int getModifiableImages() {
        return this.modifiableImages;
    }

    public int getOthers() {
        return this.others;
    }

    public int getRasters() {
        return this.rasters;
    }

    public int getRefinementRequests() {
        return this.refineRequests;
    }

    public int getRequests() {
        return this.requests;
    }

    public int getUnseenAreas() {
        return this.unseen;
    }

    public int getUnseenRefinements() {
        return this.unseenRefine;
    }

    public int getVariants() {
        return this.variants;
    }

    private void add(MandelListModel m) {
        if (m != null) {
            m.addMandelListListener(this.listener);
        }
    }

    private void remove(MandelListModel m) {
        if (m != null) {
            m.removeMandelListListener(this.listener);
        }
    }

    public synchronized void handleUpdate() {
        if (this.updatePending) {
            this.startUpdate();
            this.updateData();
            this.updatePending = false;
            this.finishUpdate();
        } else if (debug) {
            System.out.println("no update pending for image base statistic");
        }
    }

    private void updateListSizes() {
        if (debug) {
            System.out.println("  update list statistic");
        }
        this.unseen = this.set("unseen", this.unseen, this.env.getUnseenRastersModel());
        this.unseenRefine = this.set("unseen refinemnts", this.unseenRefine, this.env.getUnseenRefinementsModel());
        this.refineRequests = this.set("refinements", this.refineRequests, this.env.getRefinementRequestsModel());
    }

    private int set(String key, int value, MandelListTableModel list) {
        if (list != null) {
            value = this.set(key, value, list.getRowCount());
        }
        return value;
    }

    private int set(String key, int value, int n) {
        String attr = "";
        if (n != value) {
            this.changed = true;
            attr = " (changed)";
            value = n;
        }
        if (debug) {
            System.out.println("  " + key + "=" + value + attr);
        }
        return value;
    }

    private void updateData() {
        int c_all = 0;
        int c_mod = 0;
        int c_req = 0;
        int c_ras = 0;
        int c_var = 0;
        int c_oth = 0;
        if (debug) {
            System.out.println("update statistic");
        }
        MandelScanner scan = this.env.getAllScanner();
        Set<MandelName> names = scan.getMandelNames();
        c_all = names.size();
        for (MandelName n : names) {
            boolean b_mod = false;
            boolean b_ras = false;
            boolean b_req = false;
            boolean b_oth = false;
            Set<MandelHandle> handles = scan.getMandelHandles(n);
            for (MandelHandle h : handles) {
                MandelHeader header = h.getHeader();
                if (h.getQualifier() != null) {
                    ++c_var;
                }
                if (header.isModifiableImage()) {
                    b_mod = true;
                    continue;
                }
                if (header.isRaster()) {
                    b_ras = true;
                    continue;
                }
                if (header.isInfo()) {
                    b_req = true;
                    continue;
                }
                b_oth = true;
                System.out.println("" + h.getName() + ": " + header.getType());
            }
            if (b_mod) {
                ++c_mod;
                continue;
            }
            if (b_ras) {
                ++c_ras;
                continue;
            }
            if (b_req) {
                ++c_req;
                continue;
            }
            if (!b_oth) continue;
            ++c_oth;
        }
        this.colormaps = this.set("colormaps", this.colormaps, this.env.getColormapScanner().getColormapNames().size());
        this.all = this.set("areas", this.all, c_all);
        this.available = this.set("available", this.available, c_all - c_req);
        this.modifiableImages = this.set("images", this.modifiableImages, c_mod);
        this.rasters = this.set("rasters", this.rasters, c_ras);
        this.requests = this.set("requests", this.requests, c_req);
        this.variants = this.set("variants", this.variants, c_var);
        this.others = this.set("others", this.others, c_oth);
        this.updateListSizes();
        if (debug) {
            System.out.println("done");
        }
    }

    private void startUpdate() {
        this.changed = false;
    }

    private void finishUpdate() {
        if (this.changed) {
            if (debug) {
                System.out.println("notify changes statistic");
            }
            this.fireChangeEvent();
        }
        this.changed = false;
    }

    private class EnvUpdateHandler
    implements MandelScannerListener,
    MandelListListener {
        private EnvUpdateHandler() {
        }

        @Override
        public void addMandelFile(MandelScanner s, MandelHandle h) {
            this.scannerChanged(s);
        }

        @Override
        public void removeMandelFile(MandelScanner s, MandelHandle h) {
            this.scannerChanged(s);
        }

        @Override
        public void addColormap(MandelScanner s, ColormapHandle h) {
        }

        @Override
        public void removeColormap(MandelScanner s, ColormapHandle h) {
        }

        private void cacheUpdate(String reason) {
            if (debug) {
                System.out.println("statistic update pending (" + reason + ")");
            }
            ImageBaseModel.this.updatePending = true;
        }

        @Override
        public void scannerChanged(MandelScanner s) {
            if (ImageBaseModel.this.env.isInUpdate()) {
                this.cacheUpdate("scanner");
            } else {
                ImageBaseModel.this.startUpdate();
                ImageBaseModel.this.updateData();
                ImageBaseModel.this.finishUpdate();
            }
        }

        @Override
        public void listChanged(ChangeEvent evt) {
            if (ImageBaseModel.this.env.isInUpdate()) {
                this.cacheUpdate("list " + evt.getSource());
            } else {
                ImageBaseModel.this.startUpdate();
                ImageBaseModel.this.updateListSizes();
                ImageBaseModel.this.finishUpdate();
            }
        }
    }
}

