/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelException;
import com.mandelsoft.mand.MandelFileName;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.MandelAreaViewDialog;
import com.mandelsoft.mand.tool.MandelImageAreaDialog;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.util.Utils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.basic.BasicBorders;

public class MandelImageRecalcDialog
extends MandelImageAreaDialog {
    public MandelImageRecalcDialog(MandelWindowAccess owner, String title, QualifiedMandelName name, MandelData data) {
        super(owner, title, owner.getEnvironment().mapToInfoFile(data.getFile()).getPath(), name, MandelImageRecalcDialog.cleanup(new MandelInfo().copyFrom(data.getInfo())), true);
    }

    @Override
    protected MandelAreaViewDialog.MandelAreaView createView(QualifiedMandelName name, Object info, boolean change, boolean readonly) {
        return new RecalcView(name, (MandelInfo)info, readonly);
    }

    protected class RecalcView
    extends MandelImageAreaDialog.View {
        private JButton redobutton;
        private JButton stdredobutton;

        public RecalcView(QualifiedMandelName name, MandelInfo info, boolean readonly) {
            super(name, info, readonly);
            this.filename.setEditable(true);
            this.filename.setBorder(BasicBorders.getTextFieldBorder());
            this.limitfield.setEditable(true);
            this.limitfield.setBorder(BasicBorders.getTextFieldBorder());
        }

        @Override
        protected void setupButtons() {
            this.createButton("Save", null, new SaveAction());
            this.createButton("Delete", null, new DeleteAction());
            super.setupButtons();
            try {
                if (MandelImageRecalcDialog.this.hasMarkRefCoordinates()) {
                    this.redobutton = this.createButton("Request Redo", "Request recalculation based on refrence coordinates of mark", new RedoAction());
                    this.stdredobutton = this.createButton("Request Std Redo", "Request recalculation based on refrence coordinates of mark", new RedoAction("standard-reference-coordinates"));
                }
            }
            catch (MandelException ex) {
                System.out.printf("disable redo button: %s\n", ex.getMessage());
            }
        }

        private class SaveAction
        implements ActionListener {
            private SaveAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Utils.isEmpty(RecalcView.this.filename.getText())) {
                    return;
                }
                MandelInfo info = RecalcView.this.getInfo();
                MandelData md = new MandelData(info);
                File f = new File(RecalcView.this.filename.getText());
                MandelFileName name = MandelFileName.create(f);
                if (name == null) {
                    MandelImageRecalcDialog.this.mandelError(f.getName() + " is no valid mandel area name.");
                    return;
                }
                if (f.exists() && !MandelImageRecalcDialog.this.overwriteFileDialog(f)) {
                    return;
                }
                try {
                    md.write(f);
                    if (name.getQualifiedName().equals(RecalcView.this.qname)) {
                        System.out.println("add to refinement list");
                        MandelImageRecalcDialog.this.getEnvironment().getUnseenRefinements().addRefinement(RecalcView.this.qname);
                    }
                    System.out.println("close refinement");
                    MandelImageRecalcDialog.this.getDialog().setVisible(false);
                }
                catch (IOException ex) {
                    MandelImageRecalcDialog.this.mandelError("Cannot write mandel info file", ex);
                }
            }
        }

        private class DeleteAction
        implements ActionListener {
            private DeleteAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Utils.isEmpty(RecalcView.this.filename.getText())) {
                    return;
                }
                File f = new File(RecalcView.this.filename.getText());
                MandelName name = MandelName.create(f);
                if (name == null) {
                    MandelImageRecalcDialog.this.mandelError(f.getName() + " is no valid mandel area name.");
                    return;
                }
                if (!f.exists()) {
                    MandelImageRecalcDialog.this.mandelError("File does not exist.");
                    return;
                }
                if (!MandelImageRecalcDialog.this.deleteFileDialog(f)) {
                    return;
                }
                f.delete();
                if (f.exists()) {
                    MandelImageRecalcDialog.this.mandelError("Cannot delete " + f + ".");
                    return;
                }
            }
        }

        protected class RedoAction
        implements ActionListener {
            private String attr;

            public RedoAction(String attr) {
                this.attr = attr;
            }

            public RedoAction() {
                this("reference-coordinates");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String ref;
                try {
                    ref = MandelImageRecalcDialog.this.getMarkRefCoordinates();
                }
                catch (MandelException ex) {
                    MandelImageRecalcDialog.this.mandelError(ex);
                    return;
                }
                if (ref == null) {
                    MandelImageRecalcDialog.this.mandelError("no mark set");
                    return;
                }
                MandelInfo redo = new MandelInfo(RecalcView.this.getInfo());
                redo.setProperty("reference-redo", "true");
                redo.setProperty(this.attr, ref);
                RecalcView.this.setInfo(redo);
                RecalcView.this.updateListener.stateChanged(new ChangeEvent(redo));
                RecalcView.this.setFilename(MandelImageRecalcDialog.this.initialFilename);
                RecalcView.this.updateSlave();
            }
        }
    }
}

