/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.tool.MandelDialog;
import com.mandelsoft.mand.tool.MandelListListener;
import com.mandelsoft.mand.tool.MandelListPanel;
import com.mandelsoft.mand.tool.MandelListTableModel;
import com.mandelsoft.mand.tool.MandelNameMapper;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.PictureSaveDialog;
import com.mandelsoft.util.ChangeEvent;
import com.mandelsoft.util.Utils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class MandelListDialog
extends MandelDialog {
    private MandelListPanel panel;
    private String title;
    private MandelListListener listener;

    public MandelListDialog(MandelWindowAccess owner, MandelListTableModel model) {
        super(owner);
        this.setup(model);
    }

    public MandelListDialog(MandelWindowAccess owner, String title, MandelListTableModel model) {
        super(owner, title);
        this.title = title;
        this.setup(model);
        this.panel.setTitle(title);
        this.listener = new MandelListListener(){

            @Override
            public void listChanged(ChangeEvent evt) {
                MandelListDialog.this.updateTitle();
            }
        };
        model.addMandelListListener(this.listener);
        this.updateTitle();
    }

    protected void updateTitle() {
        int c = ((MandelListTableModel)this.panel.getModel()).getRowCount();
        this.setTitle(this.title + " (" + Utils.sizeString(c, "entry") + ")");
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        if (this.listener != null) {
            ((MandelListTableModel)this.panel.getModel()).removeMandelListListener(this.listener);
        }
    }

    protected void setup(MandelListTableModel model) {
        this.panel = new MandelListPanel(null, model, model.isModifiable());
        if (!this.getEnvironment().isReadonly()) {
            this.panel.addButton(new SaveAction());
        }
        this.add(this.panel);
        this.pack();
        this.setVisible(true);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
    }

    public void setMandelNameMapper(MandelNameMapper m) {
        this.panel.setMandelNameMapper(m);
    }

    public void setRootName(MandelName rootName) {
        this.panel.setRootName(rootName);
    }

    public MandelName getRootName() {
        return this.panel.getRootName();
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("Save Images");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PictureSaveDialog d = new PictureSaveDialog(MandelListDialog.this.getMandelWindowAccess(), MandelListDialog.this.getTitle(), ((MandelListTableModel)MandelListDialog.this.panel.getModel()).getList());
            d.setVisible(true);
        }
    }
}

