/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tool.AbstractMandelListModel;
import com.mandelsoft.mand.tool.MandelFolderTransferable;
import com.mandelsoft.mand.tool.MandelListFolderBrowserModel;
import com.mandelsoft.mand.tool.MandelListFolderTreeModel;
import com.mandelsoft.mand.tool.MandelTransferable;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.swing.DnDListModel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeListener;
import javax.swing.DropMode;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class MandelListFolderListModel
extends AbstractMandelListModel<MandelListFolder> {
    private TreeListEventAdapter adapter = new TreeListEventAdapter();
    private MandelListFolderBrowserModel model;
    private MandelScanner scanner;
    private static boolean debug = false;

    public MandelListFolderListModel(MandelListFolderTreeModel model, MandelScanner scanner) {
        this.scanner = scanner;
        this.model = new MandelListFolderBrowserModel(model);
        this.model.addTreeModelListener(this.adapter);
    }

    @Override
    public void refresh(boolean soft) {
        this.getFolderTreeModel().getFolderTree().refresh();
    }

    public MandelListFolderTreeModel getFolderTreeModel() {
        return this.model.getFolderTreeModel();
    }

    public void setModel(MandelListFolderTreeModel model) {
        this.model.setFolderTreeModel(model);
    }

    public void setActiveFolder(MandelListFolder f) {
        this.model.setActiveFolder(f);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.model.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.model.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.model.removePropertyChangeListener(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.model.removeTreeModelListener(l);
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.model.addTreeModelListener(l);
    }

    public String getActivePathName() {
        return this.model.getActivePathName();
    }

    public TreePath getActivePath() {
        return this.model.getActivePath();
    }

    public MandelListFolder getActiveFolder() {
        return this.model.getActiveFolder();
    }

    public static TreePath getParentPath(TreeModelEvent e, TreePath path) {
        return MandelListFolderBrowserModel.getParentPath(e, path);
    }

    @Override
    public boolean isModifiable() {
        return this.model.isPathModifiable(this.getActivePath());
    }

    public void removeFolder(MandelListFolder node) {
        this.model.removeFolder(node);
    }

    public MandelListFolder insertFolder(String name, MandelListFolder parent) {
        return this.model.insertFolder(name, parent);
    }

    @Override
    protected MandelScanner getMandelScanner() {
        return this.scanner;
    }

    @Override
    protected QualifiedMandelName getQualifiedName(MandelListFolder elem) {
        return elem.getThumbnailName();
    }

    @Override
    protected boolean usesThumbnail(QualifiedMandelName name) {
        return this.lookupElement(name) != null;
    }

    @Override
    protected MandelListFolder lookupElement(QualifiedMandelName name) {
        for (MandelListFolder f : this.model.getActiveFolder().allfolders()) {
            QualifiedMandelName n = f.getThumbnailName();
            if (n == null || !n.equals(name)) continue;
            return f;
        }
        return null;
    }

    public Object getElementAt(int index) {
        return this.model.getActiveFolder().get(index);
    }

    @Override
    public int getSize() {
        return this.model.getActiveFolder().size();
    }

    @Override
    public DropMode getDropMode() {
        return DropMode.ON_OR_INSERT;
    }

    @Override
    public int getSourceActions() {
        return 3;
    }

    @Override
    public boolean canImport(DnDListModel.TransferSupport info) {
        TreePath subpath;
        MandelListFolder folder;
        DnDListModel.DropLocation dl = info.getDropLocation();
        boolean insert = dl.isInsert();
        int index = dl.getIndex();
        MandelListFolder mandelListFolder = folder = index < this.getSize() ? (MandelListFolder)this.getElementAt(index) : null;
        if (insert ? !this.isModifiable() : !this.model.isPathModifiable(subpath = this.getActivePath().pathByAddingChild(folder))) {
            return false;
        }
        if (info.isDataFlavorSupported(MandelFolderTransferable.folderFlavor)) {
            MandelFolderTransferable t;
            if (!insert && folder.isLeaf()) {
                return false;
            }
            try {
                t = (MandelFolderTransferable)info.getTransferable().getTransferData(MandelFolderTransferable.folderFlavor);
            }
            catch (Exception e) {
                return false;
            }
            while (folder != null) {
                for (MandelListFolder f : t.getFolders()) {
                    if (f != folder) continue;
                    return false;
                }
                folder = folder.getParent();
            }
            return true;
        }
        if (!insert) {
            if (folder.getMandelList() == null) {
                return false;
            }
            if (info.isDataFlavorSupported(MandelTransferable.mandelFlavor)) {
                return true;
            }
            if (info.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String data = (String)info.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    if (QualifiedMandelName.create(data) != null) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public Transferable createTransferable(DnDListModel.DragLocation loc) {
        int[] indices = loc.getSelectedRows();
        TreePath[] paths = new TreePath[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            paths[i] = this.getActivePath().pathByAddingChild(this.getElementAt(indices[i]));
        }
        int cnt = 0;
        for (int i = 0; i < paths.length; ++i) {
            if (!this.model.isPathTransferable(paths[i])) continue;
            ++cnt;
        }
        if (cnt == 0) {
            return null;
        }
        MandelListFolder[] folders = new MandelListFolder[cnt];
        cnt = 0;
        for (int i = 0; i < paths.length; ++i) {
            if (!this.model.isPathTransferable(paths[i])) continue;
            folders[cnt++] = (MandelListFolder)paths[i].getLastPathComponent();
        }
        return new MandelFolderTransferable(this.model.getFolderTree(), folders);
    }

    @Override
    public boolean importData(DnDListModel.TransferSupport info) {
        MandelListFolder folder;
        DnDListModel.DropLocation dl = info.getDropLocation();
        boolean insert = dl.isInsert();
        int index = dl.getIndex();
        if (insert) {
            folder = this.getActiveFolder();
        } else {
            folder = (MandelListFolder)this.getElementAt(index);
            index = -1;
        }
        boolean done = true;
        Transferable t = info.getTransferable();
        if (info.getDropAction() == 0x40000000) {
            info.setDropAction(1);
        }
        try {
            MandelFolderTransferable trans = (MandelFolderTransferable)t.getTransferData(MandelFolderTransferable.folderFlavor);
            MandelListFolder[] dropfolders = trans.getFolders();
            if (debug) {
                System.out.println("import folder");
            }
            if (trans.getSource() != this.model.getFolderTree() || info.getDropAction() != 2) {
                this.model.insertFolders(index, dropfolders, folder);
            } else {
                this.model.moveFolders(index, dropfolders, folder);
                done = false;
            }
        }
        catch (Exception e) {
            this.check(e);
            try {
                MandelTransferable trans = (MandelTransferable)t.getTransferData(MandelTransferable.mandelFlavor);
                if (trans.getSource() == folder.getMandelList()) {
                    if (debug) {
                        System.out.println("self drop");
                    }
                    return false;
                }
                QualifiedMandelName[] data = trans.getNames();
                if (debug) {
                    System.out.println("import mandel");
                }
                this.model.addAll(folder, data);
            }
            catch (Exception ey) {
                this.check(ey);
                try {
                    QualifiedMandelName mn;
                    String name = (String)t.getTransferData(DataFlavor.stringFlavor);
                    if (debug) {
                        System.out.println("import string");
                    }
                    if ((mn = QualifiedMandelName.create(name)) == null) {
                        return false;
                    }
                    this.model.add(folder, mn);
                }
                catch (Exception ex) {
                    this.check(ex);
                    return false;
                }
            }
        }
        return done;
    }

    private void check(Exception e) {
        if (!(e instanceof UnsupportedFlavorException)) {
            e.printStackTrace(System.out);
        }
    }

    @Override
    public void exportDone(Transferable data, int action) {
        if (debug) {
            System.out.println("action = " + action + "/" + 2);
        }
        MandelFolderTransferable trans = (MandelFolderTransferable)data;
        MandelListFolder[] folders = trans.getFolders();
        if (action == 2 && trans.getSource() != this.model.getFolderTree()) {
            for (int i = folders.length - 1; i >= 0; --i) {
                this.model.removeFolder(folders[i]);
            }
        }
    }

    private class TreeListEventAdapter
    implements TreeModelListener {
        private TreeListEventAdapter() {
        }

        private int getIndex(Object o) {
            int ix = 0;
            for (MandelListFolder f : MandelListFolderListModel.this.model.getActiveFolder().allfolders()) {
                if (f == o) {
                    return ix;
                }
                ++ix;
            }
            return -1;
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            TreePath p = e.getTreePath();
            if (e.getChildren() == null) {
                int ix;
                if (p.getLastPathComponent() == MandelListFolderListModel.this.model.getActiveFolder()) {
                    MandelListFolderListModel.this.fireContentsChanged(MandelListFolderListModel.this, 0, Integer.MAX_VALUE);
                }
                if (p.getPathCount() > 1 && p.getParentPath().getLastPathComponent() == MandelListFolderListModel.this.model.getActiveFolder() && (ix = this.getIndex(e.getTreePath().getLastPathComponent())) >= 0) {
                    MandelListFolderListModel.this.fireContentsChanged(MandelListFolderListModel.this, ix, ix);
                }
            } else if (p.getLastPathComponent() == MandelListFolderListModel.this.model.getActiveFolder()) {
                for (int ix : e.getChildIndices()) {
                    MandelListFolderListModel.this.fireContentsChanged(MandelListFolderListModel.this, ix, ix);
                }
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            TreePath p = e.getTreePath();
            System.out.println("inserted: " + p.getLastPathComponent());
            if (p.getLastPathComponent() == MandelListFolderListModel.this.model.getActiveFolder()) {
                for (int ix : e.getChildIndices()) {
                    MandelListFolderListModel.this.fireIntervalAdded(MandelListFolderListModel.this, ix, ix);
                }
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            TreePath p = e.getTreePath();
            if (p.getLastPathComponent() == MandelListFolderListModel.this.model.getActiveFolder()) {
                for (int ix : e.getChildIndices()) {
                    MandelListFolderListModel.this.fireIntervalRemoved(MandelListFolderListModel.this, ix, ix);
                }
            }
        }
    }
}

