/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.MandelGaleryPanel;
import com.mandelsoft.mand.tool.MandelListListModel;
import com.mandelsoft.mand.tool.MandelListModelSource;
import com.mandelsoft.mand.tool.MandelListSelector;
import com.mandelsoft.mand.tool.MandelNameSelector;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.ctx.MandelListContextMenuHandler;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.swing.DnDJList;
import com.mandelsoft.swing.GaleryPanel;
import com.mandelsoft.swing.Selection;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class MandelListGaleryPanel
extends MandelGaleryPanel<QualifiedMandelName, MandelListListModel>
implements MandelNameSelector,
MandelListSelector,
MandelListModelSource {
    private boolean navToFolder = true;
    private MandelName rootName;
    private GaleryPanel.Ticker ticker = new GaleryPanel.Ticker(this);
    private int last;

    public MandelListGaleryPanel(MandelListListModel model) {
        this(model, 1);
    }

    public MandelListGaleryPanel(MandelListListModel model, int rows, Dimension d) {
        super(model, rows, d);
        this.list.addMouseListener(new Listener());
        this.setContextMenuHandler(new ContextHandler());
    }

    public MandelListGaleryPanel(MandelListListModel model, int rows) {
        this(model, rows, new Dimension(300, 250));
    }

    @Override
    protected void panelUnbound() {
        if (this.ticker != null) {
            this.ticker.stop();
        }
        super.panelUnbound();
    }

    public boolean isNavToFolder() {
        return this.navToFolder;
    }

    public MandelName getRootName() {
        return this.rootName;
    }

    public void setRootName(MandelName rootName) {
        this.rootName = rootName;
    }

    public void setNavToFolder(boolean navToFolder) {
        this.navToFolder = navToFolder;
    }

    @Override
    protected String getLabel(QualifiedMandelName elem) {
        return elem.toString();
    }

    @Override
    public QualifiedMandelName getSelectedMandelName() {
        int index = this.getSelectedIndex();
        return index >= 0 ? ((MandelListListModel)this.getModel()).getQualifiedName(index) : null;
    }

    @Override
    public MandelList getSelectedMandelList() {
        return ((MandelListListModel)this.getModel()).getList();
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    private void requestThumbnail(int index) {
        if (index >= 0 && index < this.list.getModel().getSize()) {
            System.out.println("request index " + index);
            ((MandelListListModel)this.getModel()).requestThumbnail(index, this.getMaxImage());
        }
    }

    @Override
    protected void requestListIndex(int index) {
        if (this.ticker.isRunning() && this.last != index) {
            this.last = index;
            this.requestThumbnail(index);
            this.requestThumbnail(index + 1);
        }
    }

    public void startTicker() {
        if (this.list.getVisibleRowCount() == 1 && this.scrollPane.getHorizontalScrollBar().isVisible()) {
            this.ticker.start();
        }
    }

    public void startTicker(int delay) {
        if (this.list.getVisibleRowCount() == 1 && this.scrollPane.getHorizontalScrollBar().isVisible()) {
            System.out.println("start ticker");
            this.ticker.start(delay);
        } else {
            System.out.println("ticker not possible");
        }
    }

    public void stopTicker() {
        this.ticker.stop();
    }

    private class Listener
    extends MouseAdapter {
        private Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                return;
            }
            QualifiedMandelName sel = (QualifiedMandelName)MandelListGaleryPanel.this.list.getSelectedValue();
            if (sel == null) {
                return;
            }
            MandelListGaleryPanel.this.setBusy(true);
            MandelWindowAccess access = MandelListGaleryPanel.this.getMandelWindowAccess();
            if (access.getMandelImagePane() != null) {
                if (!access.getMandelImagePane().setImage(sel)) {
                    JOptionPane.showMessageDialog(MandelListGaleryPanel.this.getWindow(), "Cannot load image: " + sel, "Mandel IO", 2);
                }
            } else {
                MandelListContextMenuHandler.createMandelImageFrame(MandelListGaleryPanel.this.getWindow(), access, MandelListGaleryPanel.this.getMaxFrame(), sel);
            }
            MandelListGaleryPanel.this.setBusy(false);
        }
    }

    private class ContextHandler
    extends MandelListContextMenuHandler
    implements DnDJList.ContextMenuHandler {
        private Action rootAction = new RootAction();
        private Action tickerStart = new TickerStartAction();
        private Action tickerStop = new TickerStopAction();

        private ContextHandler() {
        }

        @Override
        protected int getMaxFrame() {
            return MandelListGaleryPanel.this.getMaxFrame();
        }

        @Override
        protected JPopupMenu createItemContextMenu(Selection select) {
            JPopupMenu menu = super.createItemContextMenu(select);
            if (MandelListGaleryPanel.this.list.getVisibleRowCount() == 1 && MandelListGaleryPanel.this.scrollPane.getHorizontalScrollBar().isVisible()) {
                if (menu == null) {
                    menu = new JPopupMenu();
                } else {
                    menu.addSeparator();
                }
                JMenuItem it = new JMenuItem(this.tickerStart);
                it.getAction().setEnabled(!MandelListGaleryPanel.this.ticker.isRunning());
                menu.add(it);
                it = new JMenuItem(this.tickerStop);
                it.getAction().setEnabled(MandelListGaleryPanel.this.ticker.isRunning());
                menu.add(it);
            }
            return menu;
        }

        @Override
        protected JPopupMenu createListContextMenu(JPopupMenu menu) {
            menu = super.createListContextMenu(menu);
            if (MandelListGaleryPanel.this.rootName != null) {
                if (menu == null) {
                    menu = new JPopupMenu();
                }
                menu.add(new JMenuItem(this.rootAction));
            }
            return menu;
        }

        private class RootAction
        extends MandelListContextMenuHandler.LoadImageAction {
            public RootAction() {
                super(ContextHandler.this, "Load Root Image");
            }

            @Override
            public QualifiedMandelName getSelectedItem() {
                return new QualifiedMandelName(MandelListGaleryPanel.this.rootName);
            }
        }

        private class TickerStartAction
        extends AbstractAction {
            public TickerStartAction() {
                super("Ticker");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MandelListGaleryPanel.this.startTicker();
            }
        }

        private class TickerStopAction
        extends AbstractAction {
            public TickerStopAction() {
                super("Stop Ticker");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MandelListGaleryPanel.this.stopTicker();
            }
        }
    }
}

