/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelException;
import com.mandelsoft.mand.MandelFileName;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.MandelAreaCreationDialog;
import com.mandelsoft.mand.tool.MandelAreaViewDialog;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.util.MandUtils;
import com.mandelsoft.swing.BufferedComponent;
import com.mandelsoft.swing.ProportionProvider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;

public class MandelVariationCreationDialog
extends MandelAreaCreationDialog {
    public MandelVariationCreationDialog(MandelWindowAccess owner, String title) {
        super(owner, title, null, owner.getMandelName(), MandelVariationCreationDialog.cleanup(owner.getMandelData().getInfo()));
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.handleClose();
        }
    }

    @Override
    protected MandelAreaViewDialog.MandelAreaView createView(QualifiedMandelName name, Object info, boolean change, boolean readonly) {
        System.out.println("mandel frame is " + this.getMandelFrame());
        return new VariationView(name, (MandelInfo)info);
    }

    protected class VariationView
    extends MandelAreaCreationDialog.CreationView
    implements ProportionProvider {
        private JButton namebutton;
        private JButton resetbutton;
        private JButton redobutton;
        private MandelName base;
        private MandelInfo initial;

        public VariationView(QualifiedMandelName name, MandelInfo info) {
            super(name, MandelAreaCreationDialog.cleanup(info));
            this.initial = MandelAreaCreationDialog.cleanup(info);
            this.base = MandelVariationCreationDialog.this.getMandelFrame().getMandelName();
            this.determineFilename();
        }

        @Override
        public double getProportion() {
            MandelInfo info = this.getInfo();
            if (info != null) {
                MandelInfo cur = MandelVariationCreationDialog.this.getMandelWindowAccess().getMandelData().getInfo();
                return MandUtils.getProportion(info.getRX(), info.getRY(), cur);
            }
            return 1.0;
        }

        @Override
        protected void _setRect(BufferedComponent.VisibleRect rect) {
            super._setRect(rect);
            if (rect != null) {
                rect.setProportionProvider(this);
            }
        }

        @Override
        protected void setupButtons() {
            super.setupButtons();
            this.namebutton = this.createButton("Name", "Determine variation name", new NameAction());
            this.addShowButton("Show variation area", false);
            this.resetbutton = this.createButton("Reset", "Reset to initial values", new ResetAction());
            try {
                if (MandelVariationCreationDialog.this.hasMarkRefCoordinates()) {
                    this.redobutton = this.createButton("Request Redo", "Request recalculation based on refrence coordinates of mark", new RedoAction());
                }
            }
            catch (MandelException ex) {
                System.out.printf("disable redo button: %s\n", ex.getMessage());
            }
        }

        @Override
        public void setFilename(String n, boolean modifiable) {
            super.setFilename(n, modifiable);
            this.namebutton.setEnabled(modifiable);
        }

        protected void determineFilename() {
            MandelFileName mfn = new MandelFileName(this.base, this.getInfo().getRX() + "x" + this.getInfo().getRY(), ".md");
            File path = MandelVariationCreationDialog.this.getEnvironment().getInfoFolder(null);
            if (path == null) {
                path = new File(".");
            }
            this.setFilename(new File(path, mfn.toString()).getPath());
        }

        @Override
        protected String getRectLabel() {
            return MandelVariationCreationDialog.this.getTitle();
        }

        private class NameAction
        implements ActionListener {
            private NameAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                VariationView.this.determineFilename();
            }
        }

        private class ResetAction
        implements ActionListener {
            private ResetAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                VariationView.this.setInfo(VariationView.this.initial);
                VariationView.this.updateSlave();
            }
        }

        private class RedoAction
        implements ActionListener {
            private RedoAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String ref;
                try {
                    ref = MandelVariationCreationDialog.this.getMarkRefCoordinates();
                }
                catch (MandelException ex) {
                    MandelVariationCreationDialog.this.mandelError(ex);
                    return;
                }
                if (ref == null) {
                    MandelVariationCreationDialog.this.mandelError("no mark set");
                    return;
                }
                MandelFileName mfn = new MandelFileName(VariationView.this.base, null, ".md");
                File path = MandelVariationCreationDialog.this.getEnvironment().getInfoFolder(null);
                if (path == null) {
                    path = new File(".");
                }
                MandelInfo redo = new MandelInfo(VariationView.this.initial);
                redo.setProperty("reference-redo", "true");
                redo.setProperty("reference-coordinates", ref);
                VariationView.this.setInfo(redo);
                VariationView.this.setFilename(new File(path, mfn.toString()).getPath());
                VariationView.this.updateSlave();
            }
        }
    }
}

