/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.tool.ToolEnvironment;
import com.mandelsoft.swing.GBCPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ToolControlFrame
extends JFrame {
    private ToolEnvironment env;
    private ToolControlPanel panel;

    public ToolControlFrame(ToolEnvironment env) {
        this.env = env;
        this.setTitle("Tool Control Panel");
        this.panel = new ToolControlPanel();
        this.add(this.panel);
        this.pack();
        this.setResizable(false);
    }

    public JFrame getFrame() {
        return this;
    }

    public ToolEnvironment getEnvironment() {
        return this.env;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.panel.update();
    }

    private class ToolControlPanel
    extends GBCPanel {
        private JCheckBox autoRescan;
        private JCheckBox shutdownMode;

        ToolControlPanel() {
            int row = 0;
            String s = ToolControlFrame.this.env.getProperty("sitename");
            if (s == null) {
                s = "";
            }
            this.addTextField(row++, "Site name", s);
            s = ToolControlFrame.this.env.getProperty("username");
            if (s == null) {
                s = "";
            }
            this.addTextField(row++, "Site owner", s);
            this.autoRescan = new JCheckBox((Icon)null, ToolControlFrame.this.env.isAutoRescan());
            this.autoRescan.addChangeListener(new ChangeListener(){
                final /* synthetic */ ToolControlPanel this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (this.this$1.ToolControlFrame.this.env.isAutoRescan() != this.this$1.autoRescan.isSelected()) {
                        System.out.println("auto rescan is " + this.this$1.autoRescan.isSelected());
                        this.this$1.ToolControlFrame.this.env.setAutoRescan(this.this$1.autoRescan.isSelected());
                    }
                }
            });
            this.addField(row++, "Auto rescan", this.autoRescan);
            if (!ToolControlFrame.this.env.isReadonly()) {
                this.shutdownMode = new JCheckBox((Icon)null, ToolControlFrame.this.env.isShutdown());
                this.shutdownMode.addChangeListener(new ChangeListener(){
                    final /* synthetic */ ToolControlPanel this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        System.out.println("shutdown mode is " + this.this$1.shutdownMode.isSelected());
                        this.this$1.ToolControlFrame.this.env.setShutdown(this.this$1.shutdownMode.isSelected());
                        this.this$1.shutdownMode.setSelected(this.this$1.ToolControlFrame.this.env.isShutdown());
                    }
                });
                this.addField(row++, "Shutdown Mode", this.shutdownMode);
            }
            JPanel buttons = new JPanel();
            this.add((Component)buttons, this.GBC(0, row).setSpanW(2));
            JButton b = new JButton("Rescan");
            b.setToolTipText("Rescan the file system");
            b.addActionListener(new RescanAction());
            buttons.add(b);
        }

        private void update() {
            if (this.shutdownMode != null) {
                this.shutdownMode.setSelected(ToolControlFrame.this.env.isShutdown());
            }
        }

        private JTextField addTextField(int row, String name, String value) {
            JTextField tf = new JTextField();
            tf.setEditable(false);
            tf.setColumns(30);
            tf.setHorizontalAlignment(11);
            tf.setText(value);
            this.addField(row, name, tf);
            return tf;
        }

        private void addField(int row, String name, JComponent c) {
            JLabel label = new JLabel(name);
            label.setLabelFor(c);
            label.setHorizontalAlignment(2);
            this.add((Component)label, this.GBC(0, row).setAnchor(17));
            this.add((Component)c, this.GBC(1, row).setLeftInset(10));
        }

        private class RescanAction
        implements ActionListener {
            private RescanAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolControlFrame.this.env.rescan();
            }
        }
    }
}

