/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.Coord;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelRaster;
import com.mandelsoft.mand.util.MandUtils;
import com.mandelsoft.swing.BufferedComponent;
import java.awt.Rectangle;
import java.math.BigDecimal;

public class ToolUtils
extends MandUtils {
    private static final boolean debug = false;
    private static final double D = -0.5;

    public static void updateInfo(MandelInfo info, Rectangle rect, MandelInfo parent, double scale) {
        BigDecimal x = ToolUtils.sub(parent.getXM(), ToolUtils.div(parent.getDX(), 2.0));
        BigDecimal y = ToolUtils.add(parent.getYM(), ToolUtils.div(parent.getDY(), 2.0));
        double rx = rect.getX() + (rect.getWidth() + -0.5) / 2.0;
        double ry = rect.getY() + (rect.getHeight() + -0.5) / 2.0;
        info.setXM(ToolUtils.add(x, ToolUtils.mul(parent.getDX(), rx / (double)parent.getRX() / scale)));
        info.setYM(ToolUtils.sub(y, ToolUtils.mul(parent.getDY(), ry / (double)parent.getRY() / scale)));
        info.setDX(ToolUtils.mul(parent.getDX(), (rect.getWidth() + -0.5) / (double)parent.getRX() / scale));
        info.setDY(ToolUtils.mul(parent.getDY(), (rect.getHeight() + -0.5) / (double)parent.getRY() / scale));
    }

    public static boolean hasRefCoord(MandelData data) {
        MandelInfo info = data.getInfo();
        return ToolUtils.hasRefCoord(data, 0, 0, info.getRX(), info.getRY());
    }

    public static Coord getRefCoord(MandelData data) {
        MandelInfo info = data.getInfo();
        return ToolUtils.getRefCoord(data, 0, 0, info.getRX(), info.getRY());
    }

    public static boolean hasRefCoord(MandelData data, int x0, int y0, int rx, int ry) {
        MandelInfo info = data.getInfo();
        MandelRaster raster = data.getRaster();
        if (raster != null) {
            if (x0 < 0) {
                if ((rx -= x0) <= 0) {
                    return false;
                }
                x0 = 0;
            }
            if (y0 < 0) {
                if ((ry -= y0) <= 0) {
                    return false;
                }
                y0 = 0;
            }
            if (x0 + rx > info.getRX() && (rx -= x0 + rx - info.getRX()) <= 0) {
                return false;
            }
            if (y0 + ry > info.getRY() && (ry -= y0 + ry - info.getRY()) <= 0) {
                return false;
            }
            System.out.printf("available sub range: (%d,%d)[%d,%d]\n", x0, y0, rx, ry);
            for (int y = y0; y < y0 + ry; ++y) {
                for (int x = x0; x < x0 + rx; ++x) {
                    if (raster.getData(x, y) != 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Coord getRefCoord(MandelData data, int x0, int y0, int rx, int ry) {
        MandelInfo info = data.getInfo();
        MandelRaster raster = data.getRaster();
        Coord found = null;
        Coord pixel = null;
        int weight = -1;
        if (raster != null) {
            if (x0 < 0) {
                if ((rx -= x0) <= 0) {
                    return null;
                }
                x0 = 0;
            }
            if (y0 < 0) {
                if ((ry -= y0) <= 0) {
                    return null;
                }
                y0 = 0;
            }
            if (x0 + rx > info.getRX() && (rx -= x0 + rx - info.getRX()) <= 0) {
                return null;
            }
            if (y0 + ry > info.getRY() && (ry -= y0 + ry - info.getRY()) <= 0) {
                return null;
            }
            System.out.printf("available sub range: (%d,%d)[%d,%d]\n", x0, y0, rx, ry);
            for (int y = y0; y < y0 + ry; ++y) {
                int startx = -1;
                int endx = -1;
                for (int x = x0; x < x0 + rx; ++x) {
                    if (raster.getData(x, y) == 0) {
                        int wy;
                        int wx;
                        int w;
                        int cy;
                        if (startx < 0) {
                            startx = x;
                            endx = x0 + rx - 1;
                            for (int cx = x; cx < x0 + rx; ++cx) {
                                if (raster.getData(cx, y) == 0) continue;
                                endx = cx - 1;
                                break;
                            }
                        }
                        if (startx < 0) continue;
                        int starty = 0;
                        int endy = y0 + ry - 1;
                        for (cy = y; cy >= 0; --cy) {
                            if (raster.getData(x, cy) == 0) continue;
                            starty = cy + 1;
                            break;
                        }
                        for (cy = y; cy < y0 + ry; ++cy) {
                            if (raster.getData(x, cy) == 0) continue;
                            endy = cy - 1;
                            break;
                        }
                        if ((w = Math.min(wx = Math.min(x - startx, endx - x), wy = Math.min(y - starty, endy - y))) <= weight) continue;
                        found = new Coord(ToolUtils.add(info.getXMin(), ToolUtils.div(ToolUtils.mul(info.getDX(), x), (double)info.getRX())), ToolUtils.sub(info.getYMax(), ToolUtils.div(ToolUtils.mul(info.getDY(), y), (double)info.getRY())));
                        pixel = new Coord(x, y);
                        weight = w;
                        continue;
                    }
                    startx = -1;
                    endx = -1;
                }
            }
        }
        if (found != null) {
            System.out.printf("ref coord (%d) at %s=%s\n", weight, pixel, found);
        }
        return found;
    }

    public static void updateInfo(MandelInfo info, Rectangle rect, MandelData parent, double scale) {
        ToolUtils.updateInfo(info, rect, parent.getInfo(), scale);
        MandelRaster raster = parent.getRaster();
        if (raster != null) {
            int x0 = (int)(rect.getX() / scale);
            int y0 = (int)(rect.getY() / scale);
            int rx = (int)(rect.getWidth() / scale);
            int ry = (int)(rect.getHeight() / scale);
            System.out.printf("sub range: (%d,%d)[%d,%d]\n", x0, y0, rx, ry);
            Coord ref = ToolUtils.getRefCoord(parent, x0, y0, rx, ry);
            if (ref != null) {
                info.setProperty("reference-coordinates", ref.toString());
            }
        }
    }

    public static void updateRect(MandelInfo info, BufferedComponent.VisibleRect rect, MandelInfo parent, double scale) {
        BigDecimal x = ToolUtils.sub(parent.getXM(), ToolUtils.div(parent.getDX(), 2.0));
        BigDecimal y = ToolUtils.add(parent.getYM(), ToolUtils.div(parent.getDY(), 2.0));
        rect.setSize(ToolUtils.toInt((double)parent.getRX() * scale * ToolUtils.div(info.getDX(), parent.getDX()).doubleValue() - -0.5), ToolUtils.toInt((double)parent.getRY() * scale * ToolUtils.div(info.getDY(), parent.getDY()).doubleValue() - -0.5));
        rect.setLocation(ToolUtils.toInt(ToolUtils.mul(ToolUtils.div(ToolUtils.sub(ToolUtils.sub(info.getXM(), x), ToolUtils.div(info.getDX(), 2.0)), parent.getDX()), (double)parent.getRX() * scale).doubleValue()), ToolUtils.toInt(ToolUtils.mul(ToolUtils.div(ToolUtils.sub(ToolUtils.sub(y, info.getYM()), ToolUtils.div(info.getDY(), 2.0)), parent.getDY()), (double)parent.getRY() * scale).doubleValue()));
    }
}

