/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.cm;

import com.mandelsoft.mand.tool.ColorListModel;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.swing.GBC;
import com.mandelsoft.swing.colorchooser.ColorImageModel;
import com.mandelsoft.swing.colorchooser.HSBChooserPanel;
import com.mandelsoft.swing.colorchooser.ImageChooserPanel;
import com.mandelsoft.swing.colorchooser.RGBChooserPanel;
import com.mandelsoft.swing.colorchooser.SwatchChooserPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.Locale;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorChooser
extends JDialog {
    private boolean preview = false;
    private GBC colorSampleGBC;
    private SampleComponent colorSample;
    private ImageChooserPanel imagePanel;
    private SwatchChooserPanel swatchPanel;
    private JColorChooser cc;
    private ColorListModel colors;
    private ChangeListener changeListener;

    public ColorChooser(Window c) {
        super(c);
        this.setup();
    }

    public ColorChooser() {
        this.setup();
    }

    private void setup() {
        if (this.getOwner() instanceof MandelWindowAccess) {
            this.colors = ((MandelWindowAccess)((Object)this.getOwner())).getEnvironment().getColorsModel();
        }
        this.cc = new JColorChooser();
        if (!this.preview) {
            this.setLayout(new GridBagLayout());
            this.colorSampleGBC = new GBC(0, 0).setInsets(10, 10, 10, 10).setFill(2);
            this.cc.setPreviewPanel(new JPanel());
        }
        this.cc.setLocale(Locale.UK);
        this.cc.getSelectionModel().addChangeListener(new ColorListener());
        AbstractColorChooserPanel[] old = this.cc.getChooserPanels();
        AbstractColorChooserPanel keep = null;
        for (int i = 0; i < old.length; ++i) {
            if (old[i].getClass().getName().equals("javax.swing.colorchooser.DefaultRGBChooserPanel")) {
                keep = old[i];
            }
            this.cc.removeChooserPanel(old[i]);
        }
        this.cc.addChooserPanel(new RGBChooserPanel());
        this.cc.addChooserPanel(new HSBChooserPanel());
        this.swatchPanel = new SwatchChooserPanel(new SwatchChooserPanel.UserColorSource(){

            @Override
            public Color getUserColor(int i) {
                if (ColorChooser.this.colors != null && i < ColorChooser.this.colors.getList().size()) {
                    return (Color)ColorChooser.this.colors.getList().get(i);
                }
                return null;
            }
        });
        this.cc.addChooserPanel(this.swatchPanel);
        this.imagePanel = new ImageChooserPanel();
        this.cc.addChooserPanel(this.imagePanel);
        if (keep != null) {
            this.cc.addChooserPanel(keep);
        }
        if (this.colors != null) {
            this.swatchPanel.addColorListener(new SwatchChooserPanel.UserColorListener(){

                @Override
                public void colorAdded(Color c) {
                    ColorChooser.this.colors.addColor(0, c);
                }

                @Override
                public void colorRemoved(Color c) {
                    ColorChooser.this.colors.removeColor(c);
                }
            });
            this.changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ColorListModel.ListEvent l = (ColorListModel.ListEvent)e;
                    if (l.getMode() == 1) {
                        ColorChooser.this.swatchPanel.addUserColor(l.getColor());
                    } else if (l.getMode() == 1) {
                        ColorChooser.this.swatchPanel.removeUserColor(l.getColor());
                    }
                }
            };
            this.colors.addChangeListener(this.changeListener);
        }
        if (!this.preview) {
            this.add((Component)this.cc, new GBC(0, 1));
        } else {
            this.add(this.cc);
        }
        this.setSampleComponent(new ColorSample(200, 20));
        this.pack();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.colors != null && this.changeListener != null) {
            this.colors.removeChangeListener(this.changeListener);
        }
    }

    public ColorImageModel getColorImageModel() {
        return this.imagePanel.getColorImageModel();
    }

    public void setColorImageModel(ColorImageModel m) {
        this.imagePanel.setColorImageModel(m);
    }

    public void setSampleComponent(SampleComponent sample) {
        if (this.colorSample != null && !this.preview) {
            this.remove(this.colorSample);
        }
        this.colorSample = sample;
        sample.setColor(this.getColor());
        if (this.preview) {
            this.cc.setPreviewPanel(sample);
        } else {
            this.add((Component)this.colorSample, this.colorSampleGBC);
        }
    }

    public SampleComponent getSampleComponent(SampleComponent c) {
        return this.colorSample;
    }

    public void setColor(Color color) {
        this.cc.setColor(color);
    }

    public ColorSelectionModel getSelectionModel() {
        return this.cc.getSelectionModel();
    }

    public Color getColor() {
        return this.cc.getColor();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColorChooser frame = new ColorChooser();
                frame.setVisible(true);
            }
        });
    }

    public static abstract class SampleComponent
    extends JComponent {
        public abstract void setColor(Color var1);
    }

    private class ColorListener
    implements ChangeListener {
        private ColorListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ColorSelectionModel m = (ColorSelectionModel)e.getSource();
            ColorChooser.this.colorSample.setColor(m.getSelectedColor());
        }
    }

    public static class ColorSample
    extends SampleComponent {
        private Color color;
        private int width;
        private int height;

        public ColorSample(int width, int height) {
            this.setBorder(new BevelBorder(0));
            this.setSize(width, height);
            this.setPreferredSize(new Dimension(width, height));
            this.width = width;
            this.height = height;
        }

        @Override
        public void setColor(Color c) {
            this.color = c;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.color);
            Insets o = this.getInsets();
            g.fillRect(o.left, o.top, this.getWidth() - o.left - o.right, this.getHeight() - o.bottom - o.top);
        }
    }
}

