/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.lists;

import com.mandelsoft.mand.tool.lists.AreaColormapListAction;
import com.mandelsoft.mand.tool.lists.AreaMarkerListAction;
import com.mandelsoft.mand.tool.lists.CorruptedListAction;
import com.mandelsoft.mand.tool.lists.DeadEndListAction;
import com.mandelsoft.mand.tool.lists.DirectAreaMarkerListAction;
import com.mandelsoft.mand.tool.lists.DirectForkListAction;
import com.mandelsoft.mand.tool.lists.FavoritesListAction;
import com.mandelsoft.mand.tool.lists.ForkListAction;
import com.mandelsoft.mand.tool.lists.HighResolutionListAction;
import com.mandelsoft.mand.tool.lists.LeafImagesListAction;
import com.mandelsoft.mand.tool.lists.MandelAreaListAction;
import com.mandelsoft.mand.tool.lists.MandelLeafListAction;
import com.mandelsoft.mand.tool.lists.MandelListViewAction;
import com.mandelsoft.mand.tool.lists.ParentListAction;
import com.mandelsoft.mand.tool.lists.PendingWorkListAction;
import com.mandelsoft.mand.tool.lists.RelatedListAction;
import com.mandelsoft.mand.tool.lists.RequestListAction;
import com.mandelsoft.mand.tool.lists.SeenListAction;
import com.mandelsoft.mand.tool.lists.SubAreaListAction;
import com.mandelsoft.mand.tool.lists.TitleListAction;
import com.mandelsoft.mand.tool.lists.TodoListAction;
import com.mandelsoft.mand.tool.lists.UnseenListAction;
import com.mandelsoft.mand.tool.lists.VariantListAction;
import com.mandelsoft.mand.tool.util.MandelContextMenuFactory;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public class MandelListsMenuFactory
extends MandelContextMenuFactory {
    private List<MandelListViewAction> lists = new ArrayList<MandelListViewAction>();
    private boolean readonly;
    private int hires;

    public MandelListsMenuFactory(boolean readonly, int hires) {
        super("Derived Lists");
        this.hires = hires;
        this.readonly = readonly;
        this.setup();
    }

    protected void setup() {
        this.add(new ParentListAction());
        this.add(new RelatedListAction());
        this.add(new FavoritesListAction());
        this.add(new TodoListAction());
        this.add(new SubAreaListAction());
        this.add(new MandelAreaListAction());
        this.add(new LeafImagesListAction());
        this.add(new DeadEndListAction());
        this.add(new PendingWorkListAction());
        this.add(new MandelLeafListAction());
        this.add(new TitleListAction());
        if (!this.readonly) {
            this.add(new UnseenListAction());
            this.add(new SeenListAction());
        }
        this.add(new RequestListAction());
        this.add(new CorruptedListAction());
        this.add(new HighResolutionListAction(this.hires));
        this.add(new VariantListAction());
        this.add(new DirectAreaMarkerListAction());
        this.add(new AreaMarkerListAction());
        this.add(new DirectForkListAction());
        this.add(new ForkListAction());
        this.add(new AreaColormapListAction());
    }

    protected void add(MandelListViewAction action) {
        this.lists.add(action);
    }

    @Override
    protected void addItems(JComponent menu, Component comp, boolean generic) {
        for (MandelListViewAction a : this.lists) {
            JMenuItem it = new JMenuItem(a);
            menu.add(it);
        }
    }
}

