/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.slideshow;

import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.slideshow.DefaultSlideShowSource;
import com.mandelsoft.mand.tool.slideshow.SlideShow;
import com.mandelsoft.mand.tool.slideshow.SlideShowAction;
import com.mandelsoft.mand.tool.slideshow.SlideShowDestination;
import com.mandelsoft.mand.tool.slideshow.SlideShowSource;
import com.mandelsoft.mand.tool.util.MandelContextAction;
import com.mandelsoft.mand.tool.util.MandelContextMenuFactory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class SlideShowModel
extends MandelContextMenuFactory {
    private SlideShowDestination destination;
    private List<SlideShowAction> actions;
    private List<SlideShow> slideshows;
    private Action stop;
    private SlideShow active;

    public SlideShowModel(SlideShowDestination dest) {
        super("Slide Show");
        this.destination = dest;
        this.actions = new ArrayList<SlideShowAction>();
        this.slideshows = new ArrayList<SlideShow>();
        this.stop = new StopAction();
        this.setActive(null);
    }

    public void addSlideShow(SlideShow s) {
        if (!this.slideshows.contains(s)) {
            s.install(this);
            this.slideshows.add(s);
            for (SlideShowAction a : s.getActions()) {
                this.actions.add(a);
                a.setEnabled(this.active == null);
            }
        }
    }

    public SlideShow getActive() {
        return this.active;
    }

    public void setActive(SlideShow s) {
        if (s != null && this.active != null) {
            throw new IllegalStateException(this.active.getId() + " still active");
        }
        this.active = s;
        for (SlideShowAction a : this.actions) {
            a.setEnabled(s == null);
        }
        this.stop.setEnabled(s != null);
    }

    public Action getStopAction() {
        return this.stop;
    }

    public void cancel() {
        for (SlideShow s : this.slideshows) {
            s.cancel();
        }
    }

    public JMenu createMenu(Component comp, SlideShowSource src) {
        MandelSourceMenu menu = new MandelSourceMenu(comp, src);
        this._addItems(menu, comp, true);
        return menu;
    }

    public JPopupMenu createPopupMenu(Component comp, SlideShowSource src) {
        MandelSourcePopupMenu menu = new MandelSourcePopupMenu(comp, src);
        this._addItems(menu, comp, true);
        return menu;
    }

    private static SlideShowSource getSource(JComponent menu, Component comp) {
        SlideShowSource s = MandelContextAction.getEnvironmentObject(menu, SlideShowSource.class);
        if (s == null) {
            s = MandelContextAction.getEnvironmentObject(comp, SlideShowSource.class);
        }
        if (s != null) {
            return s;
        }
        return new DefaultSlideShowSource(menu, comp);
    }

    private int getMode(JComponent menu, Component comp, boolean generic) {
        return SlideShowModel.getSource(menu, comp).getSourceMode(this, generic);
    }

    @Override
    protected void updateItem(JMenuItem item, Component comp) {
        if (item.getAction() instanceof SlideShowAction) {
            SlideShowAction a = (SlideShowAction)item.getAction();
            SlideShowActionMenuItem mi = (SlideShowActionMenuItem)item;
            int mode = this.getMode(item, comp, false);
            if ((a.getMode() & mode) != 0) {
                mi.setPossible(true);
            } else {
                mi.setPossible(false);
            }
        }
    }

    @Override
    protected void addItems(JComponent menu, Component comp, boolean generic) {
        JMenuItem it;
        int mode = this.getMode(menu, comp, generic);
        for (SlideShowAction a : this.actions) {
            if ((a.getMode() & mode) == 0) continue;
            it = new SlideShowActionMenuItem(a);
            menu.add(it);
        }
        it = new JMenuItem(this.stop);
        menu.add(it);
    }

    public SlideShowSource getSource(ActionEvent e) {
        SlideShowSource s = MandelContextAction.getEnvironmentObject(e, SlideShowSource.class);
        if (s != null) {
            return s;
        }
        return new DefaultSlideShowSource(null, (Component)e.getSource());
    }

    public boolean show(QualifiedMandelName name) {
        if (!this.destination.show(name)) {
            JOptionPane.showMessageDialog(this.destination.getWindow(), "Cannot load image: " + name, "Mandel IO", 2);
            return false;
        }
        return true;
    }

    public boolean show(MandelName name) {
        if (!this.destination.show(name)) {
            JOptionPane.showMessageDialog(this.destination.getWindow(), "Cannot load image: " + name, "Mandel IO", 2);
            return false;
        }
        return true;
    }

    public QualifiedMandelName getCurrentQualifiedMandelName() {
        return this.destination.getCurrentQualifiedMandelName();
    }

    public void setHighLight(QualifiedMandelName name) {
        this.destination.setHighLight(name);
    }

    private class StopAction
    extends AbstractAction {
        public StopAction() {
            super("Stop Show");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                SlideShowModel.this.cancel();
            }
        }
    }

    private class MandelSourceMenu
    extends MandelContextMenuFactory.MenuBase
    implements SlideShowSource {
        private SlideShowSource src;

        public MandelSourceMenu(Component comp, SlideShowSource src) {
            super(SlideShowModel.this, comp);
            this.src = src;
        }

        @Override
        public int getSourceMode(SlideShowModel model, boolean generic) {
            return this.src.getSourceMode(model, generic);
        }

        @Override
        public SlideShowSource.TwoMode getTwoMode(SlideShowModel model) {
            return this.src.getTwoMode(model);
        }

        @Override
        public SlideShowSource.OneMode getOneMode(SlideShowModel model) {
            return this.src.getOneMode(model);
        }

        @Override
        public SlideShowSource.ListMode getListMode(SlideShowModel model) {
            return this.src.getListMode(model);
        }
    }

    private class MandelSourcePopupMenu
    extends MandelContextMenuFactory.PopupMenuBase
    implements SlideShowSource {
        private SlideShowSource src;

        public MandelSourcePopupMenu(Component comp, SlideShowSource src) {
            super(SlideShowModel.this, comp);
            this.src = src;
        }

        @Override
        public int getSourceMode(SlideShowModel model, boolean generic) {
            return this.src.getSourceMode(model, generic);
        }

        @Override
        public SlideShowSource.TwoMode getTwoMode(SlideShowModel model) {
            return this.src.getTwoMode(model);
        }

        @Override
        public SlideShowSource.OneMode getOneMode(SlideShowModel model) {
            return this.src.getOneMode(model);
        }

        @Override
        public SlideShowSource.ListMode getListMode(SlideShowModel model) {
            return this.src.getListMode(model);
        }
    }

    private static class SlideShowActionMenuItem
    extends JMenuItem {
        private boolean possible;

        public SlideShowActionMenuItem(Action a) {
            super(a);
            this.possible = a.isEnabled();
        }

        public boolean isPossible() {
            return this.possible;
        }

        public void setPossible(boolean possible) {
            this.possible = possible;
            this.setEnabled(possible & this.getAction().isEnabled());
        }

        @Override
        protected void actionPropertyChanged(Action action, String propertyName) {
            if (propertyName != null && propertyName.equals("enabled") && action.isEnabled()) {
                this.setEnabled(this.isPossible());
                return;
            }
            super.actionPropertyChanged(action, propertyName);
        }
    }
}

