/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.slideshow;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.slideshow.SlideShowModel;
import com.mandelsoft.mand.tool.slideshow.SlideShowSource;
import com.mandelsoft.mand.util.MandelList;

public class SlideShowSourceAdapter
implements SlideShowSource {
    protected SlideShowSource.OneMode oneMode;
    protected SlideShowSource.TwoMode twoMode;
    protected SlideShowSource.ListMode listMode;

    public SlideShowSourceAdapter(SlideShowSource.OneMode o, SlideShowSource.TwoMode t, SlideShowSource.ListMode l) {
        this.oneMode = o;
        this.twoMode = t;
        this.listMode = l;
    }

    public SlideShowSourceAdapter(SlideShowSource.OneMode o, SlideShowSource.TwoMode t) {
        this.oneMode = o;
        this.twoMode = t;
    }

    public SlideShowSourceAdapter(SlideShowSource.ListMode l) {
        this.listMode = l;
    }

    public SlideShowSourceAdapter() {
    }

    @Override
    public int getSourceMode(SlideShowModel model, boolean generic) {
        int mode = 0;
        if (this.supportsListMode(model, generic)) {
            mode |= 4;
        }
        if (this.supportsOneMode(model, generic)) {
            mode |= 1;
        }
        if (this.supportsTwoMode(model, generic)) {
            mode |= 2;
        }
        return mode;
    }

    protected boolean supportsListMode(SlideShowModel model, boolean generic) {
        SlideShowSource.ListMode lm = this.getListMode(model);
        return lm != null && (generic || lm.getMandelList(model) != null);
    }

    protected boolean supportsOneMode(SlideShowModel model, boolean generic) {
        QualifiedMandelName n1;
        SlideShowSource.OneMode om = this.getOneMode(model);
        return om != null && (generic || (n1 = om.getSingleName(model)) != null && !n1.isRoot());
    }

    protected boolean supportsTwoMode(SlideShowModel model, boolean generic) {
        QualifiedMandelName n2;
        QualifiedMandelName n1;
        SlideShowSource.TwoMode tm = this.getTwoMode(model);
        return tm != null && (generic || (n1 = tm.getFirstName(model)) != null && (n2 = tm.getSecondName(model)) != null && !n1.equals(n2));
    }

    @Override
    public SlideShowSource.ListMode getListMode(SlideShowModel model) {
        return this.listMode;
    }

    @Override
    public SlideShowSource.OneMode getOneMode(SlideShowModel model) {
        return this.oneMode;
    }

    @Override
    public SlideShowSource.TwoMode getTwoMode(SlideShowModel model) {
        return this.twoMode;
    }

    public static class ListModeAdapter
    implements SlideShowSource.ListMode {
        @Override
        public MandelList getMandelList(SlideShowModel model) {
            return null;
        }
    }

    public static class TwoModeAdapter
    implements SlideShowSource.TwoMode {
        @Override
        public QualifiedMandelName getFirstName(SlideShowModel model) {
            return null;
        }

        @Override
        public QualifiedMandelName getSecondName(SlideShowModel model) {
            return null;
        }
    }

    public static class OneModeAdapter
    implements SlideShowSource.OneMode {
        @Override
        public QualifiedMandelName getSingleName(SlideShowModel model) {
            return null;
        }
    }
}

