/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.util;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.MandelListSelector;
import com.mandelsoft.mand.tool.MandelNameSelector;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.swing.UpdatableJMenu;
import com.mandelsoft.swing.UpdatableJPopupMenu;
import com.mandelsoft.util.upd.UpdatableObject;
import com.mandelsoft.util.upd.UpdateContext;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class MandelContextMenuFactory {
    private String name;

    public MandelContextMenuFactory(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void updateMenu(JComponent menu, Component comp) {
        Component[] comps = menu instanceof JMenu ? ((JMenu)menu).getMenuComponents() : menu.getComponents();
        for (Component c : comps) {
            if (!(c instanceof JMenuItem)) continue;
            this.updateItem((JMenuItem)c, comp);
        }
    }

    protected void updateItem(JMenuItem item, Component comp) {
    }

    public JPopupMenu createPopupMenu(Component comp, boolean generic) {
        PopupMenuBase menu = new PopupMenuBase(comp);
        this._addItems(menu, comp, generic);
        return menu;
    }

    public JMenu createMenu(Component comp, boolean generic) {
        MenuBase menu = new MenuBase(comp);
        this._addItems(menu, comp, generic);
        return menu;
    }

    public JPopupMenu createPopupMenu(Component comp, QualifiedMandelName name) {
        MandelPopupMenu menu = new MandelPopupMenu(comp, name);
        this._addItems(menu, comp, false);
        return menu;
    }

    public JMenu createMenu(Component comp, QualifiedMandelName name) {
        MandelMenu menu = new MandelMenu(comp, name);
        this._addItems(menu, comp, false);
        return menu;
    }

    public JPopupMenu createPopupMenu(Component comp, MandelNameSelector sel) {
        MandelSelPopupMenu menu = new MandelSelPopupMenu(comp, sel);
        this._addItems(menu, comp, true);
        return menu;
    }

    public JMenu createMenu(Component comp, MandelNameSelector sel) {
        MandelSelMenu menu = new MandelSelMenu(comp, sel);
        this._addItems(menu, comp, true);
        return menu;
    }

    public JPopupMenu createPopupMenu(Component comp, MandelListSelector sel) {
        MandelListSelPopupMenu menu = new MandelListSelPopupMenu(comp, sel);
        this._addItems(menu, comp, true);
        return menu;
    }

    public JMenu createMenu(Component comp, MandelListSelector sel) {
        MandelListSelMenu menu = new MandelListSelMenu(comp, sel);
        this._addItems(menu, comp, true);
        return menu;
    }

    protected void _addItems(JComponent menu, Component comp, boolean generic) {
        this.addItems(menu, comp, generic);
        if (menu instanceof UpdatableObject) {
            ((UpdatableObject)((Object)menu)).updateObject(null);
        }
    }

    protected abstract void addItems(JComponent var1, Component var2, boolean var3);

    protected class PopupMenuBase
    extends UpdatableJPopupMenu {
        private Component comp;

        public PopupMenuBase(Component comp) {
            super(MandelContextMenuFactory.this.getName());
            this.comp = comp;
        }

        @Override
        public void updateObject(UpdateContext ctx) {
            MandelContextMenuFactory.this.updateMenu(this, this.comp);
        }
    }

    protected class MenuBase
    extends UpdatableJMenu {
        private Component comp;

        public MenuBase(Component comp) {
            super(MandelContextMenuFactory.this.getName());
            this.comp = comp;
        }

        @Override
        public void updateObject(UpdateContext ctx) {
            MandelContextMenuFactory.this.updateMenu(this, this.comp);
        }
    }

    private class MandelPopupMenu
    extends PopupMenuBase
    implements MandelNameSelector {
        private QualifiedMandelName selected;

        public MandelPopupMenu(Component comp, QualifiedMandelName name) {
            super(comp);
            this.selected = name;
        }

        @Override
        public QualifiedMandelName getSelectedMandelName() {
            return this.selected;
        }
    }

    private class MandelMenu
    extends MenuBase
    implements MandelNameSelector {
        private QualifiedMandelName selected;

        public MandelMenu(Component comp, QualifiedMandelName name) {
            super(comp);
            this.selected = name;
        }

        @Override
        public QualifiedMandelName getSelectedMandelName() {
            return this.selected;
        }
    }

    private class MandelSelPopupMenu
    extends PopupMenuBase
    implements MandelNameSelector {
        private MandelNameSelector selector;

        public MandelSelPopupMenu(Component comp, MandelNameSelector sel) {
            super(comp);
            this.selector = sel;
        }

        @Override
        public QualifiedMandelName getSelectedMandelName() {
            return this.selector.getSelectedMandelName();
        }
    }

    private class MandelSelMenu
    extends MenuBase
    implements MandelNameSelector {
        private MandelNameSelector selector;

        public MandelSelMenu(Component comp, MandelNameSelector sel) {
            super(comp);
            this.selector = sel;
        }

        @Override
        public QualifiedMandelName getSelectedMandelName() {
            return this.selector.getSelectedMandelName();
        }
    }

    private class MandelListSelPopupMenu
    extends PopupMenuBase
    implements MandelListSelector {
        private MandelListSelector selector;

        public MandelListSelPopupMenu(Component comp, MandelListSelector sel) {
            super(comp);
            this.selector = sel;
        }

        @Override
        public MandelList getSelectedMandelList() {
            return this.selector.getSelectedMandelList();
        }
    }

    private class MandelListSelMenu
    extends MenuBase
    implements MandelListSelector {
        private MandelListSelector selector;

        public MandelListSelMenu(Component comp, MandelListSelector sel) {
            super(comp);
            this.selector = sel;
        }

        @Override
        public MandelList getSelectedMandelList() {
            return this.selector.getSelectedMandelList();
        }
    }
}

