/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tools;

import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerUtils;
import com.mandelsoft.mand.tools.Command;
import com.mandelsoft.mand.util.MandArith;
import com.mandelsoft.mand.util.MandUtils;
import com.mandelsoft.mand.util.Move;
import java.io.File;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;

public class Join
extends MandArith {
    static HashSet<MandelName> ignore = new HashSet();
    static HashSet<MandelName> abort = new HashSet();
    MandelScanner src;
    MandelScanner dst;
    File target;
    HashMap<MandelName, Relocation> moves = new HashMap();
    Move move;
    boolean verbose;

    public Join(MandelScanner src, MandelScanner dst, File target) {
        this.src = src;
        this.dst = dst;
        this.target = target;
        this.move = new Move(src, target, false);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void join() {
        MandelName n = MandelName.ROOT;
        this.handle(n);
    }

    private boolean equals(MandelData sd, MandelData dd) {
        MandelInfo si = sd.getInfo();
        MandelInfo di = dd.getInfo();
        if (si == null || di == null) {
            return false;
        }
        if (this.equals(si, di)) {
            return true;
        }
        MandUtils.round(si);
        MandUtils.round(di);
        return this.equals(si, di);
    }

    private boolean equals(MandelInfo si, MandelInfo di) {
        if (this.diff(si.getXM(), di.getXM(), di.getDX()) > 1.0) {
            return false;
        }
        return !(this.diff(si.getYM(), di.getYM(), di.getDY()) > 1.0);
    }

    private String diff(MandelInfo si, MandelInfo di) {
        double dx = this.diff(si.getXM(), di.getXM(), di.getDX());
        double dy = this.diff(si.getYM(), di.getYM(), di.getDY());
        return dx + "x" + dy;
    }

    private double diff(BigDecimal a, BigDecimal b, BigDecimal p) {
        return Join.mul(Join.div(Join.sub(a, b), p), 100.0).abs().doubleValue();
    }

    private void handle(MandelName s) {
        MandelName next = MandUtils.getNextSubName(s, this.dst, false);
        for (MandelName n = s.sub(); n != null; n = n.next()) {
            MandelData sd = MandelScannerUtils.getMandelInfo(this.src, n);
            MandelData dd = MandelScannerUtils.getMandelInfo(this.dst, n);
            if (sd == null) continue;
            System.out.println("HANDLE " + n);
            if (dd == null) {
                if (n.getSubAreaChar() > next.getSubAreaChar()) {
                    next = n;
                }
                next = this.move(n, next, "new");
                continue;
            }
            if (abort.contains(n)) continue;
            if (!ignore.contains(n) && !this.equals(sd, dd)) {
                next = this.move(n, next, this.diff(sd.getInfo(), dd.getInfo()));
                continue;
            }
            this.handle(n);
        }
    }

    private MandelName move(MandelName s, MandelName d, String reason) {
        System.out.println("*** move " + s + " to " + d);
        this.moves.put(s, new Relocation(s, d, reason));
        if (!this.verbose) {
            this.move.move(s, d);
        }
        return d.next();
    }

    private void print() {
        for (MandelName s : this.moves.keySet()) {
            System.out.println(this.moves.get(s));
        }
    }

    public static void main(String[] args) {
        try {
            Environment src = new Environment(null, new File("F://Mandel2"));
            Environment dst = new Environment(null, new File("F://Mandel"));
            Join j = new Join(src.getMetaScanner(), dst.getMetaScanner(), new File("F://Mandel/merge"));
            j.setVerbose(true);
            j.join();
            j.print();
        }
        catch (IllegalConfigurationException ex) {
            Command.Error("illegal config: " + ex);
        }
    }

    static {
        abort.add(MandelName.create("ba2b9a"));
        abort.add(MandelName.create("2ab6a"));
    }

    public static class Relocation {
        MandelName src;
        MandelName dst;
        String reason;

        public Relocation(MandelName src, MandelName dst, String reason) {
            this.src = src;
            this.dst = dst;
            this.reason = reason;
        }

        public String toString() {
            return "move " + this.src + " to " + this.dst + ": " + this.reason;
        }
    }
}

