/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tools;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.io.FileAbstractFile;
import com.mandelsoft.io.MappedIntMatrix;
import com.mandelsoft.mand.Coord;
import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.MandIter;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelException;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.MandelRaster;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.meth.PixelIterator;
import com.mandelsoft.mand.scan.MandelFolder;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tools.Command;
import com.mandelsoft.mand.util.MandUtils;
import com.mandelsoft.util.IntMatrix;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Mand
extends Command
implements PixelIterator.PropertySource.PropertyHandler {
    public static final String ATTR_REFREDO = "reference-redo";
    public static final double BOUND = 10.0;
    private MandelData old;
    private File mapFile;
    private File file;
    private File save;
    private QualifiedMandelName name;
    private MandelData md;
    private MandelInfo mi;
    private PixelIterator pi;
    private int limit;
    private MandelRaster raster;
    private Filter filter;
    private Environment env;
    private long start;
    private int rx;
    private int ry;
    private int min;
    private int max;
    private long cnt;
    private int mccnt;
    private int mcnt;
    private long ccnt;
    private int kept = 0;
    private int pixelX;
    private int pixelY;
    private Redo redo;
    private boolean refmod;
    private int refdepth;
    private int redolastdepth;
    private int redonumber;
    private boolean aborted;
    private long lastbackup = System.currentTimeMillis();
    private long lastcheck = System.currentTimeMillis();
    private long ready = 0L;
    private static final long TIMEOUT = 1200000L;
    private static final File shutdown = new File("shutdown");

    public Mand(MandelData md, QualifiedMandelName n) {
        this.md = md;
        this.name = n;
        this.mi = md.getInfo();
        this.limit = this.mi.getLimitIt();
    }

    public Mand(MandelData md, QualifiedMandelName n, Environment env) throws IOException {
        this(md, n);
        this.env = env;
        this.file = env.mapToRasterFile(md.getFile());
        this.save = env.mapToIncompleteFile(md.getFile());
    }

    public Mand(File f, Environment env) throws IOException {
        this(new MandelData(f), QualifiedMandelName.create(f), env);
    }

    public Mand(MandelData md, MandelData old, File out, QualifiedMandelName n, Environment env) throws IOException {
        this(md, n, env);
        if (out != null) {
            this.file = out;
        }
        this.setOld(old);
    }

    public final void setMapFile(File file) {
        this.mapFile = file;
    }

    public final void setOld(MandelData old) throws IOException {
        this.old = old;
        if (old != null && old.getFile().isFile()) {
            this.md.setRaster(old.getRaster());
            this.md.setMapper(ColormapModel.ResizeMode.RESIZE_LOCK_COLORS, old.getMapper());
            this.md.getInfo().setSite(old.getInfo().getSite());
            this.md.getInfo().setCreator(old.getInfo().getCreator());
            this.md.getInfo().setLocation(old.getInfo().getLocation());
            this.md.getInfo().setName(old.getInfo().getName());
            this.md.getInfo().setTime(old.getInfo().getTime());
            this.md.getInfo().setProperties(old.getInfo().getProperties());
            if (!old.isIncomplete()) {
                this.file = old.getFile().getFile();
            }
        }
    }

    void prepareMapFile() throws IOException {
        File f = this.mapFile;
        if (f != null) {
            if (!f.exists()) {
                new FileOutputStream(this.mapFile).close();
            }
        } else {
            f = Mand.mapFileName(this.name);
        }
        if (f.exists()) {
            boolean initial;
            boolean bl = initial = f.length() == 0L;
            if (!initial && f.length() != (long)(this.mi.getRX() * this.mi.getRY() * 4)) {
                throw new IOException("invalid size of map file");
            }
            System.out.printf("using map file %s\n", f.getName());
            MappedIntMatrix m = new MappedIntMatrix(f, this.mi.getRX(), this.mi.getRY());
            this.md.setRaster(new MandelRaster(m));
            if (this.old != null && this.old.getRaster() != null && initial) {
                IntMatrix.copy(this.old.getRaster().getRaster(), m);
            }
            this.mapFile = f;
        } else {
            this.mapFile = null;
        }
    }

    void cleanupMapFile() {
        if (this.mapFile != null) {
            this.md.setRaster(null);
            System.gc();
            System.runFinalization();
            System.out.printf("deleting map file %s\n", this.mapFile.getName());
            this.mapFile.delete();
        }
    }

    void setFilter(Filter filter) {
        this.filter = filter;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void check() throws IOException {
        int rx = this.md.getRaster().getRX();
        int ry = this.md.getRaster().getRY();
        MandelData tmp = new MandelData(this.file);
        if (rx != tmp.getRaster().getRX()) {
            throw new MandelException("rx mismatch: " + tmp.getRaster().getRX() + "!=" + rx);
        }
        if (ry != tmp.getRaster().getRY()) {
            throw new MandelException("ry mismatch: " + tmp.getRaster().getRY() + "!=" + ry);
        }
        MandelRaster tmpraster = tmp.getRaster();
        for (int y = 0; y < ry; ++y) {
            for (int x = 0; x < rx; ++x) {
                if (this.raster.getData(x, y) == tmpraster.getData(x, y)) continue;
                throw new MandelException("content mismatch");
            }
        }
    }

    public boolean calculate() throws IOException {
        this.setupContext();
        if (!Mand.filterName(this.filter, this.name, this.pi, this.env)) {
            return false;
        }
        System.out.println(new Date() + ": " + (this.md.getRaster() == null ? "" : "re") + "calculating " + (this.file == null ? "" : this.file) + "... (" + this.name + ")");
        if (this.md.getRaster() != null && this.md.getInfo().getMaxIt() > this.limit) {
            System.out.println("nothing to be done");
            return true;
        }
        this.prepareMapFile();
        this.raster = this.md.createRaster();
        this.start = System.currentTimeMillis();
        PixelIterator.setup(this.pi);
        this.addTime();
        this.start = 0L;
        try {
            this.calc2();
            this.finalizeBlack();
        }
        catch (ShutdownException ex) {
            this.aborted = true;
        }
        finally {
            this.saveContext();
            PixelIterator.cleanup(this.pi);
        }
        return true;
    }

    public Redo createRedo() {
        if (this.mi.hasProperty(ATTR_REFREDO)) {
            try {
                Coord.parse(this.mi.getProperty(ATTR_REFREDO));
                return new Redo(false);
            }
            catch (NumberFormatException ex) {
                System.out.println("complete redo requested");
            }
        }
        return null;
    }

    private void setupContext() {
        this.pi = MandIter.createPixelIterator(this.mi, this);
        this.rx = this.mi.getRX();
        this.ry = this.mi.getRY();
        this.min = this.mi.getMinIt();
        if (this.min == 0) {
            this.min = this.limit;
        }
        this.max = this.mi.getMaxIt();
        this.resetContext();
        this.redo = this.createRedo();
        if (this.redo == null && this.mi.hasProperty("reference-pixel")) {
            System.out.println("remember ref modified");
            this.refmod = true;
        }
        if (this.mi.hasProperty("redo-number")) {
            try {
                this.redonumber = Integer.parseInt(this.mi.getProperty("redo-number"));
                if (this.redonumber > 0) {
                    System.out.printf("redo number %d\n", this.redonumber);
                }
            }
            catch (NumberFormatException ex) {
                this.redonumber = 0;
            }
        }
        if (this.mi.hasProperty("redo-last-depth")) {
            try {
                this.redolastdepth = Integer.parseInt(this.mi.getProperty("redo-last-depth"));
                if (this.redolastdepth > 0) {
                    System.out.printf("last redo depth %d\n", this.redolastdepth);
                }
            }
            catch (NumberFormatException ex) {
                this.redolastdepth = 0;
            }
        }
    }

    private void resetContext() {
        this.cnt = 0L;
        this.ccnt = 0L;
        this.mccnt = 0;
        this.mcnt = 0;
        this.ready = 0L;
        this.refmod = false;
        if (this.mi.hasProperty("reference-pixel")) {
            try {
                Coord p = Coord.parse(this.mi.getProperty("reference-pixel"));
                this.pixelX = p.getX().intValue();
                this.pixelY = p.getY().intValue();
            }
            catch (NumberFormatException ex) {
                this.pixelY = 0;
                this.pixelX = 0;
            }
        }
    }

    private void addTime() {
        if (this.start > 0L) {
            long end = System.currentTimeMillis();
            this.mi.setTime(this.mi.getTime() + (int)((end - this.start) / 1000L));
            this.mi.setRasterCreationTime(end);
            this.start = end;
        }
    }

    private void saveContext() {
        this.addTime();
        this.mi.setMinIt(this.min);
        this.mi.setMaxIt(this.max);
        this.mi.setNumIt(this.cnt);
        this.mi.setMCnt(this.mcnt);
        this.mi.setMCCnt(this.mccnt);
        if (this.redolastdepth > 0) {
            this.mi.setProperty("redo-last-depth", Integer.toString(this.redolastdepth));
        }
        if (this.redonumber > 0) {
            this.mi.setProperty("redo-number", Integer.toString(this.redonumber));
        }
    }

    private void calc1() {
        for (int y = 0; y < this.ry; ++y) {
            this.pi.setY(y);
            for (int x = 0; x < this.rx; ++x) {
                this.pi.setX(x);
                this.handle(x, y);
            }
        }
    }

    private void finalizeBlack() {
        int mcnt = 0;
        for (int y = 0; y < this.ry; ++y) {
            for (int x = 0; x < this.rx; ++x) {
                int it = this.raster.getData(x, y);
                if (it > this.limit) {
                    it = 0;
                    this.raster.setData(x, y, 0);
                }
                if (it != 0) continue;
                ++mcnt;
            }
        }
        System.out.printf(mcnt + " black pixels\n", new Object[0]);
        this.mcnt = mcnt;
    }

    int handle(int x, int y) {
        boolean force;
        int it = this.raster.getData(x, y);
        boolean bl = force = this.redo != null && this.redo.process(x, y);
        if (it == 0 || force) {
            int i;
            if (this.kept > 0) {
                this.kept = 0;
            }
            if (this.start == 0L) {
                this.start = System.currentTimeMillis();
                System.out.printf("start calculation (kept %d points)\n", this.ready);
            }
            ++this.ccnt;
            it = i = this.pi.iter();
            this.raster.setData(x, y, it);
            if (i > this.limit) {
                ++this.mccnt;
                ++this.mcnt;
                --i;
            }
            if (i < this.min) {
                this.min = i;
            }
            if (i > this.max) {
                this.max = i;
            }
        } else {
            ++this.kept;
            if (it > this.limit) {
                ++this.mccnt;
                ++this.mcnt;
            }
        }
        this.cnt += (long)it;
        ++this.ready;
        long cur = System.currentTimeMillis();
        if (cur > this.lastcheck + 600000L) {
            this.lastcheck = cur;
            if (shutdown.exists()) {
                throw new ShutdownException();
            }
        }
        if (cur > this.lastbackup + 1200000L) {
            this.lastbackup = cur;
            if (this.start > 0L) {
                if (this.redo != null) {
                    this.redo.saveContext();
                }
                this.saveContext();
                try {
                    this.write(false, true);
                }
                catch (IOException io) {
                    System.out.println("cannot save intermediate state: " + io);
                }
                this.start = System.currentTimeMillis();
            }
        }
        return it;
    }

    private void calc2() {
        this._calc();
        while (this.refmod) {
            this.mi.setProperty("reference-corrupted", null);
            this.resetContext();
            ++this.redonumber;
            this.redolastdepth = this.refdepth;
            this.redo = new Redo(true);
            this._calc();
            System.out.printf("recalculated %d{%d} pixels\n", this.ccnt, this.ready);
            if (!this.redo.isStarted()) {
                System.out.printf("redo start pixel (%d,%d) not met\n", this.redo.redoX, this.redo.redoY);
            }
            if (this.redo.isActive()) {
                System.out.printf("redo ref pixel (%d,%d) not met\n", this.pixelX, this.pixelY);
            }
            if (this.refmod) {
                if (this.redolastdepth >= this.refdepth) {
                    System.out.printf("redo caused re-ref with lower depth %d <= %d\n", this.refdepth, this.redolastdepth);
                    break;
                }
                System.out.printf("redo caused re-ref with higher depth %d > %d -> repeat redo\n", this.refdepth, this.redolastdepth);
            }
            this.redo.cleanup();
            this.redo = null;
        }
        this.mi.removeProperty("redo-last-depth");
        if (this.redonumber > 0) {
            System.out.printf("required %d redo(s)\n", this.redonumber);
        }
    }

    private void _calc() {
        int u = this.calcHLine(0, 0, this.rx);
        this.calcHLine(0, this.ry - 1, this.rx);
        this.calcVLine(0, 1, this.ry - 2);
        this.calcVLine(this.rx - 1, 1, this.ry - 2);
        this.calcBox(u, 0, 0, this.rx, this.ry);
    }

    private int calcHLine(int sx, int sy, int n) {
        this.pi.setX(sx);
        this.pi.setY(sy);
        int u = this.handle(sx, sy);
        for (int x = sx + 1; x < sx + n; ++x) {
            this.pi.setX(x);
            int it = this.handle(x, sy);
            if (it == u) continue;
            u = -1;
        }
        return u;
    }

    private int calcVLine(int sx, int sy, int n) {
        this.pi.setX(sx);
        this.pi.setY(sy);
        int u = this.handle(sx, sy);
        for (int y = sy + 1; y < sy + n; ++y) {
            this.pi.setY(y);
            int it = this.handle(sx, y);
            if (it == u) continue;
            u = -1;
        }
        return u;
    }

    private void calcBox(int u, int sx, int sy, int nx, int ny) {
        int s;
        if (nx <= 2 || ny <= 2) {
            return;
        }
        boolean done = this.redo == null || this.redo.isStopped();
        block0: for (int y = sy + ny - 1; y >= sy; --y) {
            for (int x = sx + nx - 1; x >= sx; --x) {
                if (this.raster.getData(x, y) != 0) continue;
                done = false;
                continue block0;
            }
        }
        if (done) {
            this.ready += (long)((nx - 2) * (ny - 2));
            return;
        }
        if (u >= 0 && (u = this.checkHLine(u, sx, sy, nx)) >= 0 && (u = this.checkHLine(u, sx, sy + ny - 1, nx)) >= 0 && (u = this.checkVLine(u, sx, sy + 1, ny - 2)) >= 0 && (u = this.checkVLine(u, sx + nx - 1, sy + 1, ny - 2)) >= 0) {
            this.fillBox(sx + 1, sy + 1, nx - 2, ny - 2, u);
            return;
        }
        if (nx > ny) {
            s = (nx - 1) / 2;
            if (s != 0) {
                u = this.calcVLine(sx + s, sy + 1, ny - 2);
                this.calcBox(u, sx, sy, s + 1, ny);
                this.calcBox(u, sx + s, sy, nx - s, ny);
            }
        } else {
            s = (ny - 1) / 2;
            if (s != 0) {
                u = this.calcHLine(sx + 1, sy + s, nx - 2);
                this.calcBox(u, sx, sy, nx, s + 1);
                this.calcBox(u, sx, sy + s, nx, ny - s);
            }
        }
    }

    private int checkHLine(int u, int sx, int sy, int n) {
        if (u >= 0) {
            for (int x = sx; x < sx + n; ++x) {
                if (this.raster.getData(x, sy) == u) continue;
                return -1;
            }
        }
        return u;
    }

    private int checkVLine(int u, int sx, int sy, int n) {
        if (u >= 0) {
            for (int y = sy; y < sy + n; ++y) {
                if (this.raster.getData(sx, y) == u) continue;
                return -1;
            }
        }
        return u;
    }

    private void fillBox(int sx, int sy, int nx, int ny, int u) {
        for (int y = sy; y < sy + ny; ++y) {
            for (int x = sx; x < sx + nx; ++x) {
                this.raster.setData(x, y, u);
            }
        }
        if (u == 0) {
            this.mcnt += nx * ny;
        }
        this.ready += (long)(nx * ny);
    }

    private int iter(double x, double y, double px, double py) {
        double x2 = x * x;
        double y2 = y * y;
        int it = 0;
        while (x2 + y2 < 10.0 && ++it <= this.limit) {
            double xn = x2 - y2 + px;
            double yn = 2.0 * x * y + py;
            x = xn;
            x2 = x * x;
            y = yn;
            y2 = y * y;
        }
        return it;
    }

    @Override
    public void updateProperties(Map<String, String> props) {
        if (props != null) {
            String d = props.get("reference-depth");
            if (d != null) {
                try {
                    this.refdepth = Integer.parseInt(d);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.redo == null || this.redolastdepth < this.refdepth) {
                if (this.redo != null) {
                    System.out.printf("found deeper pixel than current ref (%d > %d) -> skip stop pixel\n", this.refdepth, this.redolastdepth);
                    this.pixelY = 0;
                    this.pixelX = 0;
                }
                for (Map.Entry<String, String> e : props.entrySet()) {
                    this.mi.setProperty(e.getKey(), e.getValue());
                }
                if (props.containsKey("reference-coordinates")) {
                    String point = props.get("reference-pixel");
                    point = point == null ? "" : " " + point;
                    System.out.printf("update attributes for calculation %d{%d}%s\n", this.ccnt, this.ready, point);
                    if (this.ccnt != 0L) {
                        this.refmod = true;
                    }
                    this.mi.setProperty("reference-count", String.format("%d", this.ready + 1L));
                }
            } else {
                this.mi.setProperty("reference-corrupted", "true");
                System.out.println("skip attribute update in redo mode");
            }
        }
    }

    public void write() throws IOException {
        this.write(true);
    }

    public void write(boolean verbose) throws IOException {
        this.write(verbose, this.aborted);
    }

    public void write(boolean verbose, boolean incomplete) throws IOException {
        if (this.file == null) {
            throw new IOException("no file specified");
        }
        this.md.setIncomplete(incomplete);
        if (incomplete) {
            this.write(this.save, verbose);
        } else {
            this.write(this.file, verbose);
            this.save.delete();
        }
    }

    public void write(File f) throws IOException {
        this.write(f, true);
    }

    public void write(File f, boolean verbose) throws IOException {
        String msg;
        double p;
        MandelInfo info = this.md.getInfo();
        this.md.write(f, verbose);
        if (this.redo == null) {
            p = (double)(this.ready * 100L) / (double)info.getRY() / (double)info.getRX();
            msg = "";
        } else {
            p = this.redo.estimate();
            msg = " redo";
        }
        if ((int)p >= 100 || p == 0.0) {
            System.out.println(new Date() + ": " + f + msg + " done: " + (int)p + "% " + MandUtils.time(info.getTime()));
        } else {
            int r = (int)((double)info.getTime() * (100.0 - p) / p);
            System.out.println(new Date() + ": " + f + msg + " done: " + (int)p + "% " + MandUtils.time(info.getTime()) + " estimated: total: " + MandUtils.time(r + info.getTime()) + " => rest: " + MandUtils.time(r));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int c = 0;
        boolean sflag = false;
        boolean cflag = false;
        boolean dflag = false;
        boolean mflag = false;
        Filter filter = new Filter();
        HashSet<File> files = new HashSet<File>();
        while (args.length > c && args[c].charAt(0) == '-') {
            String arg = args[c++];
            block43: for (int i = 1; i < arg.length(); ++i) {
                char opt = arg.charAt(i);
                switch (opt) {
                    case 'o': {
                        MandIter.optimized = true;
                        continue block43;
                    }
                    case 's': {
                        sflag = true;
                        continue block43;
                    }
                    case 'm': {
                        mflag = true;
                        continue block43;
                    }
                    case 'd': {
                        dflag = true;
                        continue block43;
                    }
                    case 'c': {
                        cflag = true;
                        continue block43;
                    }
                    case 'f': {
                        filter.fast = true;
                        continue block43;
                    }
                    case 'v': {
                        filter.variants = true;
                        continue block43;
                    }
                    case 'p': {
                        if (args.length > c) {
                            MandelName mn;
                            if ((mn = MandelName.create(args[c++])) == null) {
                                Mand.Error("illegal mandel name '" + args[c - 1] + "'");
                            }
                            filter.addPrefix(mn);
                            continue block43;
                        }
                        Mand.Error("name prefix missing");
                        continue block43;
                    }
                    case 'l': {
                        if (args.length > c) {
                            try {
                                int t = Integer.parseInt(args[c++]);
                                filter.setLimit(t * 60);
                            }
                            catch (NumberFormatException e) {
                                Mand.Error("invalid time limt");
                            }
                            continue block43;
                        }
                        Mand.Error("name prefix missing");
                        continue block43;
                    }
                    default: {
                        Mand.Error("illegal option '" + opt + "'");
                    }
                }
            }
        }
        while (args.length > c) {
            files.add(new File(args[c++]));
        }
        if (sflag) {
            Mand.service(dflag, mflag, filter);
        } else {
            try {
                Environment env = new Environment(null);
                for (File fi : files) {
                    MandelFolder lock;
                    System.out.printf("handle file %s\n", fi);
                    FileAbstractFile f = new FileAbstractFile(fi);
                    try {
                        lock = MandelFolder.getMandelFolder(f.getFile().getParentFile());
                        if (!lock.lock()) continue;
                        try {
                            if (!f.tryLock()) {
                                continue;
                            }
                        }
                        finally {
                            lock.releaseLock();
                            continue;
                        }
                    }
                    catch (IOException ex) {
                        System.out.printf("error getting locks for %s: %s\n", fi, ex);
                        return;
                    }
                    try {
                        File file;
                        Mand m;
                        System.out.println("got lock for " + f);
                        QualifiedMandelName name = QualifiedMandelName.create(f);
                        MandelData req = new MandelData(f);
                        if (req.getHeader().hasImageData()) {
                            System.out.printf("  found image data\n", new Object[0]);
                            m = new Mand(fi, env);
                        } else {
                            File mm;
                            MandelData incomplete;
                            System.out.printf("  checking old\n", new Object[0]);
                            MandelInfo reqd = req.getInfo();
                            MandelData old = Mand.checkOld(env.getImageDataScanner(), name, reqd, "requested " + reqd.getLimitIt() + " found");
                            File file2 = null;
                            if (old != null) {
                                old.getInfo().removeProperty("reference-pixel");
                                old.getInfo().removeProperty("reference-count");
                                if (reqd.hasProperty(ATTR_REFREDO)) {
                                    System.out.println(f + " redo already existing image");
                                    file2 = old.getFile().getFile();
                                    reqd.setCreationTime(old.getInfo().getCreationTime());
                                    old = null;
                                } else if (old.getInfo().getLimitIt() >= reqd.getLimitIt()) {
                                    System.out.println(f + " skipped");
                                    lock.lock();
                                    try {
                                        f.releaseLock();
                                        if (!dflag) continue;
                                        Mand.cleanupInfo(env, f);
                                        continue;
                                    }
                                    finally {
                                        lock.releaseLock();
                                        continue;
                                    }
                                }
                            }
                            if ((incomplete = Mand.checkOld(env.getIncompleteScanner(), name, reqd, "resuming")) != null) {
                                old = incomplete;
                            }
                            if (mflag && !(mm = Mand.mapFileName(name)).exists()) {
                                new FileOutputStream(mm).close();
                            }
                            m = new Mand(req, old, file2, name, env);
                        }
                        if (!m.calculate()) continue;
                        m.write();
                        if (!m.aborted && (file = Mand.mapFileName(name)).exists()) {
                            System.out.printf("deleting map file %s\n", file.getName());
                            file.delete();
                        }
                        if (!cflag) continue;
                        try {
                            m.check();
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                            Mand.Error("check failed: " + e);
                        }
                    }
                    catch (IOException ex) {
                        Mand.Error("cannot handle " + f + ": " + ex);
                    }
                    finally {
                        try {
                            f.releaseLock();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (IllegalConfigurationException ex) {
                Mand.Error("illegal config: " + ex);
            }
        }
    }

    static boolean filterName(Filter filter, QualifiedMandelName name, PixelIterator pi, Environment env) {
        if (filter != null) {
            MandelInfo parent = null;
            if (env != null) {
                Set<MandelHandle> handles = env.getImageDataScanner().getMandelHandles(name.getMandelName().getParentName());
                System.out.println("found " + handles.size() + " parent handles");
                MandelHandle ph = env.getImageDataScanner().getMandelInfo(name.getMandelName().getParentName());
                if (ph != null) {
                    try {
                        parent = ph.getInfo().getInfo();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (!filter.filter(name, pi, parent)) {
                return false;
            }
        }
        return true;
    }

    static void cleanupInfo(Environment env, AbstractFile f) {
        if (!env.backupInfoFile(f) && env.isCleanupInfo() && f.isFile()) {
            System.out.println("deleting " + f);
            try {
                MandelFolder.Util.delete(f.getFile());
            }
            catch (IOException ex) {
                System.out.println("deletion of " + f + " failed: " + ex);
            }
        }
    }

    static MandelData checkOld(MandelScanner scan, QualifiedMandelName name, MandelInfo reqd, String msg) {
        MandelData old = null;
        Set<MandelHandle> set = scan.getMandelHandles(name);
        if (!set.isEmpty()) {
            for (MandelHandle h : set) {
                if (!h.getHeader().hasRaster()) continue;
                try {
                    MandelData md = h.getData();
                    MandelInfo mi = md.getInfo();
                    if (reqd.getDX().equals(mi.getDX()) && reqd.getDY().equals(mi.getDY()) && reqd.getXM().equals(mi.getXM()) && reqd.getYM().equals(mi.getYM()) && reqd.getRX() == mi.getRX() && reqd.getRY() == mi.getRY()) {
                        System.out.println(msg + " " + h.getFile() + ": " + mi.getLimitIt());
                        old = md;
                        break;
                    }
                    System.out.printf("found: %s\n", h.getFile());
                    Mand.print(mi);
                    System.out.printf("requested:\n", new Object[0]);
                    Mand.print(reqd);
                }
                catch (IOException iOException) {}
            }
        }
        return old;
    }

    public static File mapFileName(QualifiedMandelName name) {
        return new File(name.getName() + ".mm");
    }

    public static void print(MandelInfo info) {
        System.out.printf("rx:      %d\n", info.getRX());
        System.out.printf("ry:      %d\n", info.getRY());
        System.out.printf("limit:   %d\n", info.getLimitIt());
        System.out.printf("dx:      %s\n", info.getDX());
        System.out.printf("dy:      %s\n", info.getDY());
        System.out.printf("xm:      %s\n", info.getXM());
        System.out.printf("ym:      %s\n", info.getYM());
    }

    private static void service(boolean dflag, boolean mflag, Filter filter) {
        try {
            if (filter != null) {
                if (filter.prefix != null) {
                    System.out.println("prefix filter is " + filter.prefix);
                }
                if (filter.variants) {
                    System.out.println("variants filter is on");
                }
                if (filter.fast) {
                    System.out.println("fast filter is on");
                }
                if (filter.limit > 0) {
                    System.out.printf("limit filter is %d minutes\n", filter.limit / 60);
                }
            }
            Service srv = new Service(dflag, mflag, filter);
            srv.service();
        }
        catch (IllegalConfigurationException ex) {
            Command.Error("illegal config: " + ex);
        }
        catch (ShutdownException sd) {
            Command.Warning("calculation service aborted!");
        }
    }

    private static class Filter {
        Set<MandelName> prefix;
        boolean fast;
        boolean variants;
        int limit;

        private Filter() {
        }

        public void addPrefix(MandelName name) {
            if (this.prefix == null) {
                this.prefix = new HashSet<MandelName>();
            }
            this.prefix.add(name);
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        private boolean filterPrefix(MandelName name) {
            if (this.prefix == null) {
                return true;
            }
            for (MandelName p : this.prefix) {
                if (!p.isAbove(name)) continue;
                return true;
            }
            return false;
        }

        public boolean filter(QualifiedMandelName name, PixelIterator pi, MandelInfo parent) {
            if (!this.filterPrefix(name.getMandelName())) {
                return false;
            }
            if (this.variants && name.getQualifier() == null) {
                return false;
            }
            if (this.fast && !pi.isFast()) {
                return false;
            }
            if (this.limit > 0) {
                if (parent == null) {
                    System.out.printf("no parent for %s\n", name);
                    return false;
                }
                System.out.printf("parent %s time %s\n", name.getMandelName().getParentName(), MandUtils.time(parent.getTime()));
                if (this.limit > 0 && parent.getTime() > this.limit) {
                    return false;
                }
            }
            return true;
        }
    }

    public static class ShutdownException
    extends RuntimeException {
    }

    private class Redo {
        private boolean redoStarted = false;
        private boolean redoStopped = false;
        private int redoX = 0;
        private int redoY = 0;
        private long redoCount = 0L;

        public Redo(boolean local) {
            Object c;
            if (Mand.this.mi.hasProperty("reference-count")) {
                c = Mand.this.mi.getProperty("reference-count");
                try {
                    this.redoCount = Long.parseUnsignedLong((String)c) - 1L;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (Mand.this.mi.hasProperty(Mand.ATTR_REFREDO)) {
                try {
                    c = Coord.parse(Mand.this.mi.getProperty(Mand.ATTR_REFREDO));
                    this.redoX = ((Coord)c).getX().intValue();
                    this.redoY = ((Coord)c).getY().intValue();
                    System.out.printf("found last successful redo at (%d,%d) (done %d/%d)\n", this.redoX, this.redoY, Mand.this.ready, this.redoCount);
                }
                catch (NumberFormatException ex) {
                    if (!local) {
                        System.out.printf("start complete redo with first pixel\n", new Object[0]);
                        Mand.this.pixelX = (Mand.this.pixelY = -1);
                        this.redoStarted = true;
                    }
                }
            } else {
                System.out.printf("start redo with first pixel (%d pixels)\n", this.redoCount);
                this.redoStarted = true;
            }
            if (Mand.this.pixelX > 0) {
                System.out.printf("redo will be stopped at ref pixel (%d,%d)\n", Mand.this.pixelX, Mand.this.pixelY);
            }
        }

        public boolean isStarted() {
            return this.redoStarted;
        }

        public boolean isStopped() {
            return this.redoStopped;
        }

        public boolean isActive() {
            return this.redoStarted && !this.redoStopped;
        }

        public boolean process(int x, int y) {
            boolean active = this.isActive();
            if (!this.redoStarted && x == this.redoX && y == this.redoY) {
                System.out.printf("start redo after (%d,%d)\n", x, y);
                this.redoStarted = true;
            }
            if (x == Mand.this.pixelX && y == Mand.this.pixelY) {
                System.out.printf("stop redo at (%d,%d)\n", x, y);
                this.redoStopped = true;
                return false;
            }
            if (active) {
                this.redoX = x;
                this.redoY = y;
            }
            return active;
        }

        public void saveContext() {
            if (this.redoX > 0 || this.redoY > 0) {
                Mand.this.mi.setProperty(Mand.ATTR_REFREDO, new Coord(this.redoX, this.redoY).toString());
            } else {
                this.cleanup();
            }
        }

        public void cleanup() {
            Mand.this.mi.removeProperty(Mand.ATTR_REFREDO);
            Mand.this.mi.removeProperty("reference-count");
        }

        public double estimate() {
            long max = (long)(Mand.this.mi.getRY() * Mand.this.mi.getRX()) + this.redoCount;
            long done = Mand.this.pixelX == 0 && Mand.this.pixelY == 0 ? Mand.this.ready : (long)(Mand.this.mi.getRY() * Mand.this.mi.getRX()) + Mand.this.ready;
            return (double)(done * 100L) / (double)max;
        }
    }

    private static class Service {
        Environment env;
        Set<AbstractFile> ignored;
        MandelScanner imagescan;
        MandelScanner incompletescan;
        MandelScanner infoscan;
        MandelScanner prioscan;
        MandelScanner allscan;
        boolean dflag;
        boolean mflag;
        Filter filter;

        public Service(boolean dflag, boolean mflag, Filter filter) throws IllegalConfigurationException {
            this.dflag = dflag;
            this.mflag = mflag;
            this.filter = filter;
            this.env = new Environment(null);
            this.ignored = new HashSet<AbstractFile>();
            this.imagescan = this.env.getImageDataScanner();
            this.incompletescan = this.env.getIncompleteScanner();
            this.infoscan = this.env.getInfoScanner();
            this.prioscan = this.env.getPrioInfoScanner();
            this.allscan = this.env.getAllScanner();
        }

        public Environment getEnvironment() {
            return this.env;
        }

        public void service() {
            Iterator<MandelHandle> fallback = this.infoscan.getMandelHandles().iterator();
            int found = 0;
            while (true) {
                int prio = 0;
                System.out.println("start loop");
                for (MandelHandle h : this.prioscan.getMandelHandles()) {
                    prio += this.handle(h, false);
                }
                found += prio;
                if (prio == 0) {
                    if (!fallback.hasNext()) {
                        if (found > 0) {
                            System.out.println("" + found + " files processed");
                            found = 0;
                        }
                        System.out.println("rescan standard scanner");
                        if (this.filter.limit > 0) {
                            this.allscan.rescan(true);
                        } else {
                            this.infoscan.rescan(true);
                        }
                        fallback = this.infoscan.getMandelHandles().iterator();
                    }
                    while (fallback.hasNext()) {
                        int f = this.handle(fallback.next(), true);
                        found += f;
                        if (f <= 0) continue;
                        break;
                    }
                }
                if (found == 0) {
                    System.out.println("nothing found");
                    try {
                        Thread.sleep(20000L);
                    }
                    catch (InterruptedException ie) {
                        System.exit(1);
                    }
                }
                System.out.println("rescan prio scanner");
                this.prioscan.rescan(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        int handle(MandelHandle mh, boolean fallback) {
            int found = 0;
            AbstractFile f = mh.getFile();
            QualifiedMandelName name = (QualifiedMandelName)mh.getName();
            if (this.ignored.contains(f)) {
                return found;
            }
            if (name.getLabel() != null) {
                return found;
            }
            if (!f.getFile().exists()) {
                System.out.println("already processed or deleted: " + f);
                return found;
            }
            String n = f.getName();
            try {
                MandelData incomplete;
                MandelData req;
                MandelData old = null;
                File file = null;
                MandelFolder lock = MandelFolder.getMandelFolder(f.getFile().getParentFile());
                if (!lock.lock()) {
                    return found;
                }
                try {
                    if (!f.tryLock()) {
                        int n2 = found;
                        return n2;
                    }
                }
                finally {
                    lock.releaseLock();
                }
                System.out.println("got lock for " + f);
                try {
                    req = new MandelData(f, false);
                }
                catch (IOException io) {
                    f.releaseLock();
                    if (f.getFile().length() != 0L) return found;
                    f.getFile().delete();
                    return found;
                }
                MandelInfo reqd = req.getInfo();
                reqd.removeProperty("redo-number");
                old = Mand.checkOld(this.imagescan, name, reqd, "requested " + reqd.getLimitIt() + " found");
                if (old != null) {
                    if (reqd.hasProperty(Mand.ATTR_REFREDO)) {
                        System.out.println(f + " redo already existing image");
                        file = old.getFile().getFile();
                        old = null;
                    } else if (old.getInfo().getLimitIt() >= reqd.getLimitIt()) {
                        System.out.println(f + " skipped");
                        lock.lock();
                        try {
                            f.releaseLock();
                            if (this.dflag) {
                                Mand.cleanupInfo(this.env, f);
                                return found;
                            }
                            this.ignored.add(f);
                            return found;
                        }
                        finally {
                            lock.releaseLock();
                        }
                    }
                }
                if ((incomplete = Mand.checkOld(this.incompletescan, name, reqd, "resuming")) != null) {
                    old = incomplete;
                }
                Mand m = new Mand(req, old, file, name, this.env);
                m.setFilter(this.filter);
                if (this.mflag) {
                    m.setMapFile(Mand.mapFileName(name));
                }
                if (!m.calculate()) {
                    this.ignored.add(f);
                    f.releaseLock();
                    System.out.println(f + " skipped for filter mode");
                    System.out.println("release lock for " + f);
                    return found;
                }
                ++found;
                m.write(false);
                System.out.println("-------------------");
                lock.lock();
                try {
                    f.releaseLock();
                    System.out.println("release lock for " + f);
                    if (m.isAborted()) throw new ShutdownException();
                    if (f.getName().equals(m.getFile().getName())) return found;
                    Mand.cleanupInfo(this.env, f);
                    return found;
                }
                finally {
                    lock.releaseLock();
                }
            }
            catch (IOException io) {
                System.err.println("*** " + f + ": " + io);
            }
            return found;
        }
    }
}

