/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tools;

import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.tool.Decoration;
import com.mandelsoft.mand.tool.ToolEnvironment;
import com.mandelsoft.mand.tools.Command;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.SplashScreen;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;

public class MandTool
extends Command {
    public static void main(String[] args) {
        try {
            SplashScreen sp = SplashScreen.getSplashScreen();
            if (sp != null) {
                ResourceBundle bundle = ResourceBundle.getBundle("com.mandelsoft.mand.tool.resc.MandTool");
                Graphics2D g = sp.createGraphics();
                Font ofont = g.getFont();
                Font font = Decoration.getAnnotationFont(g);
                Font tfont = font.deriveFont(font.getSize2D() * 1.7f);
                g.setFont(tfont);
                g.setColor(new Color(200, 200, 0));
                g.drawString("Mandelbrot", 240, 170);
                g.drawString("Explorer", 260, 220);
                font = Font.decode("Times New Roman-16");
                g.setFont(font == null ? ofont : font);
                g.setColor(new Color(200, 200, 200));
                g.drawString("Mandtool, Version " + bundle.getString("Application.version"), 300, 360);
                g.drawString("by Uwe Kr\u00fcger, 2009-2025", 40, 360);
                sp.update();
            }
            if (args.length == 0 && System.getenv("MANDEL_HOME") == null && !new File(".mandtool").isFile()) {
                args = new String[]{"http://www.beauty-of-chaos.de/mandel/mandel"};
            }
            ToolEnvironment env = new ToolEnvironment(args);
            env.startup();
        }
        catch (IllegalConfigurationException ex) {
            MandTool.Error("illegal config: " + ex);
        }
    }

    public static void startApplet(String data, URL base) throws MalformedURLException {
        try {
            System.out.println("document base is " + base);
            System.out.println("data source is   " + data);
            if (data == null) {
                data = ".";
            }
            URL dataURL = new URL(base, data);
            ToolEnvironment env = new ToolEnvironment(null, dataURL);
            env.startup();
        }
        catch (IllegalConfigurationException ex) {
            MandTool.Error("illegal config: " + ex);
        }
    }
}

