/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.cm.ColormapSource;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.util.MandelColormapCache;
import com.mandelsoft.mand.util.UpstreamColormapSource;

public class CachedUpstreamColormapSource
extends UpstreamColormapSource {
    private MandelColormapCache cache;

    public CachedUpstreamColormapSource(MandelName n, MandelScanner scanner, ColormapSource defaultSource, MandelColormapCache cache) {
        super(n, scanner, defaultSource);
        this.cache = cache;
    }

    public CachedUpstreamColormapSource(MandelName n, MandelScanner scanner, MandelColormapCache cache) {
        this(n, scanner, null, cache);
    }

    public CachedUpstreamColormapSource(MandelName n, MandelScanner scanner, ColormapSource defaultSource) {
        this(n, scanner, defaultSource, null);
    }

    @Override
    protected Colormap optimizedLoad(MandelHandle h) {
        if (h != null && this.cache != null) {
            Colormap cm = this.cache.get((QualifiedMandelName)h.getName());
            if (cm != null) {
                System.out.println("found cached colormap for " + h.getName());
            }
            return cm;
        }
        return null;
    }

    @Override
    protected void colormapFound(MandelHandle h, Colormap cm) {
        super.colormapFound(h, cm);
        if (this.cache != null) {
            this.cache.add((QualifiedMandelName)h.getName(), cm);
        }
    }
}

