/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.io.FileAbstractFile;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.UniqueDefaultMandelList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileMandelList
extends UniqueDefaultMandelList {
    private AbstractFile file;
    private long lastModified;

    public FileMandelList(File f) {
        this((AbstractFile)new FileAbstractFile(f), false);
    }

    public FileMandelList(AbstractFile f) {
        this(f, false);
    }

    public FileMandelList(AbstractFile f, boolean projectMandelName) {
        super(projectMandelName);
        this.file = f;
        this.refresh(false);
    }

    public FileMandelList(AbstractFile f, MandelList src) {
        this.file = f;
        this.addAll(src);
    }

    @Override
    public boolean valid() {
        if (this.file.isFile()) {
            return this.file.getFile().isFile();
        }
        return this.file.getLastModified() != 0L;
    }

    @Override
    public void refresh(boolean soft) {
        if (!soft) {
            try {
                if (this.file.isFile()) {
                    if (this.file.getLastModified() == this.lastModified) {
                        return;
                    }
                    this.lastModified = this.file.getLastModified();
                }
                this.read(this.file.getInputStream(), this.file.toString());
            }
            catch (IOException ex) {
                System.out.println("cannot read " + this.file + ": " + ex);
            }
        }
    }

    @Override
    public void save() throws IOException {
        if (!this.file.isFile()) {
            throw new UnsupportedOperationException("save on URL");
        }
        this.write(new FileOutputStream(this.file.getFile()), this.file.getPath());
    }
}

