/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.mand.MandelFileName;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.scan.FolderMandelScanner;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;

public class Move {
    private MandelScanner scan;
    private File target;
    private boolean move;
    private boolean verbose;

    public Move(MandelScanner scan, File target, boolean move) {
        this.scan = scan;
        this.target = target;
        this.move = move;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void move(MandelName src, MandelName dst) {
        if (src.isLocalName() || dst.isRemoteName()) {
            throw new IllegalArgumentException("remote name not supported");
        }
        String sp = src.getEffective();
        String dp = dst.getEffective();
        this.handle(sp, dp, src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File src, File dst) {
        byte[] b = new byte[1024];
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(src));){
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dst));){
                int n;
                while ((n = is.read(b)) > 0) {
                    os.write(b, 0, n);
                }
            }
            dst.setLastModified(src.lastModified());
        }
        catch (IOException io) {
            System.out.println("cannot copy " + src + ": " + io);
        }
    }

    private void handle(String sp, String dp, MandelName src) {
        Set<MandelHandle> set = this.scan.getMandelHandles(src);
        if (set.isEmpty()) {
            return;
        }
        String eff = src.getEffective();
        eff = dp + eff.substring(sp.length());
        MandelName dst = MandelName.create(eff);
        for (MandelHandle h : set) {
            if (!h.getFile().isFile()) continue;
            MandelFileName n = MandelFileName.create(h.getFile());
            n = n.get(dst, true);
            System.out.println((this.move ? "move" : "copy") + " " + h.getFile() + " to " + n);
            if (this.verbose) continue;
            if (this.target == null) {
                if (this.move) {
                    h.getFile().getFile().renameTo(new File(h.getFile().getFile().getParentFile(), n.toString()));
                    continue;
                }
                this.copy(h.getFile().getFile(), new File(h.getFile().getFile().getParentFile(), n.toString()));
                continue;
            }
            this.copy(h.getFile().getFile(), new File(this.target, n.toString()));
            if (!this.move) continue;
            h.getFile().getFile().delete();
        }
        for (src = src.sub(); src != null; src = src.next()) {
            this.handle(sp, dp, src);
        }
    }

    public static void main(String[] args) {
        try {
            String src = "F://Mandel2/raster";
            FolderMandelScanner scan = new FolderMandelScanner(new File(src));
            Move m = new Move(scan, new File("."), false);
            m.setVerbose(true);
            m.move(MandelName.create("babc"), MandelName.create("babx"));
        }
        catch (IOException ex) {
            System.out.println("failed; " + ex);
        }
    }
}

