/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.mand.util.ArrayMandelListFolder;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.mand.util.MandelListFolderTree;
import com.mandelsoft.mand.util.UniqueDefaultMandelList;
import java.io.IOException;

public class NestedMandelListFolder
extends ArrayMandelListFolder {
    private MandelListFolderTree tree;

    public NestedMandelListFolder(MandelListFolderTree tree, String name) {
        super(name);
        this.tree = tree;
    }

    @Override
    protected MandelList createMandelList() {
        return new FolderMandelList();
    }

    @Override
    public MandelListFolderTree getMandelListFolderTree() {
        return this.tree;
    }

    @Override
    public void refresh(boolean soft) {
        this.getMandelListFolderTree().refresh();
    }

    @Override
    public void save() throws IOException {
        this.getMandelListFolderTree().save();
    }

    @Override
    public boolean valid() {
        if (this.getParent() != null) {
            return this.getParent().valid();
        }
        return super.valid();
    }

    @Override
    public NestedMandelListFolder createSubFolder(String name) {
        NestedMandelListFolder f = this.createNestedFolder(name);
        super.add(f);
        return f;
    }

    @Override
    public NestedMandelListFolder createSubFolder(int index, String name) {
        NestedMandelListFolder f = this.createNestedFolder(name);
        if (index < 0) {
            index = this.size();
        }
        super.add(index, f);
        return f;
    }

    protected NestedMandelListFolder createNestedFolder(String name) {
        return new NestedMandelListFolder(this.getMandelListFolderTree(), name);
    }

    @Override
    public boolean add(MandelListFolder f) {
        if (!(f instanceof NestedMandelListFolder)) {
            throw new IllegalArgumentException("illegal folder type " + f.getClass());
        }
        return super.add(f);
    }

    @Override
    public void add(int index, MandelListFolder f) {
        if (!(f instanceof NestedMandelListFolder)) {
            throw new IllegalArgumentException("illegal folder type " + f.getClass());
        }
        super.add(index, f);
    }

    private class FolderMandelList
    extends UniqueDefaultMandelList {
        private FolderMandelList() {
        }

        @Override
        public void refresh(boolean soft) {
            NestedMandelListFolder.this.refresh(soft);
        }

        @Override
        public void save() throws IOException {
            NestedMandelListFolder.this.save();
        }

        @Override
        public boolean valid() {
            return NestedMandelListFolder.this.valid();
        }
    }
}

