/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.ColormapHandle;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.ProxyColormapHandleForMandelHandle;
import com.mandelsoft.mand.util.ScannerColormapList;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ScannerMandelColormapList
extends ScannerColormapList {
    public ScannerMandelColormapList(MandelScanner scanner) {
        super(scanner);
    }

    @Override
    protected Set<ColormapName> getColormapNames() {
        HashSet<ColormapName> set = new HashSet<ColormapName>();
        for (MandelHandle h : this.scanner.getMandelHandles()) {
            if (!h.getHeader().hasMandelColormap()) continue;
            set.add(new ColormapName(((QualifiedMandelName)h.getName()).toString()));
        }
        return set;
    }

    @Override
    public ColormapHandle getColormapHandle(ColormapName name) throws IOException {
        MandelHandle h = this.scanner.getMandelHandle(QualifiedMandelName.create(name.getName()));
        if (h == null) {
            return null;
        }
        return new ProxyColormapHandleForMandelHandle(h, name);
    }
}

