/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util.lists;

import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.util.DefaultMandelList;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.UniqueDefaultMandelList;
import com.mandelsoft.mand.util.lists.MandelListFactory;
import java.io.IOException;

public abstract class ScannerBasedMandelListFactory
implements MandelListFactory {
    private MandelScanner scanner;
    private boolean uniqueNames;
    private boolean projectMandelNames;

    protected ScannerBasedMandelListFactory(MandelScanner scanner) {
        this.scanner = scanner;
    }

    protected ScannerBasedMandelListFactory(MandelScanner scanner, boolean uniqueNames, boolean projectMandelNames) {
        this.scanner = scanner;
        this.uniqueNames = uniqueNames;
        this.projectMandelNames = projectMandelNames;
    }

    public MandelScanner getScanner() {
        return this.scanner;
    }

    public void setScanner(MandelScanner scanner) {
        this.scanner = scanner;
    }

    protected void add(MandelList list, QualifiedMandelName name) {
        list.add(name);
    }

    @Override
    public MandelList getList() {
        DefaultMandelList list = this.uniqueNames ? new UniqueDefaultMandelList(this.projectMandelNames) : new DefaultMandelList();
        for (MandelHandle h : this.scanner.getMandelHandles()) {
            if (!this.acceptType(h) || !this.accept(h)) continue;
            this.add(list, (QualifiedMandelName)h.getName());
        }
        return list;
    }

    protected boolean accept(MandelHandle h) {
        return this.accept((QualifiedMandelName)h.getName());
    }

    protected boolean acceptType(MandelHandle h) {
        return this.acceptType((QualifiedMandelName)h.getName());
    }

    protected boolean accept(QualifiedMandelName n) {
        return true;
    }

    protected boolean acceptType(QualifiedMandelName n) {
        return true;
    }

    protected boolean hasMandel(QualifiedMandelName n) {
        MandelHandle h = this.getScanner().getMandelInfo(n);
        if (h != null) {
            try {
                MandelData md = h.getInfo();
                MandelInfo mi = md.getInfo();
                long nm = mi.getMCnt();
                long np = mi.getRX() * mi.getRY();
                if ((double)(nm * 100L) / (double)np > 0.1) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

