/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util.lists;

import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerUtils;
import com.mandelsoft.mand.util.DefaultMandelList;
import com.mandelsoft.mand.util.MandUtils;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.lists.MandelBasenameSource;
import com.mandelsoft.mand.util.lists.ScannerBasedMandelListFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class SubAreaFactory
extends ScannerBasedMandelListFactory
implements MandelBasenameSource {
    protected MandelName basename;
    protected String title;

    public SubAreaFactory(MandelScanner scanner, MandelName basename, String title) {
        this(scanner, basename, title, false, false);
    }

    public SubAreaFactory(MandelScanner scanner, MandelName basename, String title, boolean uniqueNames, boolean projectMandelNames) {
        super(scanner, uniqueNames, projectMandelNames);
        this.basename = basename;
        this.title = title;
    }

    @Override
    public MandelName getBasename() {
        return this.basename;
    }

    public void setBasename(MandelName basename) {
        this.basename = basename;
    }

    @Override
    public String getTitle() {
        return this.title + " for " + this.getBasename();
    }

    @Override
    protected boolean accept(QualifiedMandelName n) {
        return this.getBasename().isAbove(n.getMandelName());
    }

    @Override
    protected boolean acceptType(QualifiedMandelName n) {
        return MandelScannerUtils.hasImageData(this.getScanner().getMandelHandles(n));
    }

    protected boolean accept(QualifiedMandelName name, Set<MandelName> subareas) {
        return false;
    }

    protected boolean acceptTree(QualifiedMandelName name) {
        return true;
    }

    protected MandelList filterTree() {
        DefaultMandelList list = new DefaultMandelList();
        ArrayList<QualifiedMandelName> dive = new ArrayList<QualifiedMandelName>();
        ArrayList<QualifiedMandelName> next = new ArrayList<QualifiedMandelName>();
        HashSet<MandelName> done = new HashSet<MandelName>();
        dive.add(new QualifiedMandelName(this.getBasename()));
        boolean check = false;
        while (!dive.isEmpty()) {
            for (QualifiedMandelName name : dive) {
                if (!this.acceptTree(name)) continue;
                Set<MandelName> set = MandUtils.getSubNames(name.getMandelName(), this.getScanner());
                if (check && this.accept(name, set)) {
                    this.add(list, name);
                    continue;
                }
                if (done.contains(name.getMandelName())) continue;
                done.add(name.getMandelName());
                for (MandelName mn : set) {
                    next.addAll(this.getScanner().getQualifiedMandelNames(mn));
                }
            }
            ArrayList<QualifiedMandelName> tmp = dive;
            dive = next;
            next = tmp;
            tmp.clear();
            check = true;
        }
        return list;
    }
}

