/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Transparency;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import javax.imageio.ImageIO;

public class AttributedImage
implements WritableRenderedImage,
Transparency {
    BufferedImage image;
    Properties props;

    public AttributedImage(BufferedImage image) {
        this.image = image;
        this.props = new Properties();
    }

    private boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            return ((String)o).equals("");
        }
        return false;
    }

    public synchronized Object setProperty(String key, String value) {
        String[] names = this.image.getPropertyNames();
        if (names != null) {
            for (String p : names) {
                if (!p.equals(key)) continue;
                throw new IllegalArgumentException("property " + key + " cannot be overwritten");
            }
        }
        return this.props.setProperty(key, value);
    }

    @Override
    public String[] getPropertyNames() {
        ArrayList<Object> r = new ArrayList<Object>();
        String[] names = this.image.getPropertyNames();
        if (names != null) {
            for (String p : names) {
                r.add(p);
            }
        }
        for (String p : this.props.stringPropertyNames()) {
            if (r.contains(p)) continue;
            r.add(p);
        }
        return r.toArray(new String[r.size()]);
    }

    @Override
    public Object getProperty(String name) {
        String v = this.props.getProperty(name);
        if (v != null) {
            return v;
        }
        return this.image.getProperty(name);
    }

    public Object getProperty(String name, ImageObserver observer) {
        Object o = this.image.getProperty(name, observer);
        if (o != null) {
            return o;
        }
        return this.props.getProperty(name);
    }

    public String toString() {
        return this.image.toString();
    }

    public void setRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        this.image.setRGB(startX, startY, w, h, rgbArray, offset, scansize);
    }

    public synchronized void setRGB(int x, int y, int rgb) {
        this.image.setRGB(x, y, rgb);
    }

    @Override
    public void setData(Raster r) {
        this.image.setData(r);
    }

    @Override
    public void removeTileObserver(TileObserver to) {
        this.image.removeTileObserver(to);
    }

    @Override
    public void releaseWritableTile(int tileX, int tileY) {
        this.image.releaseWritableTile(tileX, tileY);
    }

    @Override
    public boolean isTileWritable(int tileX, int tileY) {
        return this.image.isTileWritable(tileX, tileY);
    }

    public boolean isAlphaPremultiplied() {
        return this.image.isAlphaPremultiplied();
    }

    @Override
    public boolean hasTileWriters() {
        return this.image.hasTileWriters();
    }

    @Override
    public Point[] getWritableTileIndices() {
        return this.image.getWritableTileIndices();
    }

    @Override
    public WritableRaster getWritableTile(int tileX, int tileY) {
        return this.image.getWritableTile(tileX, tileY);
    }

    public int getWidth(ImageObserver observer) {
        return this.image.getWidth(observer);
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    public int getType() {
        return this.image.getType();
    }

    @Override
    public int getTransparency() {
        return this.image.getTransparency();
    }

    @Override
    public int getTileWidth() {
        return this.image.getTileWidth();
    }

    @Override
    public int getTileHeight() {
        return this.image.getTileHeight();
    }

    @Override
    public int getTileGridYOffset() {
        return this.image.getTileGridYOffset();
    }

    @Override
    public int getTileGridXOffset() {
        return this.image.getTileGridXOffset();
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        return this.image.getTile(tileX, tileY);
    }

    public BufferedImage getSubimage(int x, int y, int w, int h) {
        return this.image.getSubimage(x, y, w, h);
    }

    @Override
    public Vector<RenderedImage> getSources() {
        return this.image.getSources();
    }

    public ImageProducer getSource() {
        return this.image.getSource();
    }

    @Override
    public SampleModel getSampleModel() {
        return this.image.getSampleModel();
    }

    public WritableRaster getRaster() {
        return this.image.getRaster();
    }

    public int[] getRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        return this.image.getRGB(startX, startY, w, h, rgbArray, offset, scansize);
    }

    public int getRGB(int x, int y) {
        return this.image.getRGB(x, y);
    }

    @Override
    public int getNumYTiles() {
        return this.image.getNumYTiles();
    }

    @Override
    public int getNumXTiles() {
        return this.image.getNumXTiles();
    }

    @Override
    public int getMinY() {
        return this.image.getMinY();
    }

    @Override
    public int getMinX() {
        return this.image.getMinX();
    }

    @Override
    public int getMinTileY() {
        return this.image.getMinTileY();
    }

    @Override
    public int getMinTileX() {
        return this.image.getMinTileX();
    }

    public int getHeight(ImageObserver observer) {
        return this.image.getHeight(observer);
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    public Graphics getGraphics() {
        return this.image.getGraphics();
    }

    @Override
    public Raster getData(Rectangle rect) {
        return this.image.getData(rect);
    }

    @Override
    public Raster getData() {
        return this.image.getData();
    }

    @Override
    public ColorModel getColorModel() {
        return this.image.getColorModel();
    }

    public WritableRaster getAlphaRaster() {
        return this.image.getAlphaRaster();
    }

    public Graphics2D createGraphics() {
        return this.image.createGraphics();
    }

    @Override
    public WritableRaster copyData(WritableRaster outRaster) {
        return this.image.copyData(outRaster);
    }

    public void coerceData(boolean isAlphaPremultiplied) {
        this.image.coerceData(isAlphaPremultiplied);
    }

    @Override
    public void addTileObserver(TileObserver to) {
        this.image.addTileObserver(to);
    }

    static void print(WritableRenderedImage img) {
        String[] names = img.getPropertyNames();
        if (names != null) {
            for (String p : names) {
                System.out.println("  " + p + ": " + img.getProperty(p));
            }
        }
    }

    public static void main(String[] args) {
        String suffix = null;
        if (args.length > 0) {
            try {
                int ix = args[0].lastIndexOf(46);
                if (ix > 0) {
                    suffix = args[0].substring(ix + 1);
                }
                System.out.println("handling " + args[0]);
                BufferedImage image = ImageIO.read(new File(args[0]));
                System.out.println("FOUND:");
                AttributedImage.print(image);
                AttributedImage attr = new AttributedImage(image);
                attr.setProperty("Test", "Dies ist ein Test.");
                System.out.println("MOD:");
                AttributedImage.print(attr);
                String target = args.length > 1 ? args[1] : args[0];
                ix = target.lastIndexOf(46);
                if (suffix == null) {
                    suffix = "png";
                }
                if (ix > 0) {
                    suffix = target.substring(ix + 1);
                } else {
                    target = target + "." + suffix;
                }
                try {
                    if (!ImageIO.write((RenderedImage)attr, suffix, new File(target))) {
                        System.out.println("not written");
                    }
                }
                catch (IOException io) {
                    System.out.println("cannot write " + target + ": " + io);
                }
            }
            catch (IOException ex) {
                System.out.println("cannot read " + args[0] + ": " + ex);
            }
        }
    }
}

