/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.mand.tool.Decoration;
import com.mandelsoft.mand.tool.DynamicColor;
import com.mandelsoft.swing.BooleanAttribute;
import com.mandelsoft.swing.Corner;
import com.mandelsoft.swing.ProportionProvider;
import com.mandelsoft.swing.RectanglePoint;
import com.mandelsoft.swing.Scale;
import com.mandelsoft.swing.ScaleEvent;
import com.mandelsoft.swing.ScaleEventListener;
import com.mandelsoft.swing.Side;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;

public class BufferedComponent
extends JComponent
implements ProportionProvider,
DynamicColor.ImageSource {
    public static final int TEXT_INSETS = 2;
    public static final int SELECT_INSETS = 1;
    public static final int CORNER_RECT = 20;
    public static final double RECTW = 1.0;
    public static final double RECTH = 1.0;
    public static boolean debug = false;
    public static final int SCALEX = 1;
    public static final int SCALEY = 2;
    private BufferedImage image;
    private int scalemode;
    private Rectangle fullviewrect;
    private Graphics2D drawer;
    private boolean limitWindowSize = false;
    private ContentPane content;
    private List<PaintHandler> painthandlers = new ArrayList<PaintHandler>();
    private ToolTipHandler tooltiphandler;
    private Set<VisibleRect> rects = new HashSet<VisibleRect>();
    private MouseHandler mousehandler;
    private Point adjust;
    private BooleanAttribute selectinvisible;
    private BooleanAttribute showdecoration;
    private BooleanAttribute pixeltooltip;
    private boolean limitPending;
    private Decoration.ColorHandler colorHandler;
    private volatile int id_cnt = 0;
    private List<RectEventListener> listeners = new ArrayList<RectEventListener>();
    private List<RectPointEventListener> clisteners = new ArrayList<RectPointEventListener>();
    private Map<RectanglePoint, List<ActionListener>> points = new HashMap<RectanglePoint, List<ActionListener>>();
    private Set<RectModifiedEventListener> mlisteners = new HashSet<RectModifiedEventListener>();
    private Scale scale = Scale.One;
    private RectangleSelector selector = null;
    private Insets insets = new Insets(0, 0, 0, 0);
    private Set<ScaleEventListener> slisteners = new HashSet<ScaleEventListener>();

    public static int toInt(double d) {
        return (int)Math.round(d);
    }

    public static int toInt(long l) {
        return (int)l;
    }

    public BufferedComponent() {
        this(1, 1);
    }

    public BufferedComponent(int width, int height) {
        this(new BufferedImage(width, height, 1));
    }

    public BufferedComponent(BufferedImage image) {
        this.colorHandler = new DynamicColor(this);
        this.setupLocalModels();
        this.setLayout(new BorderLayout());
        this.content = new ContentPane();
        this.content.setDoubleBuffered(false);
        this.content.setAutoscrolls(true);
        this.add(this.content);
        this.setupImage(image);
        this.mousehandler = new MouseHandler();
        this.setInheritsPopupMenu(true);
        this.setDoubleBuffered(false);
        this.setAutoscrolls(true);
        this.content.addMouseListener(this.mousehandler);
        this.content.addMouseMotionListener(this.mousehandler);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JViewport vp = BufferedComponent.this.getViewPort();
                if (vp != null) {
                    if (BufferedComponent.this.adjust != null) {
                        vp.setViewPosition(BufferedComponent.this.adjust);
                    }
                    BufferedComponent.this.adjust = null;
                }
                ((BufferedComponent)e.getSource()).limitWindowSize();
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("border")) {
                    BufferedComponent.this.updatePreferredSize();
                }
            }
        });
    }

    private void setupLocalModels() {
        this.selectinvisible = new BooleanAttribute(this, "selectinvisible");
        this.showdecoration = new BooleanAttribute(this, "showdecoration"){

            @Override
            protected void stateChanged() {
                HashSet<VisibleRect> set = new HashSet<VisibleRect>();
                for (VisibleRect r : BufferedComponent.this.rects) {
                    if (r.isVisible()) {
                        set.add(r);
                    }
                    r.setVisible(false);
                }
                this.setState();
                for (VisibleRect r : set) {
                    r.setVisible(true);
                }
            }
        };
        this.showdecoration.setState(true);
        this.pixeltooltip = new BooleanAttribute(this, "pixeltooltip"){

            @Override
            protected void stateChanged() {
                if (BufferedComponent.this.tooltiphandler != null) {
                    if (this.isSelected()) {
                        ToolTipManager.sharedInstance().registerComponent(BufferedComponent.this.content);
                    } else {
                        ToolTipManager.sharedInstance().unregisterComponent(BufferedComponent.this.content);
                    }
                }
            }
        };
    }

    public Decoration.ColorHandler getColorHandler() {
        return this.colorHandler;
    }

    public BooleanAttribute getDecorationModel() {
        return this.showdecoration;
    }

    public BooleanAttribute getSelectInvisibleModel() {
        return this.selectinvisible;
    }

    public BooleanAttribute getPixelToolTipModel() {
        return this.pixeltooltip;
    }

    public void setToolTipHandler(ToolTipHandler h) {
        ToolTipHandler old = this.tooltiphandler;
        this.tooltiphandler = h;
        if (h == null != (old == null)) {
            if (h == null) {
                ToolTipManager.sharedInstance().unregisterComponent(this.content);
            } else if (this.pixeltooltip.isSet()) {
                ToolTipManager.sharedInstance().registerComponent(this.content);
            }
        }
    }

    public void addPaintHandler(PaintHandler h) {
        this.painthandlers.add(h);
    }

    public void removePaintHandler(PaintHandler h) {
        this.painthandlers.remove(h);
    }

    public void updatePreferredSize() {
        Insets o = this.getInsets();
        Dimension d = new Dimension(BufferedComponent.toInt((double)this.image.getWidth() * this.scale.getX()) + o.left + o.right, BufferedComponent.toInt((double)this.image.getHeight() * this.scale.getY()) + o.top + o.bottom);
        if (debug) {
            System.out.println("update size: image " + (double)this.image.getWidth() * this.scale.getX() + "," + (double)this.image.getHeight() * this.scale.getY() + " " + o);
        }
        this.setPreferredSize(d);
        this.setMaximumSize(d);
    }

    private boolean isAdjusting() {
        return this.adjust != null;
    }

    private void setupImage(BufferedImage image) {
        this.image = image;
        this.fullviewrect = new Rectangle(0, 0, BufferedComponent.toInt((double)image.getWidth() / this.scale.getX()), BufferedComponent.toInt((double)image.getHeight() / this.scale.getY()));
        this.drawer = null;
        this.updatePreferredSize();
    }

    public void setImage(BufferedImage image) {
        BufferedImage old = this.image;
        this.discardAllRects();
        this.setupImage(image);
        if (old == null || image.getWidth() != old.getWidth() || image.getHeight() != old.getHeight()) {
            this.revalidate();
            this.limitWindowSize();
        }
        this.repaint();
    }

    public void setScaleMode(int m) {
        if (this.scalemode != m) {
            int old = this.scalemode;
            if (m == 0 != (this.scalemode == 0)) {
                if (m != 0) {
                    this.content.addMouseWheelListener(this.mousehandler);
                } else {
                    this.content.removeMouseWheelListener(this.mousehandler);
                }
            }
            this.scalemode = m;
            this.firePropertyChange("scalemode", old, this.scalemode);
        }
    }

    public void setScaleMode(boolean b) {
        this.setScaleMode(b ? 3 : 0);
    }

    public JComponent getContentPane() {
        return this.content;
    }

    public void setLimitWindowSize(boolean b) {
        if (this.limitWindowSize != b) {
            this.limitWindowSize = b;
            if (b) {
                this.limitWindowSize();
            }
            this.firePropertyChange("limitwindowsize", !this.limitWindowSize, this.limitWindowSize);
        }
    }

    public boolean isLimitWindowSize() {
        return this.limitWindowSize;
    }

    public boolean isShowDecoration() {
        return this.showdecoration.isSet();
    }

    public void setShowDecoration(boolean showdecoration) {
        this.showdecoration.setState(showdecoration);
    }

    public Graphics2D createGraphics() {
        return this.image.createGraphics();
    }

    private boolean limitWindowSize() {
        int w = 0;
        int h = 0;
        if (!this.limitWindowSize) {
            return false;
        }
        boolean limit = false;
        FrameInfo info = new FrameInfo();
        info.setup(this.getParent());
        int dw = info.insets.left + info.insets.right;
        int dh = info.insets.top + info.insets.bottom;
        Dimension max = this.getMaximumSize();
        if (info.root == null) {
            return false;
        }
        if ((double)(info.root.getWidth() - dw) > max.getWidth()) {
            w = BufferedComponent.toInt(max.getWidth() + (double)dw);
            h = info.root.getHeight();
            limit = true;
        }
        if ((double)(info.root.getHeight() - dh) > max.getHeight()) {
            h = BufferedComponent.toInt(max.getHeight() + (double)dh);
            if (w == 0) {
                w = info.root.getWidth();
            }
            limit = true;
        }
        if (limit) {
            this.limitPending = true;
            info.root.setSize(w, h);
        }
        return limit;
    }

    @Override
    public double getProportion() {
        double p = (double)this.image.getWidth() / (double)this.image.getHeight();
        return p;
    }

    @Override
    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public Scale getScale() {
        return this.scale;
    }

    private Graphics2D getDrawer() {
        if (this.drawer == null) {
            this.drawer = this.content.createGraphics();
            this.drawer.setColor(Color.BLACK);
            this.drawer.setXORMode(Color.WHITE);
            this.drawer.setFont(this.drawer.getFont().deriveFont(1));
        }
        return this.drawer;
    }

    public VisibleRect createRect(String name) {
        return new VisibleRect(name);
    }

    public VisibleRect createRect(String name, String label) {
        return new VisibleRect(name, label);
    }

    public VisibleRect createRect(String name, int x, int y, int w, int h) {
        return new VisibleRect(name, x, y, w, h);
    }

    public VisibleRect createRect(String name, String label, int x, int y, int w, int h) {
        return new VisibleRect(name, label, x, y, w, h);
    }

    public VisibleRect createRect(String name, Rectangle r) {
        return new VisibleRect(name, r);
    }

    public VisibleRect createRect(String name, String label, Rectangle r) {
        return new VisibleRect(name, label, r);
    }

    public VisibleRect createRect(String name, Object o) {
        return this.createRect(name, name).setOwner(o);
    }

    public VisibleRect createRect(String name, String label, Object o) {
        return this.createRect(name, label).setOwner(o);
    }

    public VisibleRect createRect(String name, Object o, int x, int y, int w, int h) {
        return this.createRect(name, x, y, w, h).setOwner(o);
    }

    public VisibleRect createRect(String name, String label, Object o, int x, int y, int w, int h) {
        return this.createRect(name, label, x, y, w, h).setOwner(o);
    }

    public VisibleRect createRect(String name, Object o, Rectangle r) {
        return this.createRect(name, r).setOwner(o);
    }

    public VisibleRect createRect(String name, String label, Object o, Rectangle r) {
        return this.createRect(name, label, r).setOwner(o);
    }

    public void setSelectInvisible(boolean b) {
        this.selectinvisible.setState(b);
    }

    public void showAllRects() {
        for (VisibleRect r : this.rects) {
            r.setVisible(true);
        }
    }

    public void hideAllRects() {
        for (VisibleRect r : this.rects) {
            r.setVisible(false);
        }
    }

    public void discardAllRects() {
        HashSet<VisibleRect> set = new HashSet<VisibleRect>(this.rects);
        for (VisibleRect r : set) {
            r.discard();
        }
    }

    public void discardAllRects(VisibleRectFilter f) {
        HashSet<VisibleRect> set = new HashSet<VisibleRect>(this.rects);
        for (VisibleRect r : set) {
            if (!f.match(r)) continue;
            r.discard();
        }
    }

    public VisibleRect getRect(String name) {
        for (VisibleRect r : this.rects) {
            if (r.getName() == null || !r.getName().equals(name)) continue;
            return r;
        }
        return null;
    }

    public Iterator<VisibleRect> getRects() {
        return this.rects.iterator();
    }

    public VisibleRect findRect(int x, int y) {
        return this.findRect((double)x, (double)y);
    }

    public VisibleRect findRect(double x, double y, boolean fixed) {
        return this.findRect(x, y, fixed, this.selectinvisible.isSet());
    }

    public VisibleRect findRect(double x, double y, boolean fixed, boolean invisible) {
        VisibleRect found = null;
        for (VisibleRect r : this.rects) {
            if (!r.match(x, y) || !invisible && !r.isVisible() || !fixed && r.isFixed() || found != null && found.getWidth() * found.getHeight() <= r.getWidth() * r.getHeight()) continue;
            found = r;
        }
        return found;
    }

    public VisibleRect findRect(double x, double y) {
        return this.findRect(x, y, true);
    }

    public VisibleRect findRect(Point p, boolean fixed, boolean invisible) {
        return this.findRect(p.getX(), p.getY(), fixed, invisible);
    }

    public VisibleRect findRect(Point p, boolean fixed) {
        return this.findRect(p.getX(), p.getY(), fixed);
    }

    public VisibleRect findRect(Point p) {
        return this.findRect(p.getX(), p.getY());
    }

    public VisibleRectBorder findRectBorder(double x, double y, boolean fixed) {
        VisibleRectBorder found = null;
        VisibleRectBorder border = new VisibleRectBorder();
        for (VisibleRect r : this.rects) {
            if (!r.isPointOnRect(BufferedComponent.toInt(x), BufferedComponent.toInt(y), 1, border)) continue;
            if (!border.valid()) {
                throw new IllegalStateException("invalid border");
            }
            if (!r.isVisible() || !fixed && r.isFixed() || found != null && found.getRect().getWidth() * found.getRect().getHeight() <= r.getWidth() * r.getHeight()) continue;
            found = border;
            border = new VisibleRectBorder();
        }
        return found;
    }

    public VisibleRectBorder findRectBorder(double x, double y) {
        return this.findRectBorder(x, y, false);
    }

    public VisibleRectBorder findRectBorder(Point p, boolean fixed) {
        return this.findRectBorder(p.getX(), p.getY(), fixed);
    }

    public VisibleRectBorder findRectBorder(Point p) {
        return this.findRectBorder(p.getX(), p.getY(), true);
    }

    public void addRectEventListener(RectEventListener l) {
        this.listeners.add(l);
    }

    public void removeRectEventListener(RectEventListener l) {
        this.listeners.remove(l);
    }

    protected void fireRectEvent(VisibleRect r, MouseEvent e) {
        this.fireRectEvent(new RectEvent(r, e));
    }

    protected void fireRectEvent(RectEvent e) {
        e.getRect().fireRectEvent(e);
        for (RectEventListener l : this.listeners) {
            l.buttonClicked(e);
        }
    }

    public void addRectPointEventListener(RectPointEventListener l) {
        this.clisteners.add(l);
    }

    public void removeRectPointEventListener(RectPointEventListener l) {
        this.clisteners.remove(l);
    }

    protected void fireRectangleEvent(MouseEvent evt, RectanglePoint loc) {
        this.fireRectangleEvent(new RectPointEvent(evt, loc));
    }

    protected void fireRectangleEvent(RectPointEvent e) {
        for (RectPointEventListener l : this.clisteners) {
            l.rectanglePointClicked(e);
        }
        this.fireRectangleEvent(e.getRectanglePoint(), e);
    }

    public void addActionListener(ActionListener l, RectanglePoint c) {
        List<ActionListener> list = this.points.get(c);
        if (list == null) {
            list = new ArrayList<ActionListener>();
            this.points.put(c, list);
        }
        list.add(l);
    }

    public void removeActionListener(ActionListener l, RectanglePoint c) {
        List<ActionListener> list = this.points.get(c);
        if (list != null) {
            list.remove(l);
        }
    }

    protected void fireRectangleEvent(RectanglePoint c, RectPointEvent p) {
        RectangleActionEvent e = new RectangleActionEvent(this, 1001, c.getName(), System.currentTimeMillis(), 0, p);
        List<ActionListener> list = this.points.get(c);
        if (list != null) {
            ArrayList<ActionListener> selected = new ArrayList<ActionListener>();
            for (ActionListener l : list) {
                if (l instanceof Action && !((Action)l).isEnabled()) continue;
                selected.add(l);
            }
            for (ActionListener l : selected) {
                l.actionPerformed(e);
            }
        }
    }

    public void addRectModifiedEventListener(RectModifiedEventListener l) {
        this.mlisteners.add(l);
    }

    public void removeRectModifiedEventListener(RectModifiedEventListener l) {
        this.mlisteners.remove(l);
    }

    protected void fireRectModifiedEvent(VisibleRect rect, int action) {
        this.fireRectModifiedEvent(new RectModifiedEvent(rect, action));
    }

    protected void fireRectModifiedEvent(RectModifiedEvent e) {
        e.getRect().fireRectModifiedEvent(e);
        for (RectModifiedEventListener l : this.mlisteners) {
            l.rectModified(e);
        }
    }

    public boolean setScale(Scale s) {
        JViewport vp = this.getViewPort();
        if (vp != null) {
            Rectangle r = vp.getViewRect();
            return this.setScale(s.getX(), s.getY(), new Point2D.Double(r.getCenterX(), r.getCenterY()));
        }
        return this.setScale(s.getX(), s.getY(), null);
    }

    public boolean setScale(double s) {
        JViewport vp = this.getViewPort();
        if (vp != null) {
            Rectangle r = vp.getViewRect();
            return this.setScale(s, (Point2D)new Point2D.Double(r.getCenterX(), r.getCenterY()));
        }
        return this.setScale(s, null);
    }

    public boolean setScaleX(double s) {
        JViewport vp = this.getViewPort();
        if (vp != null) {
            Rectangle r = vp.getViewRect();
            return this.setScaleX(s, new Point2D.Double(r.getCenterX(), r.getCenterY()));
        }
        return this.setScaleX(s, null);
    }

    public boolean setScaleY(double s) {
        JViewport vp = this.getViewPort();
        if (vp != null) {
            Rectangle r = vp.getViewRect();
            return this.setScaleY(s, new Point2D.Double(r.getCenterX(), r.getCenterY()));
        }
        return this.setScaleY(s, null);
    }

    public boolean setScaleX(double s, Point2D p) {
        return this.setScale(s, this.scale.getY(), p);
    }

    public boolean setScaleY(double s, Point2D p) {
        return this.setScale(this.scale.getX(), s, p);
    }

    public boolean setScale(double s, Point2D p) {
        return this.setScale(s, s, p);
    }

    public boolean setScale(double sx, double sy, Point2D p) {
        return this.setScale(new Scale(sx, sy), p);
    }

    public boolean setScale(Scale s, Point2D p) {
        Point n = null;
        if (!s.equals(this.scale)) {
            double scaleX = this.scale.getX();
            double scaleY = this.scale.getY();
            Scale old = this.scale;
            ScaleEvent e = new ScaleEvent(this, s, old);
            for (ScaleEventListener h : this.slisteners) {
                if (h.succeedScale(e)) continue;
                return false;
            }
            this.scale = s;
            JViewport vp = this.getViewPort();
            if (vp != null && p != null) {
                Rectangle r = vp.getViewRect();
                double fX = scaleX / old.getX();
                double fY = scaleX / old.getY();
                double x = p.getX() * fX - (p.getX() - r.getX());
                double y = p.getY() * fY - (p.getY() - r.getY());
                if (x + r.getWidth() >= (double)this.image.getWidth() * scaleX) {
                    x = (double)this.image.getWidth() * scaleX - r.getWidth();
                }
                if (y + r.getHeight() >= (double)this.image.getHeight() * scaleY) {
                    y = (double)this.image.getHeight() * scaleY - r.getHeight();
                }
                this.adjust = n = new Point(BufferedComponent.toInt(x < 0.0 ? 0.0 : x), BufferedComponent.toInt(y < 0.0 ? 0.0 : y));
            }
            if (debug) {
                System.out.println("*** set scale " + s);
            }
            this.updatePreferredSize();
            this.limitWindowSize();
            this.repaint();
            this.revalidate();
            if (n != null) {
                vp.setViewPosition(n);
            }
            this.fireScaleEvent(e);
            return true;
        }
        return false;
    }

    public double getScaleX() {
        return this.scale.getX();
    }

    public double getScaleY() {
        return this.scale.getY();
    }

    public void addScaleEventListener(ScaleEventListener h) {
        this.slisteners.add(h);
    }

    public void removeScaleEventListener(ScaleEventListener h) {
        this.slisteners.remove(h);
    }

    private void fireScaleEvent(ScaleEvent e) {
        for (ScaleEventListener h : this.slisteners) {
            h.componentScaled(e);
        }
    }

    private JViewport getViewPort() {
        try {
            return (JViewport)this.getParent();
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    public int translateX(int x) {
        if ((x = (int)((double)(x - this.insets.left) / this.scale.getX())) < 0) {
            x = 0;
        }
        if (x >= this.image.getWidth()) {
            x = this.image.getWidth() - 1;
        }
        return x;
    }

    public int translateY(int y) {
        if ((y = (int)((double)(y - this.insets.top) / this.scale.getY())) < 0) {
            y = 0;
        }
        if (y >= this.image.getHeight()) {
            y = this.image.getHeight() - 1;
        }
        return y;
    }

    public int translateX(MouseEvent e) {
        return this.translateX(e.getX());
    }

    public int translateY(MouseEvent e) {
        return this.translateY(e.getY());
    }

    public int translateToComponentX(int x) {
        return BufferedComponent.toInt((double)x * this.scale.getX() + (double)this.insets.left);
    }

    public int translateToComponentY(int y) {
        return BufferedComponent.toInt((double)y * this.scale.getY() + (double)this.insets.top);
    }

    public int componentMiddleX(int x) {
        return this.translateToComponentX(x) + (int)this.scale.getX() / 2;
    }

    public int componentMiddleY(int y) {
        return this.translateToComponentY(y) + (int)this.scale.getY() / 2;
    }

    public MouseEvent translate(MouseEvent e) {
        if (this.scale.isOne() && this.insets.left == 0 && this.insets.top == 0) {
            return e;
        }
        int x = this.translateX(e);
        int y = this.translateY(e);
        e = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), x, y, e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        return e;
    }

    public void setRectangleSelector(RectangleSelector s) {
        if (this.selector != null) {
            this.selector.uninstall();
        }
        this.selector = s;
        if (this.selector != null) {
            this.selector.install(this);
        }
    }

    public RectangleSelector getRectangleSelector() {
        return this.selector;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestFrame frame = new TestFrame();
                frame.setDefaultCloseOperation(3);
                frame.setVisible(true);
            }
        });
        System.out.println("***2D   1,1,10,10");
        Rectangle2D rect = new Rectangle2D.Double(1.0, 1.0, 10.0, 10.0);
        System.out.println("rect: 1,1,10,10:" + rect);
        System.out.println("center " + rect.getCenterX() + "," + rect.getCenterY());
        rect.setFrameFromDiagonal(new Point(1, 1), new Point(3, 3));
        System.out.println("rect D(I): 1,1 to 3,3:" + rect);
        rect.setFrameFromDiagonal(new Point2D.Double(1.0, 1.0), new Point2D.Double(3.0, 3.0));
        System.out.println("rect D(D): 1,1 to 3,3:" + rect);
        System.out.println("***I    1,1,10,10");
        rect = new Rectangle(1, 1, 10, 10);
        System.out.println("rect: 1,1,10,10:" + rect);
        System.out.println("center " + rect.getCenterX() + "," + rect.getCenterY());
        rect.setFrameFromDiagonal(new Point(1, 1), new Point(3, 3));
        System.out.println("rect D(D): 1,1 to 3,3:" + rect);
        rect.setFrameFromDiagonal(new Point2D.Double(1.0, 1.0), new Point2D.Double(3.0, 3.0));
        System.out.println("rect D(I): 1,1 to 3,3:" + rect);
        rect.setFrameFromCenter(new Point(2, 2), new Point(3, 3));
        System.out.println("rect C(I): 2,2 to 3,3:" + rect);
        rect.setFrameFromCenter(new Point(2, 2), new Point(4, 4));
        System.out.println("rect C(I): 2,2 to 4,4:" + rect);
        rect = new Rectangle2D.Double(1.0, 1.0, 11.0, 11.0);
        System.out.println("*** rect: 1,1,11,11:" + rect);
        System.out.println("center " + rect.getCenterX() + "," + rect.getCenterY());
        System.out.println("bounds " + rect.getBounds());
        System.out.println(" contains 0,0: " + rect.contains(0.0, 0.0));
        System.out.println(" contains 1,1: " + rect.contains(1.0, 1.0));
        System.out.println(" contains 10,10: " + rect.contains(10.0, 10.0));
        System.out.println(" contains 11,11: " + rect.contains(11.0, 11.0));
        System.out.println(" contains 12,12: " + rect.contains(12.0, 12.0));
        System.out.println(" contains 13,13: " + rect.contains(13.0, 13.0));
    }

    public static class RectangleSelector {
        private Point active;
        private Point origin;
        private VisibleRect rect;
        private boolean move;
        private int action;
        private BufferedComponent comp;
        private Stroke line;
        static final Cursor move_cursor = Cursor.getPredefinedCursor(13);
        static final Cursor cross_cursor = Cursor.getPredefinedCursor(1);
        static final Cursor def_cursor = Cursor.getDefaultCursor();

        public void install(BufferedComponent comp) {
            if (this.comp != null) {
                throw new IllegalStateException("selector already assigned");
            }
            this.comp = comp;
        }

        public void uninstall() {
            this.active = null;
            this.origin = null;
            this.comp = null;
            if (this.rect != null) {
                this.rect.discard();
            }
            this.rect = null;
        }

        public void setStroke(Stroke line) {
            this.line = line;
        }

        protected VisibleRect getVisibleRect() {
            return this.rect;
        }

        protected void select(VisibleRect rect, int action) {
            this.comp.fireRectModifiedEvent(rect, action);
        }

        private Cursor adjustRect(VisibleRect rect, Point origin, Point current) {
            Dimension d = this.adjustDimension(new Dimension(BufferedComponent.toInt(current.getX() - origin.getX()), BufferedComponent.toInt(current.getY() - origin.getY())));
            Point p1 = this.getRectP1(origin, d);
            Point p2 = this.getRectP2(origin, d);
            rect.setFrameFromDiagonal(p1, p2);
            return this.getCursor(d);
        }

        protected Cursor getCursor(Dimension d) {
            if (d.getWidth() < 0.0) {
                if (d.getHeight() < 0.0) {
                    return Cursor.getPredefinedCursor(6);
                }
                return Cursor.getPredefinedCursor(4);
            }
            if (d.getHeight() < 0.0) {
                return Cursor.getPredefinedCursor(7);
            }
            return Cursor.getPredefinedCursor(5);
        }

        protected Dimension adjustDimension(Dimension d) {
            return d;
        }

        protected Dimension adjustMove(VisibleRect rect, Dimension d) {
            return d;
        }

        protected Point getOrigin(VisibleRectBorder b) {
            return b.getOppositeCornerPoint();
        }

        protected Point getRectP1(Point origin, Dimension d) {
            return origin;
        }

        protected Point getRectP2(Point origin, Dimension d) {
            Point p = new Point(origin);
            p.translate(BufferedComponent.toInt(d.getWidth() - 1.0), BufferedComponent.toInt(d.getHeight() - 1.0));
            return p;
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                this.active = e.getPoint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                this.active = null;
                this.origin = null;
                if (this.rect != null) {
                    VisibleRect selected = this.rect;
                    this.rect = null;
                    if (debug) {
                        System.out.println("reset cursor");
                    }
                    this.comp.setCursor(Cursor.getDefaultCursor());
                    this.select(selected, this.action);
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
            Point current = e.getPoint();
            if (e.isShiftDown()) {
                VisibleRect r = this.comp.findRect(current, false, false);
                if (r != null) {
                    this.comp.setCursor(cross_cursor);
                    return;
                }
            } else {
                VisibleRectBorder b = this.comp.findRectBorder(current, false);
                if (b != null) {
                    this.comp.setCursor(cross_cursor);
                    return;
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.active != null) {
                Point current = e.getPoint();
                if (!this.comp.getVisibleRect().contains(current)) {
                    return;
                }
                if (this.origin == null) {
                    this.move = e.isShiftDown();
                    if (this.move) {
                        this.rect = this.comp.findRect(current, false, false);
                        if (this.rect == null) {
                            this.active = null;
                            return;
                        }
                        if (debug) {
                            System.out.println("found move rect " + this.rect.getId());
                        }
                        this.comp.setCursor(Cursor.getPredefinedCursor(13));
                        this.origin = current;
                        this.action = 2;
                    } else {
                        VisibleRectBorder b = this.comp.findRectBorder(this.active, false);
                        if (b != null) {
                            this.rect = b.getRect();
                            this.origin = this.getOrigin(b);
                            this.action = 3;
                        } else {
                            this.origin = current;
                            this.action = 1;
                        }
                    }
                } else {
                    if (this.rect == null) {
                        this.rect = this.comp.createRect(null, BufferedComponent.toInt(e.getX()), BufferedComponent.toInt(e.getY()), 0, 0);
                        this.rect.setVisible(true);
                        if (this.line != null) {
                            this.rect.setStroke(this.line);
                        }
                    }
                    if (this.move) {
                        this.rect.translate(BufferedComponent.toInt(current.getX() - this.origin.getX()), BufferedComponent.toInt(current.getY() - this.origin.getY()));
                        this.origin = current;
                    } else {
                        Cursor c = this.adjustRect(this.rect, this.origin, current);
                        if (c != null) {
                            this.comp.setCursor(c);
                        }
                    }
                }
            }
        }
    }

    private class ContentPane
    extends JComponent {
        private int max;
        private int limitCnt;

        public ContentPane() {
            this.limitCnt = this.max = 5;
            this.setInheritsPopupMenu(true);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            if (BufferedComponent.this.tooltiphandler != null) {
                return BufferedComponent.this.tooltiphandler.getToolTipText(BufferedComponent.this.translate(event));
            }
            return null;
        }

        @Override
        public void paintComponent(Graphics g) {
            Insets o = this.getInsets();
            if (BufferedComponent.this.image != null) {
                g.drawImage(BufferedComponent.this.image, o.left, o.top, BufferedComponent.toInt((double)BufferedComponent.this.image.getWidth() * BufferedComponent.this.scale.getX()), BufferedComponent.toInt((double)BufferedComponent.this.image.getHeight() * BufferedComponent.this.scale.getY()), null);
            }
            for (PaintHandler h : BufferedComponent.this.painthandlers) {
                h.paintComponent(g.create());
            }
            if (BufferedComponent.this.limitPending && --this.limitCnt <= 0) {
                BufferedComponent.this.limitPending = false;
                this.limitCnt = this.max;
            }
            BufferedComponent.this.limitWindowSize();
        }

        @Override
        public Graphics getGraphics() {
            return this.createGraphics();
        }

        public Graphics2D createGraphics() {
            return BufferedComponent.this.image.createGraphics();
        }
    }

    public static interface ToolTipHandler {
        public String getToolTipText(MouseEvent var1);
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener,
    MouseMotionListener {
        final Cursor point_cursor = Cursor.getPredefinedCursor(12);
        final Cursor def_cursor = Cursor.getDefaultCursor();

        private MouseHandler() {
        }

        private RectanglePoint checkRectPoints(Rectangle r, Point p) {
            if (p.getX() < r.getX() + 20.0 && p.getY() < r.getY() + 20.0) {
                return RectPointEvent.TOP_LEFT;
            }
            if (p.getX() < r.getX() + 20.0 && p.getY() > r.getY() + r.getHeight() - 20.0) {
                return RectPointEvent.BOTTOM_LEFT;
            }
            if (p.getX() >= r.getX() + r.getWidth() - 20.0 && p.getY() < r.getY() + 20.0) {
                return RectPointEvent.TOP_RIGHT;
            }
            if (p.getX() >= r.getX() + r.getWidth() - 20.0 && p.getY() >= r.getY() + r.getHeight() - 20.0) {
                return RectPointEvent.BOTTOM_RIGHT;
            }
            if (p.getX() < r.getX() + 20.0 && p.getY() >= r.getY() + (r.getHeight() - 20.0) / 2.0 && p.getY() <= r.getY() + (r.getHeight() + 20.0) / 2.0) {
                return RectPointEvent.MIDDLE_LEFT;
            }
            if (p.getX() >= r.getX() + r.getWidth() - 20.0 && p.getY() >= r.getY() + (r.getHeight() - 20.0) / 2.0 && p.getY() <= r.getY() + (r.getHeight() + 20.0) / 2.0) {
                return RectPointEvent.MIDDLE_RIGHT;
            }
            if (p.getY() < r.getY() + 20.0 && p.getX() >= r.getX() + (r.getWidth() - 20.0) / 2.0 && p.getX() <= r.getX() + (r.getWidth() + 20.0) / 2.0) {
                return RectPointEvent.MIDDLE_TOP;
            }
            if (p.getY() >= r.getY() + r.getHeight() - 20.0 && p.getX() >= r.getX() + (r.getWidth() - 20.0) / 2.0 && p.getX() <= r.getX() + (r.getWidth() + 20.0) / 2.0) {
                return RectPointEvent.MIDDLE_BOTTOM;
            }
            return null;
        }

        public RectanglePoint getRectanglePoint(MouseEvent e) {
            JViewport vp;
            Point p = e.getPoint();
            RectanglePoint rect_point = this.checkRectPoints(BufferedComponent.this.fullviewrect, p);
            if (rect_point == null) {
                rect_point = this.checkRectPoints(BufferedComponent.this.content.getVisibleRect(), p);
            }
            if (rect_point == null && (vp = BufferedComponent.this.getViewPort()) != null) {
                rect_point = this.checkRectPoints(vp.getViewRect(), p);
            }
            return rect_point;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            RectanglePoint rect_point;
            VisibleRect r;
            MouseEvent t = BufferedComponent.this.translate(e);
            if (debug) {
                System.out.println("click at     " + e.getX() + "," + e.getY());
                System.out.println("  translated " + t.getX() + "," + t.getY());
            }
            if ((r = BufferedComponent.this.findRect(t.getPoint())) != null) {
                BufferedComponent.this.fireRectEvent(r, t);
            }
            if (e.getButton() == 1 && (rect_point = this.getRectanglePoint(e)) != null) {
                BufferedComponent.this.fireRectangleEvent(t, rect_point);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (BufferedComponent.this.scalemode != 0) {
                int diff = e.getUnitsToScroll() / e.getScrollAmount();
                switch (BufferedComponent.this.scalemode) {
                    case 1: {
                        if (diff > 0) {
                            BufferedComponent.this.setScaleX(BufferedComponent.this.getScaleX() * 1.1, e.getPoint());
                            break;
                        }
                        BufferedComponent.this.setScaleX(BufferedComponent.this.getScaleX() / 1.1, e.getPoint());
                        break;
                    }
                    case 2: {
                        if (diff > 0) {
                            BufferedComponent.this.setScaleY(BufferedComponent.this.getScaleX() * 1.1, e.getPoint());
                            break;
                        }
                        BufferedComponent.this.setScaleY(BufferedComponent.this.getScaleX() / 1.1, e.getPoint());
                        break;
                    }
                    default: {
                        if (diff > 0) {
                            BufferedComponent.this.setScale(BufferedComponent.this.scale.scale(1.1), (Point2D)e.getPoint());
                            break;
                        }
                        BufferedComponent.this.setScale(BufferedComponent.this.scale.scale(0.9090909090909091), (Point2D)e.getPoint());
                    }
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            RectanglePoint rect_point;
            BufferedComponent.this.setCursor(this.def_cursor);
            if (BufferedComponent.this.selector != null) {
                MouseEvent t = BufferedComponent.this.translate(e);
                BufferedComponent.this.selector.mouseMoved(t);
            }
            if ((rect_point = this.getRectanglePoint(e)) != null && BufferedComponent.this.points.get(rect_point) != null && !((List)BufferedComponent.this.points.get(rect_point)).isEmpty()) {
                BufferedComponent.this.setCursor(this.point_cursor);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
            JViewport vp = BufferedComponent.this.getViewPort();
            if (vp != null) {
                Insets parent = BufferedComponent.this.getParent().getInsets();
                Point p = new Point(e.getX(), e.getY());
                Rectangle r = vp.getViewRect();
                if (!r.contains(p)) {
                    r = new Rectangle(BufferedComponent.toInt(p.getX() - 10.0), BufferedComponent.toInt(p.getY() - 10.0), 20, 20);
                    BufferedComponent.this.scrollRectToVisible(r);
                }
            }
            if (BufferedComponent.this.selector != null) {
                MouseEvent t = BufferedComponent.this.translate(e);
                BufferedComponent.this.selector.mouseDragged(t);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (BufferedComponent.this.selector != null) {
                MouseEvent t = BufferedComponent.this.translate(e);
                BufferedComponent.this.selector.mousePressed(t);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (BufferedComponent.this.selector != null) {
                MouseEvent t = BufferedComponent.this.translate(e);
                BufferedComponent.this.selector.mouseReleased(t);
            }
        }
    }

    private static class FrameInfo {
        Insets insets = new Insets(0, 0, 0, 0);
        Container root;

        private FrameInfo() {
        }

        public void setup(Container c) {
            this.insets.bottom = 0;
            this.insets.left = 0;
            this.insets.right = 0;
            this.insets.top = 0;
            while (c != null) {
                Insets cur = c.getInsets();
                if (c.getClass().equals(JScrollPane.class)) {
                    JScrollBar h;
                    JScrollPane p = (JScrollPane)c;
                    JScrollBar v = p.getVerticalScrollBar();
                    if (v.isVisible()) {
                        this.insets.right += v.getWidth();
                    }
                    if ((h = p.getHorizontalScrollBar()).isVisible()) {
                        this.insets.bottom += v.getWidth();
                    }
                }
                this.insets.bottom += cur.bottom;
                this.insets.left += cur.left;
                this.insets.right += cur.right;
                this.insets.top += cur.top;
                this.root = c;
                if (c instanceof Window) {
                    c = null;
                    continue;
                }
                c = c.getParent();
            }
        }
    }

    public class VisibleRect
    implements PaintHandler {
        private int id;
        private String label;
        private String name;
        private Rectangle _rect;
        private boolean visible;
        private boolean active;
        private boolean fixed;
        private Object owner;
        private ProportionProvider proportionProvider;
        private Stroke line;
        private List<RectEventListener> listeners = new ArrayList<RectEventListener>();
        private Set<RectModifiedEventListener> mlisteners = new HashSet<RectModifiedEventListener>();

        private VisibleRect() {
            this.id = BufferedComponent.this.id_cnt++;
            this.activate();
        }

        protected VisibleRect(String name) {
            this(name, name);
        }

        protected VisibleRect(String name, String label) {
            this(name, label, new Rectangle(0, 0, 0, 0));
        }

        protected VisibleRect(String name, int x, int y, int w, int h) {
            this(name, new Rectangle(x, y, w, h));
        }

        protected VisibleRect(String name, String label, int x, int y, int w, int h) {
            this(name, label, new Rectangle(x, y, w, h));
        }

        protected VisibleRect(String name, Rectangle r) {
            this(name, name, r);
        }

        protected VisibleRect(String name, String label, Rectangle r) {
            this();
            this.name = name;
            if (label == null) {
                label = name;
            }
            this.label = label;
            this._rect = new Rectangle(r);
        }

        public void setStroke(Stroke line) {
            this.draw();
            this.line = line;
            this.draw();
        }

        public ProportionProvider getProportionProvider() {
            return this.proportionProvider;
        }

        public void setProportionProvider(ProportionProvider proportionProvider) {
            this.proportionProvider = proportionProvider;
        }

        public void discard() {
            boolean cur = this.active;
            this.setVisible(false);
            this.active = false;
            BufferedComponent.this.rects.remove(this);
            if (cur) {
                this.fireRectStateEvent();
            }
        }

        public void activate() {
            this.activate(false);
        }

        public void activate(boolean subst) {
            if (!this.active) {
                VisibleRect old;
                if (subst && this.getName() != null && (old = BufferedComponent.this.getRect(this.getName())) != null && old != this) {
                    old.discard();
                }
                this.active = true;
                this.fireRectStateEvent();
                BufferedComponent.this.rects.add(this);
            }
        }

        public boolean isVisible() {
            return this.visible;
        }

        public boolean isFixed() {
            return this.fixed;
        }

        public boolean isActive() {
            return this.active;
        }

        public synchronized int getId() {
            return this.id;
        }

        public synchronized String getName() {
            return this.name;
        }

        public synchronized String getLabel() {
            return this.label;
        }

        public synchronized Object getOwner() {
            return this.owner;
        }

        public synchronized VisibleRect setOwner(Object o) {
            this.owner = o;
            return this;
        }

        public synchronized Rectangle _getRect() {
            return new Rectangle(this._rect);
        }

        public synchronized double getY() {
            return this._rect.getY();
        }

        public synchronized double getX() {
            return this._rect.getX();
        }

        public synchronized Point getCenter() {
            return new Point(this.getCenterX(), this.getCenterY());
        }

        public int getCenterY() {
            return BufferedComponent.toInt(this._rect.getCenterY() - 0.5);
        }

        public int getCenterX() {
            return BufferedComponent.toInt(this._rect.getCenterX() - 0.5);
        }

        public int getWidth() {
            return BufferedComponent.toInt(this._rect.getWidth());
        }

        public Dimension getSize() {
            return this._rect.getSize();
        }

        public Point getLocation() {
            return this._rect.getLocation();
        }

        public int getHeight() {
            return BufferedComponent.toInt(this._rect.getHeight());
        }

        public boolean contains(Rectangle2D r) {
            return this._rect.contains(r);
        }

        public boolean contains(double x, double y, double w, double h) {
            return this._rect.contains(x, y, w, h);
        }

        public boolean contains(Point2D p) {
            return this._rect.contains(p);
        }

        public boolean contains(double x, double y) {
            return this._rect.contains(x, y);
        }

        public boolean match(double x, double y) {
            if (this.contains(x, y)) {
                return true;
            }
            return (BufferedComponent.toInt(this._rect.getWidth()) < 5 || BufferedComponent.toInt(this._rect.getHeight()) < 5) && (Math.abs(x - (double)this.getCenterX()) < 2.0 || Math.abs(y - (double)this.getCenterY()) < 2.0);
        }

        public VisibleRect setFixed(boolean fixed) {
            this.fixed = fixed;
            return this;
        }

        public VisibleRect setName(String name) {
            this.name = name;
            if (this.label == null) {
                this.setLabel(name);
            }
            return this;
        }

        public VisibleRect setLabel(String label) {
            this.draw();
            this.label = label;
            this.draw();
            return this;
        }

        public void setRect(Rectangle2D r) {
            this.draw();
            this._rect.setRect(r);
            this.draw();
        }

        public void setSize(Dimension2D d) {
            this.setSize(BufferedComponent.toInt(d.getWidth()), BufferedComponent.toInt(d.getHeight()));
        }

        public void setSize(int w, int h) {
            this.draw();
            this._rect.setSize(w, h);
            this.draw();
        }

        public void setLocation(int x, int y) {
            this.draw();
            this._rect.setLocation(x, y);
            this.draw();
        }

        public void setLocation(Point2D p) {
            this.setLocation(BufferedComponent.toInt(p.getX()), BufferedComponent.toInt(p.getY()));
        }

        public void grow(int h, int v) {
            this.draw();
            this._rect.grow(h, v);
            this.draw();
        }

        public void translate(int x, int y) {
            this.draw();
            this._rect.translate(x, y);
            this.draw();
        }

        public void setFrameFromCenter(Point2D center, Point2D corner) {
            this.draw();
            this._rect.setFrameFromCenter(center, corner);
            this._rect.setSize(BufferedComponent.toInt(this._rect.getWidth() + 1.0), BufferedComponent.toInt(this._rect.getHeight() + 1.0));
            this.draw();
        }

        public void setFrameFromDiagonal(Point2D p1, Point2D p2) {
            this.draw();
            this._rect.setFrameFromDiagonal(p1, p2);
            this._rect.setSize(BufferedComponent.toInt(this._rect.getWidth() + 1.0), BufferedComponent.toInt(this._rect.getHeight() + 1.0));
            this.draw();
        }

        public VisibleRect setVisible(boolean v) {
            if (v != this.visible) {
                this.draw();
                this.visible = v;
                this.draw();
            }
            return this;
        }

        @Override
        public void paintComponent(Graphics g) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void draw() {
            if (!this.visible) {
                return;
            }
            Graphics2D g = BufferedComponent.this.getDrawer();
            this.draw(g);
            BufferedComponent.this.repaint();
        }

        protected void draw(Graphics2D g) {
            Stroke orig = g.getStroke();
            int x = BufferedComponent.toInt(this._rect.getX());
            int y = BufferedComponent.toInt(this._rect.getY());
            int w = BufferedComponent.toInt(this._rect.getWidth());
            int h = BufferedComponent.toInt(this._rect.getHeight());
            if (this.line != null) {
                g.setStroke(this.line);
            }
            if (w < 5 || h < 5) {
                g.drawLine(BufferedComponent.toInt(this.getCenterX()), BufferedComponent.toInt(this.getCenterY() - 10), BufferedComponent.toInt(this.getCenterX()), BufferedComponent.toInt(this.getCenterY() + 10));
                g.drawLine(BufferedComponent.toInt(this.getCenterX() - 10), BufferedComponent.toInt(this.getCenterY()), BufferedComponent.toInt(this.getCenterX() + 10), BufferedComponent.toInt(this.getCenterY()));
            } else {
                g.drawLine(x, y, x, y + h - 1);
                g.drawLine(x, y, x + w - 1, y);
                g.drawLine(x + w - 1, y + h - 1, x, y + h - 1);
                g.drawLine(x + w - 1, y + h - 1, x + w - 1, y);
            }
            g.setStroke(orig);
            if (this.label != null && BufferedComponent.this.isShowDecoration()) {
                FontMetrics metrics = g.getFontMetrics();
                int hgt = metrics.getHeight();
                int adv = metrics.stringWidth(this.label);
                Dimension d = new Dimension(adv, hgt);
                if (this._draw(g, this.label, d, 1, 1, 1, 1) || this._draw(g, this.label, d, 0, 1, 0, 1) || this._draw(g, this.label, d, 1, 0, 1, -1) || !this._draw(g, this.label, d, 0, 0, 0, -1)) {
                    // empty if block
                }
            }
        }

        private boolean _draw(Graphics2D g, String name, Dimension d, int fw, int fh, int fdw, int fdh) {
            double py = this._rect.getY() + (this._rect.getHeight() - 1.0) * (double)fh + (d.getHeight() + 2.0) * (double)fdh;
            if (0.0 <= py && py < (double)BufferedComponent.this.image.getHeight()) {
                double px = this._rect.getX() + (this._rect.getWidth() - 1.0) * (double)fw + (double)(2 * fdw);
                double px2 = px - (d.getWidth() + 2.0) * (double)fdw;
                if (0.0 <= px && px < (double)BufferedComponent.this.image.getWidth() && px2 > 0.0) {
                    g.drawString(name, BufferedComponent.toInt(px2), BufferedComponent.toInt(py - d.getHeight() * (double)Integer.signum(fdh - 1) - (double)(2 * (fdh + 1))));
                    return true;
                }
            }
            return false;
        }

        private boolean checkLine(double sx, double ex, double cy, double px, double py, int t, VisibleRectBorder b, Side side) {
            boolean r;
            if (sx > ex) {
                double tmp = sx;
                sx = ex;
                ex = tmp;
            }
            boolean bl = r = cy - (double)t <= py && py <= cy + (double)t && sx - (double)t <= px && px <= ex + (double)t;
            if (r && b != null) {
                Corner c;
                b.setSide(side);
                if (px < (sx + ex) / 2.0) {
                    c = side.getLowerCorner();
                    if (c == null) {
                        throw new IllegalStateException("LC");
                    }
                } else {
                    c = side.getHigherCorner();
                    if (c == null) {
                        throw new IllegalStateException("HC");
                    }
                }
                b.setCorner(c);
                b.setRect(this);
            }
            return r;
        }

        public boolean isPointOnRect(int x, int y, int t) {
            return this.isPointOnRect(x, y, t, null);
        }

        public boolean isPointOnRect(int x, int y, int t, VisibleRectBorder b) {
            if (this.checkLine(this.getX(), this.getX() + (double)this.getWidth() - 1.0, this.getY(), x, y, t, b, VisibleRectBorder.TOP)) {
                return true;
            }
            if (this.checkLine(this.getX(), this.getX() + (double)this.getWidth() - 1.0, this.getY() + (double)this.getHeight() - 1.0, x, y, t, b, VisibleRectBorder.BOTTOM)) {
                return true;
            }
            if (this.checkLine(this.getY(), this.getY() + (double)this.getHeight() - 1.0, this.getX(), y, x, t, b, VisibleRectBorder.LEFT)) {
                return true;
            }
            return this.checkLine(this.getY(), this.getY() + (double)this.getHeight() - 1.0, this.getX() + (double)this.getWidth() - 1.0, y, x, t, b, VisibleRectBorder.RIGHT);
        }

        public String toString() {
            String n = this.getName();
            if (n == null) {
                n = "Id " + this.getId();
            }
            return "rectangle " + n + " at (" + this.getX() + "," + this.getY() + ") with size (" + this.getWidth() + "," + this.getHeight() + ")";
        }

        public void addRectEventListener(RectEventListener l) {
            this.listeners.add(l);
        }

        public void removeRectEventListener(RectEventListener l) {
            this.listeners.remove(l);
        }

        public boolean hasRectEventListeners() {
            return !this.listeners.isEmpty();
        }

        protected void fireRectEvent(MouseEvent e) {
            this.fireRectEvent(new RectEvent(this, e));
        }

        protected void fireRectEvent(RectEvent e) {
            for (RectEventListener l : this.listeners) {
                l.buttonClicked(e);
            }
        }

        protected void fireRectStateEvent() {
            RectStateEvent e = new RectStateEvent(this);
            for (RectEventListener l : this.listeners) {
                l.stateChanged(e);
            }
        }

        public void addRectModifiedEventListener(RectModifiedEventListener l) {
            this.mlisteners.add(l);
        }

        public void removeRectModifiedEventListener(RectModifiedEventListener l) {
            this.mlisteners.remove(l);
        }

        public boolean hasRectModifiedEventListeners() {
            return !this.mlisteners.isEmpty();
        }

        protected void fireRectModifiedEvent(int action) {
            this.fireRectModifiedEvent(new RectModifiedEvent(this, action));
        }

        protected void fireRectModifiedEvent(RectModifiedEvent e) {
            for (RectModifiedEventListener l : this.mlisteners) {
                l.rectModified(e);
            }
        }
    }

    public static interface VisibleRectFilter {
        public boolean match(VisibleRect var1);
    }

    public static class VisibleRectBorder {
        public static final Side LEFT = Side.LEFT;
        public static final Side RIGHT = Side.RIGHT;
        public static final Side TOP = Side.TOP;
        public static final Side BOTTOM = Side.BOTTOM;
        public static final Corner TOP_LEFT = RectPointEvent.TOP_LEFT;
        public static final Corner TOP_RIGHT = RectPointEvent.TOP_RIGHT;
        public static final Corner BOTTOM_LEFT = RectPointEvent.BOTTOM_LEFT;
        public static final Corner BOTTOM_RIGHT = RectPointEvent.BOTTOM_RIGHT;
        private VisibleRect rect;
        private Side side;
        private Corner corner;

        public VisibleRectBorder() {
        }

        public VisibleRectBorder(VisibleRect rect, Side side, Corner corner) {
            this.rect = rect;
            this.side = side;
            this.corner = corner;
        }

        public boolean valid() {
            return this.rect != null && this.side != null && this.corner != null;
        }

        public Corner getCorner() {
            return this.corner;
        }

        public VisibleRect getRect() {
            return this.rect;
        }

        public Side getSide() {
            return this.side;
        }

        public void setCorner(Corner corner) {
            this.corner = corner;
        }

        public void setRect(VisibleRect rect) {
            this.rect = rect;
        }

        public void setSide(Side side) {
            this.side = side;
        }

        public Corner getOppositeCorner() {
            return this.corner.getOppositeCorner();
        }

        public Side getOppositeSide() {
            return this.side.getOppositeSide();
        }

        public Point getCornerPoint() {
            return this.getCorner().getPoint(this.getRect()._getRect());
        }

        public Point getOppositeCornerPoint() {
            return this.getOppositeCorner().getPoint(this.getRect()._getRect());
        }
    }

    public static class RectEvent
    extends ClickEvent {
        private VisibleRect rect;

        public RectEvent(VisibleRect r, MouseEvent e) {
            super(r, e);
            this.rect = r;
        }

        public VisibleRect getRect() {
            return this.rect;
        }

        public Object getOwner() {
            return this.rect.getOwner();
        }

        @Override
        public String getDescription() {
            String n = this.rect.getName();
            if (n == null) {
                n = "id " + this.rect.getId();
            }
            return "rectangle " + n + " with " + super.getDescription();
        }
    }

    public static interface RectEventListener {
        public void buttonClicked(RectEvent var1);

        public void stateChanged(RectStateEvent var1);
    }

    public static class RectPointEvent
    extends ClickEvent {
        public static final Corner TOP_LEFT = Corner.TOP_LEFT;
        public static final Corner TOP_RIGHT = Corner.TOP_RIGHT;
        public static final Corner BOTTOM_LEFT = Corner.BOTTOM_LEFT;
        public static final Corner BOTTOM_RIGHT = Corner.BOTTOM_RIGHT;
        public static final RectanglePoint MIDDLE_LEFT = RectanglePoint.MIDDLE_LEFT;
        public static final RectanglePoint MIDDLE_RIGHT = RectanglePoint.MIDDLE_RIGHT;
        public static final RectanglePoint MIDDLE_TOP = RectanglePoint.MIDDLE_TOP;
        public static final RectanglePoint MIDDLE_BOTTOM = RectanglePoint.MIDDLE_BOTTOM;
        private RectanglePoint rectPoint;

        public RectPointEvent(MouseEvent evt, RectanglePoint loc) {
            super(evt.getSource(), evt);
            this.rectPoint = loc;
        }

        public Corner getCorner() {
            return this.isCornerEvent() ? (Corner)this.rectPoint : null;
        }

        public boolean isCornerEvent() {
            return this.rectPoint instanceof Corner;
        }

        public RectanglePoint getRectanglePoint() {
            return this.rectPoint;
        }

        public String getPointName() {
            if (this.rectPoint == null) {
                return "None";
            }
            return this.rectPoint.getName();
        }

        @Override
        public String getDescription() {
            return this.getPointName() + " with " + super.getDescription();
        }
    }

    public static interface RectPointEventListener {
        public void rectanglePointClicked(RectPointEvent var1);
    }

    public static class RectangleActionEvent
    extends ActionEvent {
        private RectPointEvent p;

        public RectangleActionEvent(Object source, int id, String command, long when, int modifiers, RectPointEvent p) {
            super(source, id, command, when, modifiers);
            this.p = p;
        }

        public RectangleActionEvent(Object source, int id, String command, int modifiers, RectPointEvent p) {
            super(source, id, command, modifiers);
            this.p = p;
        }

        public RectangleActionEvent(Object source, int id, String command, RectPointEvent p) {
            super(source, id, command);
            this.p = p;
        }

        public RectPointEvent getRectanglePointEvent() {
            return this.p;
        }
    }

    public static class RectModifiedEvent
    extends EventObject {
        public static final int RECT_CREATED = 1;
        public static final int RECT_MOVED = 2;
        public static final int RECT_RESIZED = 3;
        private VisibleRect rect;
        private int action;

        public RectModifiedEvent(VisibleRect source, int action) {
            super(source);
            this.rect = source;
            this.action = action;
        }

        public int getAction() {
            return this.action;
        }

        public VisibleRect getRect() {
            return this.rect;
        }
    }

    public static interface RectModifiedEventListener {
        public void rectModified(RectModifiedEvent var1);
    }

    static class TestFrame
    extends JFrame {
        TestComponent tc = new TestComponent();

        TestFrame() {
            JScrollPane sp = new JScrollPane(this.tc);
            this.add(sp);
            this.pack();
            System.out.println("SP: " + sp.getInsets());
            MyListener l = new MyListener();
            this.tc.addRectEventListener(l);
            this.tc.addRectPointEventListener(l);
        }

        class MyListener
        extends DefaultRectEventListener
        implements RectPointEventListener,
        RectEventListener {
            RectangleSelector[] sel;
            int current;

            MyListener() {
                this.sel = new RectangleSelector[]{new RectangleSelector(), new CenteredRectangleSelector(), new ProportionalRectangleSelector(TestFrame.this.tc), new CenteredProportionalRectangleSelector(TestFrame.this.tc)};
                this.current = -1;
            }

            @Override
            public void rectanglePointClicked(RectPointEvent e) {
                System.out.println(e.getDescription());
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    if (e.getCorner() == RectPointEvent.BOTTOM_LEFT) {
                        System.out.println("  hide all");
                        e.getComponent().hideAllRects();
                    }
                    if (e.getCorner() == RectPointEvent.BOTTOM_RIGHT) {
                        System.out.println("  show all");
                        e.getComponent().showAllRects();
                    }
                }
                if (e.getClickCount() == 1 && e.getButton() == 1 && e.getCorner() == RectPointEvent.TOP_LEFT) {
                    ++this.current;
                    if (this.current >= this.sel.length) {
                        this.current = 0;
                    }
                    System.out.println("  select mode " + this.current);
                    e.getComponent().setRectangleSelector(this.sel[this.current]);
                }
            }

            @Override
            public void buttonClicked(RectEvent e) {
                System.out.println(e.getDescription());
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    System.out.println("  hide " + e.getRect().getName());
                    e.getRect().setVisible(false);
                }
            }
        }
    }

    static class TestComponent
    extends BufferedComponent {
        TestComponent() {
            super(200, 200);
            this.setup();
            this.setLimitWindowSize(true);
            this.setScaleMode(true);
        }

        void setup() {
            Graphics2D g = this.createGraphics();
            int test = 2;
            if ((test & 4) == 4) {
                this.setBorder(new EmptyBorder(10, 10, 10, 10));
            }
            if ((test & 1) == 1) {
                g.setColor(Color.GREEN);
                g.drawRect(0, 0, 199, 199);
                g.setColor(Color.BLACK);
                g.drawRect(1, 1, 197, 197);
                g.setColor(Color.RED);
                g.drawRect(2, 2, 195, 195);
                g.setColor(Color.BLACK);
                g.drawRect(3, 3, 193, 193);
                g.setColor(Color.GREEN);
                g.drawRect(4, 4, 191, 191);
                BufferedImage img = new BufferedImage(10, 10, 1);
                System.out.println(img.getWidth() + "x" + img.getHeight());
                Graphics2D gi = img.createGraphics();
                int end = 9;
                gi.setColor(Color.WHITE);
                gi.drawLine(0, 0, 0, end);
                gi.drawLine(0, 0, end, 0);
                gi.drawLine(end, end, 0, end);
                gi.drawLine(end, end, end, 0);
                g.drawImage((Image)img, 111, 100, null);
                g.drawImage((Image)img, 100, 110, null);
                Rectangle rect = new Rectangle(100, 100, 10, 10);
                g.draw(rect);
                g.drawRect(6, 6, 2, 2);
                g.setColor(Color.WHITE);
                g.drawLine(7, 9, 7, 15);
                g.setColor(Color.BLUE);
                g.draw(this.getBounds());
            }
            if ((test & 2) == 2) {
                g.setColor(Color.BLACK);
                g.setXORMode(Color.WHITE);
                g.drawRect(10, 10, 20, 20);
                g.drawLine(20, 20, 40, 40);
                g.drawRect(1, 1, 197, 197);
                this.createRect("TestRect1", 15, 40, 30, 40).setVisible(true).setFixed(true);
                this.createRect("TestRect2", 5, 150, 40, 35).setVisible(true);
                this.createRect("TestRect3", 155, 5, 30, 40).setVisible(true);
                this.createRect("TestRect4", 155, 150, 40, 35).setVisible(true);
            }
        }
    }

    public static class CenteredProportionalRectangleSelector
    extends ProportionalRectangleSelector {
        public CenteredProportionalRectangleSelector(int w, int h) {
            super(w, h);
        }

        public CenteredProportionalRectangleSelector(Dimension d) {
            super(d);
        }

        public CenteredProportionalRectangleSelector(ProportionProvider d) {
            super(d);
        }

        @Override
        protected Point getOrigin(VisibleRectBorder b) {
            return b.getRect().getCenter();
        }

        @Override
        protected Point getRectP1(Point origin, Dimension d) {
            Point p = new Point(origin);
            p.translate(-BufferedComponent.toInt(d.getWidth()), -BufferedComponent.toInt(d.getHeight()));
            return p;
        }
    }

    public static class ProportionalRectangleSelector
    extends RectangleSelector {
        private ProportionProvider proportion;

        public ProportionalRectangleSelector(Dimension d) {
            this.proportion = new ProportionProvider.Proportion(d);
        }

        public ProportionalRectangleSelector(ProportionProvider d) {
            this.proportion = d;
        }

        public ProportionalRectangleSelector(int w, int h) {
            this(new Dimension(w, h));
        }

        public ProportionProvider getProportionProvider() {
            ProportionProvider p = null;
            if (this.getVisibleRect() != null) {
                p = this.getVisibleRect().getProportionProvider();
            }
            return p == null ? this.proportion : p;
        }

        public void setProportionProvider(ProportionProvider proportion) {
            this.proportion = proportion;
        }

        @Override
        protected Dimension adjustDimension(Dimension d) {
            double dx = d.getWidth();
            double dy = d.getHeight();
            double sx = Math.abs(dx);
            double sy = Math.abs(dy);
            double prop = this.getProportionProvider().getProportion();
            double ax = sy * prop;
            double ay = sx / prop;
            Dimension adjust = new Dimension(0, 0);
            if (ax > sx) {
                adjust = new Dimension(BufferedComponent.toInt((ax - sx) * Math.signum(dx)), 0);
                sx = ax;
            }
            if (ay > sy) {
                adjust = new Dimension(0, BufferedComponent.toInt((ay - sy) * Math.signum(dy)));
                sy = ay;
            }
            int nx = BufferedComponent.toInt(sx * Math.signum(dx));
            int ny = BufferedComponent.toInt(sy * Math.signum(dy));
            return new ExtendedDimension(nx, ny, adjust);
        }

        @Override
        protected Cursor getCursor(Dimension d) {
            if (d instanceof ExtendedDimension) {
                ExtendedDimension ed = (ExtendedDimension)d;
                double ax = ed.getAdjustment().getWidth();
                if (-20.0 > ax || ax > 20.0) {
                    if (d.getHeight() > 0.0) {
                        return Cursor.getPredefinedCursor(9);
                    }
                    return Cursor.getPredefinedCursor(8);
                }
                double ay = ed.getAdjustment().getHeight();
                if (-20.0 > ay || ay > 20.0) {
                    if (d.getWidth() > 0.0) {
                        return Cursor.getPredefinedCursor(11);
                    }
                    return Cursor.getPredefinedCursor(10);
                }
            }
            return super.getCursor(d);
        }

        protected class ExtendedDimension
        extends Dimension {
            private Dimension adjust;

            public ExtendedDimension(int width, int height, Dimension adjust) {
                super(width, height);
                this.adjust = adjust;
            }

            public Dimension getAdjustment() {
                return this.adjust;
            }
        }
    }

    public static class CenteredRectangleSelector
    extends RectangleSelector {
        @Override
        protected Point getRectP1(Point origin, Dimension d) {
            Point p = new Point(origin);
            p.translate(-BufferedComponent.toInt(d.getWidth()), -BufferedComponent.toInt(d.getHeight()));
            return p;
        }

        @Override
        protected Point getOrigin(VisibleRectBorder b) {
            return b.getRect().getCenter();
        }
    }

    public static class DefaultRectEventListener
    implements RectEventListener {
        @Override
        public void buttonClicked(RectEvent e) {
        }

        @Override
        public void stateChanged(RectStateEvent e) {
        }
    }

    public static class RectStateEvent {
        private VisibleRect rect;

        public RectStateEvent(VisibleRect r) {
            this.rect = r;
        }

        public VisibleRect getRect() {
            return this.rect;
        }
    }

    public static class ClickEvent
    extends EventObject {
        private MouseEvent evt;

        public ClickEvent(Object source, MouseEvent e) {
            super(source);
            this.evt = e;
        }

        public MouseEvent getMouseEvent() {
            return this.evt;
        }

        public BufferedComponent getComponent() {
            return (BufferedComponent)((JComponent)this.getMouseEvent().getSource()).getParent();
        }

        public boolean isShiftDown() {
            return this.evt.isShiftDown();
        }

        public boolean isMetaDown() {
            return this.evt.isMetaDown();
        }

        public boolean isControlDown() {
            return this.evt.isControlDown();
        }

        public boolean isAltGraphDown() {
            return this.evt.isAltGraphDown();
        }

        public boolean isAltDown() {
            return this.evt.isAltDown();
        }

        public int getY() {
            return this.evt.getY();
        }

        public int getX() {
            return this.evt.getX();
        }

        public Point getPoint() {
            return this.evt.getPoint();
        }

        public int getClickCount() {
            return this.evt.getClickCount();
        }

        public int getButton() {
            return this.evt.getButton();
        }

        public String getDescription() {
            return "button " + this.getButton() + " " + this.getClickCount() + "x at (" + this.getX() + "," + this.getY() + ")";
        }
    }

    public static interface PaintHandler {
        public void paintComponent(Graphics var1);
    }
}

