/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;

public class ButtonPanel
extends JPanel {
    private int lines = 1;

    public ButtonPanel() {
        this.addComponentListener(new ComponentAdapter(){
            private boolean active;

            @Override
            public void componentResized(ComponentEvent e) {
                ButtonPanel p = (ButtonPanel)e.getComponent();
                if (!this.active) {
                    this.active = true;
                    p.updatePreferredSize();
                    this.active = false;
                }
            }
        });
    }

    private void updatePreferredSize() {
        int l = 0;
        int y = -1;
        for (Component c : this.getComponents()) {
            if (y >= c.getY()) continue;
            y = c.getY();
            ++l;
        }
        if (l != this.getLines()) {
            this.setLines(l);
        }
    }

    @Override
    public void validate() {
        this.updatePreferredSize();
        super.validate();
    }

    public void setLines(int lines) {
        if (lines != this.lines) {
            this.lines = lines;
            this.revalidate();
            this.repaint();
        }
    }

    public int getLines() {
        return this.lines;
    }

    public Dimension getPreferredUISize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension p = super.getPreferredSize();
        return new Dimension(p.width, p.height * this.lines);
    }
}

