/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.DnDTreeModel;
import com.mandelsoft.swing.IJTree;
import com.mandelsoft.swing.ITreeModel;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DnDJTree
extends IJTree {
    private TreeTransferHandler transfer;
    private ContextMenuHandler ctxmenu;
    private Listener listener;

    public DnDJTree() {
        this._setupDnDJTree();
    }

    public DnDJTree(Object[] value) {
        super(value);
        this._setupDnDJTree();
    }

    public DnDJTree(Vector<?> value) {
        super(value);
        this._setupDnDJTree();
    }

    public DnDJTree(Hashtable<?, ?> value) {
        super(value);
        this._setupDnDJTree();
    }

    public DnDJTree(TreeNode root) {
        super(root);
        this._setupDnDJTree();
    }

    public DnDJTree(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
        this._setupDnDJTree();
    }

    public DnDJTree(TreeModel newModel) {
        super(newModel);
        this._setupDnDJTree();
    }

    private void _setupDnDJTree() {
        this.transfer = this.createTreeTransferHandler();
        this.setTransferHandler(this.transfer);
        this.setDropMode();
    }

    @Override
    public DnDTreeModel getModel() {
        return (DnDTreeModel)super.getModel();
    }

    @Override
    public void setModel(TreeModel dataModel) {
        this.setModel((DnDTreeModel)dataModel);
    }

    @Override
    public void setModel(ITreeModel dataModel) {
        this.setModel((DnDTreeModel)dataModel);
    }

    public void setModel(DnDTreeModel dataModel) {
        super.setModel(dataModel);
        this.setDropMode();
    }

    private void setDropMode() {
        DropMode mode = null;
        if (this.getModel() != null) {
            mode = this.getModel().getDropMode();
        }
        if (mode != null) {
            this.setDragEnabled(true);
            this.setDropMode(mode);
        } else {
            this.setDragEnabled(false);
        }
    }

    protected TreeTransferHandler createTreeTransferHandler() {
        return new TreeTransferHandler();
    }

    public synchronized void setContextMenuHandler(ContextMenuHandler h) {
        if (h == null) {
            if (this.ctxmenu != null) {
                this.removeMouseListener(this.listener);
            }
        } else if (this.ctxmenu == null) {
            if (this.listener == null) {
                this.listener = new Listener();
            }
            this.addMouseListener(this.listener);
        }
        this.ctxmenu = h;
    }

    public static interface ContextMenuHandler {
        public void handleContextMenu(DnDJTree var1, MouseEvent var2, TreePath var3);
    }

    protected class TreeTransferHandler
    extends TransferHandler {
        private Transferable trans = null;

        protected TreeTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return ((DnDJTree)info.getComponent()).getModel().canImport(new DnDTreeModel.TransferSupport(info));
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            this.trans = ((DnDJTree)c).getModel().createTransferable(new DnDTreeModel.DragLocation((DnDJTree)c));
            return this.trans;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return ((DnDJTree)c).getModel().getSourceActions();
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            if (!info.isDrop()) {
                return false;
            }
            return ((DnDJTree)info.getComponent()).getModel().importData(new DnDTreeModel.TransferSupport(info));
        }

        @Override
        protected void exportDone(JComponent c, Transferable data, int action) {
            if (this.trans != null) {
                ((DnDJTree)c).getModel().exportDone(this.trans, action);
            }
            this.trans = null;
        }
    }

    private class Listener
    extends MouseAdapter {
        private Listener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handlePopup(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handlePopup(e);
        }

        public void handlePopup(MouseEvent e) {
            if (e.isPopupTrigger() && DnDJTree.this.ctxmenu != null) {
                TreePath p = DnDJTree.this.getPathForLocation(e.getX(), e.getY());
                DnDJTree.this.ctxmenu.handleContextMenu(DnDJTree.this, e, p);
            }
        }
    }

    public static class DefaultModel
    extends IJTree.DefaultModel
    implements DnDTreeModel {
        public DefaultModel(TreeNode root) {
            super(root);
        }

        public DefaultModel(TreeNode root, boolean asksAllowsChildren) {
            super(root, asksAllowsChildren);
        }

        @Override
        public DropMode getDropMode() {
            return null;
        }

        @Override
        public int getSourceActions() {
            return 0;
        }

        @Override
        public Transferable createTransferable(DnDTreeModel.DragLocation loc) {
            return null;
        }

        @Override
        public void exportDone(Transferable data, int action) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean canImport(DnDTreeModel.TransferSupport info) {
            return false;
        }

        @Override
        public boolean importData(DnDTreeModel.TransferSupport info) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

