/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import java.awt.Container;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.DropMode;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.TransferHandler;

public interface DnDListModel
extends ListModel {
    public DropMode getDropMode();

    public int getSourceActions();

    public Transferable createTransferable(DragLocation var1);

    public void exportDone(Transferable var1, int var2);

    public boolean canImport(TransferSupport var1);

    public boolean importData(TransferSupport var1);

    public static class DragLocation {
        private JList list;

        public DragLocation(JList t) {
            this.list = t;
        }

        public JList getComponent() {
            return this.list;
        }

        public int[] getSelectedRows() {
            int[] n = null;
            int[] t = this.list.getSelectedIndices();
            if (t != null) {
                n = new int[t.length];
                for (int i = 0; i < t.length; ++i) {
                    n[i] = t[i];
                }
            }
            return n;
        }
    }

    public static class TransferSupport {
        TransferHandler.TransferSupport orig;
        DropLocation location;

        TransferSupport(TransferHandler.TransferSupport orig) {
            this.orig = orig;
            this.location = new DropLocation(orig);
        }

        public void setShowDropLocation(boolean showDropLocation) {
            this.orig.setShowDropLocation(showDropLocation);
        }

        public void setDropAction(int dropAction) {
            this.orig.setDropAction(dropAction);
        }

        public boolean isDrop() {
            return this.orig.isDrop();
        }

        public boolean isDataFlavorSupported(DataFlavor df) {
            return this.orig.isDataFlavorSupported(df);
        }

        public int getUserDropAction() {
            return this.orig.getUserDropAction();
        }

        public Transferable getTransferable() {
            return this.orig.getTransferable();
        }

        public int getSourceDropActions() {
            return this.orig.getSourceDropActions();
        }

        public DropLocation getDropLocation() {
            return this.location;
        }

        public int getDropAction() {
            return this.orig.getDropAction();
        }

        public DataFlavor[] getDataFlavors() {
            return this.orig.getDataFlavors();
        }

        public JList getComponent() {
            return this.location.getComponent();
        }
    }

    public static class DropLocation
    extends TransferHandler.DropLocation {
        private JList list;
        private int index;
        private boolean insert;

        public DropLocation(TransferHandler.TransferSupport trans) {
            super(trans.getDropLocation().getDropPoint());
            if (trans.getDropLocation() instanceof JList.DropLocation) {
                JList.DropLocation location = (JList.DropLocation)trans.getDropLocation();
                this.list = (JList)trans.getComponent();
                this.index = location.getIndex();
                this.insert = location.isInsert();
            } else {
                Container c = (Container)trans.getComponent();
                this.list = (JList)c.getComponent(0);
                this.index = 1;
                this.insert = true;
            }
        }

        public DropLocation(Point dropPoint, JList list, int index, boolean insert) {
            super(dropPoint);
            this.list = list;
            this.index = index;
            this.insert = insert;
        }

        public boolean isInsert() {
            return this.insert;
        }

        public int getIndex() {
            return this.index;
        }

        public JList getComponent() {
            return this.list;
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "[dropPoint=" + this.getDropPoint() + ",index=" + this.getIndex() + ",insert=" + this.isInsert() + "]";
        }
    }
}

