/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.Interval2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class IntervalList
implements Iterable<Interval2D> {
    private List<Interval2D> list = new ArrayList<Interval2D>();

    public IntervalList() {
    }

    public IntervalList(Interval2D iv) {
        this();
        this.add(iv);
    }

    public IntervalList(Collection<Interval2D> l) {
        this();
        for (Interval2D iv : l) {
            this.add(iv);
        }
    }

    public IntervalList(IntervalList l) {
        this();
        for (Interval2D iv : l) {
            this.add(iv);
        }
    }

    @Override
    public Iterator<Interval2D> iterator() {
        return this.list.iterator();
    }

    public void add(Interval2D a) {
        int i;
        Interval2D next = null;
        int in = 0;
        for (i = 0; i < this.list.size(); ++i) {
            Interval2D iv = this.list.get(i);
            if (!(iv.getMax() >= a.getMin())) continue;
            next = iv;
            in = i;
            break;
        }
        if (next == null) {
            this.list.add(a);
        } else {
            Interval2D end = null;
            int ie = this.list.size();
            for (i = in; i < this.list.size(); ++i) {
                Interval2D iv = this.list.get(i);
                if (iv.getMin() > a.getMax()) {
                    ie = i;
                    break;
                }
                end = iv;
            }
            Interval2D n = new Interval2D(next.getMin() < a.getMin() ? next.getMin() : a.getMin(), end == null ? a.getMax() : end.getMax());
            this.list.add(ie, n);
            while (ie-- > in) {
                this.list.remove(in);
            }
        }
    }

    public void sub(Interval2D a) {
        Interval2D next = null;
        int in = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            Interval2D iv = this.list.get(i);
            if (!(iv.getMax() >= a.getMin())) continue;
            next = iv;
            in = i;
            break;
        }
        if (next != null) {
            if (next.getMin() < a.getMin()) {
                this.list.add(in++, new Interval2D(next.getMin(), a.getMin()));
            }
            while (next != null && next.getMax() <= a.getMax()) {
                this.list.remove(in);
                next = in < this.list.size() ? this.list.get(in) : null;
            }
            if (next != null && next.getMin() < a.getMax()) {
                this.list.remove(in);
                this.list.add(in, new Interval2D(next.getMax(), a.getMax()));
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Interval2D iv : this.list) {
            sb.append("[");
            sb.append(iv.getMin());
            sb.append("-");
            sb.append(iv.getMax());
            sb.append("]");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        IntervalList list = new IntervalList();
        Interval2D i1 = new Interval2D(3.0, 4.0);
        list.add(i1);
        System.out.println("a: " + list);
        i1 = new Interval2D(11.0, 20.0);
        list.add(i1);
        System.out.println("b: " + list);
        i1 = new Interval2D(6.0, 8.0);
        list.add(i1);
        System.out.println("c: " + list);
        i1 = new Interval2D(1.0, 2.0);
        list.add(i1);
        System.out.println("d: " + list);
        i1 = new Interval2D(2.0, 3.0);
        list.add(i1);
        System.out.println("e: " + list);
        i1 = new Interval2D(2.0, 11.0);
        list.add(i1);
        System.out.println("f: " + list);
        i1 = new Interval2D(6.0, 8.0);
        list.sub(i1);
        System.out.println("sa: " + list);
        i1 = new Interval2D(10.0, 12.0);
        list.sub(i1);
        System.out.println("sb: " + list);
        i1 = new Interval2D(5.0, 9.0);
        list.sub(i1);
        System.out.println("sc: " + list);
        i1 = new Interval2D(0.0, 2.0);
        list.sub(i1);
        System.out.println("sd: " + list);
        i1 = new Interval2D(2.0, 3.0);
        list.sub(i1);
        System.out.println("se: " + list);
        i1 = new Interval2D(19.0, 21.0);
        list.sub(i1);
        System.out.println("sf: " + list);
        i1 = new Interval2D(15.0, 19.0);
        list.sub(i1);
        System.out.println("sg: " + list);
        i1 = new Interval2D(4.0, 13.0);
        list.sub(i1);
        System.out.println("sh: " + list);
        i1 = new Interval2D(0.0, 20.0);
        list.sub(i1);
        System.out.println("si: " + list);
    }
}

