/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.geom.Rectangle2D;

public class RectanglePoint {
    public static RectanglePoint MIDDLE_LEFT = new RectanglePoint("MiddleLeft", 0.0, 0.5, 11);
    public static RectanglePoint MIDDLE_TOP = new RectanglePoint("MiddleTop", 0.5, 0.0, 8);
    public static RectanglePoint MIDDLE_RIGHT = new RectanglePoint("MiddleRight", 1.0, 0.5, 10);
    public static RectanglePoint MIDDLE_BOTTOM = new RectanglePoint("MiddleBottom", 0.5, 1.0, 9);
    private String name;
    private double factorX;
    private double factorY;
    private int cursor;

    protected RectanglePoint(String name, double factorX, double factorY, int cursor) {
        this.name = name;
        this.factorX = factorX;
        this.factorY = factorY;
        this.cursor = cursor;
    }

    public String getName() {
        return this.name;
    }

    public double getFactorX() {
        return this.factorX;
    }

    public double getFactorY() {
        return this.factorY;
    }

    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(this.cursor);
    }

    public Point getPoint(Rectangle2D rect) {
        return new Point((int)(rect.getX() + this.getFactorX() * (rect.getWidth() - 1.0)), (int)(rect.getY() + this.getFactorY() * (rect.getHeight() - 1.0)));
    }

    public String toString() {
        return "Point " + this.getName();
    }
}

